package org.lsst.ccs.subsystem.refrig.data;

import java.util.ArrayList;
import java.util.List;

/**
 *  Contains the state of a cryo compressor.
 *
 *  The order of the elements in each list determines the order they appear in the GUI
 *
 *  @author Owen Saxton
 */
public class CryoCompState extends CompState {
    
    public static final List<Integer> SWITCHES = new ArrayList<>();
    static {
        SWITCHES.add(SW_ENABLE);
        SWITCHES.add(SW_LIGHTS);
        SWITCHES.add(SW_HEATER);
        SWITCHES.add(SW_NORMAL_OP_VALVE);
        SWITCHES.add(SW_COOLANT_VALVE);
        SWITCHES.add(SW_EVAC_VALVE);
        SWITCHES.add(SW_SURGE_HEATER);
    }
    public static final List<Integer> LATCHES = new ArrayList<>();
    static {
        LATCHES.add(LATCH_DISCHARGE_TEMP);
        LATCHES.add(LATCH_DISCHARGE_PRESS);
        LATCHES.add(LATCH_SUCTION_TEMP);
        LATCHES.add(LATCH_OIL_LEVEL);
        LATCHES.add(LATCH_AFTER_COOLER);
        LATCHES.add(LATCH_POWER);
        LATCHES.add(LATCH_SENSORS_VALID);
        LATCHES.add(LATCH_SMOKE_DETC);
        LATCHES.add(LATCH_EXT_PERMIT);
    }
    public static final List<Integer> CONDITIONS = new ArrayList<>();
    static {
        CONDITIONS.add(COND_KEYSWITCH_ON);
        CONDITIONS.add(COND_CMP_ENABLED);
        CONDITIONS.add(COND_CMP_WAITING);
        CONDITIONS.add(COND_CMP_POWERED);
        CONDITIONS.add(COND_DISC_TEMP_VALID);
        CONDITIONS.add(COND_DISC_PRESS_VALID);
        CONDITIONS.add(COND_SUCT_TEMP_VALID);
        CONDITIONS.add(COND_SUCT_PRESS_VALID);
        CONDITIONS.add(COND_OIL_LEVEL_VALID);
        CONDITIONS.add(COND_CURRENT_VALID);
        CONDITIONS.add(COND_VOLTAGE_VALID);
        CONDITIONS.add(COND_CURR_SENSOR_ERR);
        CONDITIONS.add(COND_LATCHES_CLEAR);
        CONDITIONS.add(COND_CMP_OFF_6HRS);
        CONDITIONS.add(COND_POWER_LED);
    }

    public CryoCompState() {
        super(TYPE_CRYO);
    }

    private static final long serialVersionUID = -3831159437346594065L;
}
