package org.lsst.ccs.subsystem.refrig.data;

import java.io.Serializable;

/**
 ***************************************************
 *
 *  Contains the state of the refrigeration system
 *
 *  @author Owen Saxton
 *
 ***************************************************
 */
public class RefrigState0 extends RefrigState implements Serializable {

    public static final int
        MAIN_POWER_STATE_BIT     = 0,  // Main power on
        MAIN_TRIPPED_STATE_BIT   = 1,  // Main power tripped
        LOAD_POWER_STATE_BIT     = 2,  // Load (heater) power on
        LOAD_TRIP_ENAB_STATE_BIT = 3,  // Load power trip enabled
        LOAD_TEMP_LOOP_STATE_BIT = 4,  // Load (heater) power control loop on
        MAIN_LOAD_ONLY_STATE_BIT = 5,  // Main power only to load
        MAIN_POWER_STATE         = 1 << MAIN_POWER_STATE_BIT,
        MAIN_TRIPPED_STATE       = 1 << MAIN_TRIPPED_STATE_BIT,
        LOAD_POWER_STATE         = 1 << LOAD_POWER_STATE_BIT,
        LOAD_TRIP_ENAB_STATE     = 1 << LOAD_TRIP_ENAB_STATE_BIT,
        LOAD_TEMP_LOOP_STATE     = 1 << LOAD_TEMP_LOOP_STATE_BIT,
        MAIN_LOAD_ONLY_STATE     = 1 << MAIN_LOAD_ONLY_STATE_BIT;
    
 
    public RefrigState0(int systemState, int tickMillis, double loadPower,
                        double loadTemp) {
        setSystemState(systemState);
        setTickMillis(tickMillis);
        setHeaterPower(loadPower);
        setLoadTemp(loadTemp);
    }

    @Override
    public int getSystemState() {
        return super.getSystemState();
    }

    public double getLoadPower() {
        return getHeaterPower();
    }

    private static final long serialVersionUID = 4147609551885898664L;
}
