package org.lsst.ccs.subsystem.refrig.data;

import java.io.Serializable;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;

/**
 ******************************************************************
 *
 *  Contains information describing the full refrigeration state.
 *
 *  Sent on the status bus upon startup or upon request.
 *
 *  @author Owen Saxton
 *
 ******************************************************************
 */
public class RefrigFullState0 implements Serializable {

    final private RefrigState0 refrigState;
    final private MonitorFullState monitorState;

    public RefrigFullState0(RefrigState0 rState, MonitorFullState mState) {
        refrigState = rState;
        monitorState = mState;
    }

    public RefrigState0 getRefrigState() {
        return refrigState;
    }

    public MonitorFullState getMonitorFullState() {
        return monitorState;
    }

    private static final long serialVersionUID = -8907272115738819522L;
}
