package org.lsst.ccs.subsystem.refrig.data;

import java.io.Serializable;

/**
 ***************************************************************************
 **
 **  Contains the state of the refrigeration system
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class RefrigState implements Serializable {

    private static final long serialVersionUID = 6739595190601298159L;

    public static final String KEY = "RefrigState";

    public final static int
        MAIN_POWER_STATE_BIT     = 0,  // Main power on
        MAIN_TRIPPED_STATE_BIT   = 1,  // Main power tripped
        LOAD_POWER_STATE_BIT     = 2,  // Load (heater) power on
        LOAD_TRIP_ENAB_STATE_BIT = 3,  // Load power trip enabled
        LOAD_TEMP_LOOP_STATE_BIT = 4,  // Load (heater) power control loop on
        MAIN_LOAD_ONLY_STATE_BIT = 5,  // Main power only to load
        MAIN_POWER_STATE         = 1 << MAIN_POWER_STATE_BIT,
        MAIN_TRIPPED_STATE       = 1 << MAIN_TRIPPED_STATE_BIT,
        LOAD_POWER_STATE         = 1 << LOAD_POWER_STATE_BIT,
        LOAD_TRIP_ENAB_STATE     = 1 << LOAD_TRIP_ENAB_STATE_BIT,
        LOAD_TEMP_LOOP_STATE     = 1 << LOAD_TEMP_LOOP_STATE_BIT,
        MAIN_LOAD_ONLY_STATE     = 1 << MAIN_LOAD_ONLY_STATE_BIT;

    int    systemState,        // Mask of state bits
           tickMillis;         // Data status update period (ms)
    double loadPower,          // Heat load power set point
           loadTemp;           // Heat load temperature set point
    
 
/* *** Can't have more than one constructor as of toolkit 1.6
    public RefrigState(int systemState, int tickMillis)
    {
        this(systemState, tickMillis, 0, 0);
    }
*/

    public RefrigState(int systemState, int tickMillis, double loadPower,
                       double loadTemp)
    {
        this.systemState  = systemState;
        this.tickMillis   = tickMillis;
        this.loadPower    = loadPower;
        this.loadTemp     = loadTemp;
    }
    
    public int getSystemState()
    {
        return systemState;
    }

    public int getTickMillis()
    {
        return tickMillis;
    }

    public double getLoadPower()
    {
        return loadPower;
    }

    public double getLoadTemp()
    {
        return loadTemp;
    }

    @Override
    public String toString()
    {
        return "systemState=" + systemState
                + ", tickMillis=" + tickMillis
                + ", loadPower=" + loadPower
                + "' loadTemp=" + loadTemp;
    }

}
