package org.lsst.ccs.subsystem.refrig.status;

import org.lsst.ccs.bus.Status;
import org.lsst.ccs.subsystem.refrig.data.RefrigState;

/**
 ***************************************************************************
 **
 **  Contains the state of the refrigeration system
 **
 **  <p>
 **  Sent on the status bus whenever the state changes
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class RefrigStateStatus extends Status {

    private static final long serialVersionUID = 1728192739910618487L;
    
    final private RefrigState refrigState;

    public RefrigStateStatus(RefrigState refrigState)
    {
        super();
        this.refrigState = refrigState;
    }
    
    public RefrigState getRefrigState()
    {
        return refrigState;
    }

    @Override
    public String toString()
    {
        return "RefrigStateStatus(" + origin + ") @" + timeStamp + " : ["
                 + state + "] " + summary + " (" + refrigState + ")";
    }

}
