package org.lsst.ccs.subsystem.refrig.data;

import java.io.Serializable;

/**
 ***************************************************************************
 **
 **  Contains the state of the refrigeration system
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class RefrigState implements Serializable {

    private static final long serialVersionUID = -7596686997197536530L;

    public final static int
        MAIN_POWER_STATE_BIT     = 0,
        MAIN_TRIPPED_STATE_BIT   = 1,
        LOAD_POWER_STATE_BIT     = 2,
        LOAD_TRIP_ENAB_STATE_BIT = 3,
        MAIN_POWER_STATE         = 1 << MAIN_POWER_STATE_BIT,
        MAIN_TRIPPED_STATE       = 1 << MAIN_TRIPPED_STATE_BIT,
        LOAD_POWER_STATE         = 1 << LOAD_POWER_STATE_BIT,
        LOAD_TRIP_ENAB_STATE     = 1 << LOAD_TRIP_ENAB_STATE_BIT;

    int    systemState,        // Mask of state bits
           tickMillis;         // Data status update period (ms)
    double power;              // Heater power set point
 
    public RefrigState(int systemState, int tickMillis)
    {
        this(systemState, tickMillis, 0);
    }

    public RefrigState(int systemState, int tickMillis, double power)
    {
        this.systemState  = systemState;
        this.tickMillis   = tickMillis;
        this.power        = power;
    }
    
    public int getSystemState()
    {
        return systemState;
    }

    public int getTickMillis()
    {
        return tickMillis;
    }

    public double getPower()
    {
        return power;
    }

    @Override
    public String toString()
    {
        return "systemState=" + systemState
                + ", tickMillis=" + tickMillis
                + ", power=" + power;
    }

}
