package org.lsst.ccs.subsystem.refrig.data;

import java.io.Serializable;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;

/**
 ***************************************************************************
 **
 **  Contains information describing the full refrigeration state.
 **
 **  <p>
 **  Sent on the status bus upon startup or upon request.
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class RefrigFullState implements Serializable {

    private static final long serialVersionUID = -1207498930489246631L;
    
    final private RefrigState refrigState;
    final private MonitorFullState monitorState;

    public RefrigFullState(RefrigState rState, MonitorFullState mState) {
        refrigState = rState;
        monitorState = mState;
    }

    public RefrigState getRefrigState() {
        return refrigState;
    }

    public MonitorFullState getMonitorFullState() {
        return monitorState;
    }

}
