package org.lsst.ccs.subsystem.refrig.data;

import java.io.Serializable;
import java.util.BitSet;

/**
 ***************************************************************************
 **
 **  Contains the state of the refrigeration system
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class RefrigState implements Serializable 
{
    
    public final static int
        MAIN_POWER_STATE_BIT     = 0,
        MAIN_TRIPPED_STATE_BIT   = 1,
        LOAD_POWER_STATE_BIT     = 2,
        LOAD_TRIP_ENAB_STATE_BIT = 3,
        MAIN_POWER_STATE         = 1 << MAIN_POWER_STATE_BIT,
        MAIN_TRIPPED_STATE       = 1 << MAIN_TRIPPED_STATE_BIT,
        LOAD_POWER_STATE         = 1 << LOAD_POWER_STATE_BIT,
        LOAD_TRIP_ENAB_STATE     = 1 << LOAD_TRIP_ENAB_STATE_BIT;

    BitSet goodChans,          //  Good channels
           onlineChans,        //  Online channels
           lowLimitChange,     //  Channels with low limit changes
           highLimitChange;    //  Channels with high limit changes

    int    systemState,        // Mask of state bits
           tickMillis;         // Data status update period (ms)
 
    public RefrigState(int systemState, BitSet goodChans, BitSet onlineChans,
                       BitSet lowLimitChange, BitSet highLimitChange,
                       int tickMillis)
    {
        this.systemState     = systemState;
        this.goodChans       = goodChans;
        this.onlineChans     = onlineChans;
        this.lowLimitChange  = lowLimitChange;
        this.highLimitChange = highLimitChange;
        this.tickMillis      = tickMillis;
    }
    
    public int getSystemState()
    {
        return systemState;
    }

    public BitSet getGoodChans()
    {
        return goodChans;
    }

    public BitSet getOnlineChans()
    {
        return onlineChans;
    }

    public BitSet getLowLimitChange()
    {
        return lowLimitChange;
    }

    public BitSet getHighLimitChange()
    {
        return highLimitChange;
    }

    public int getTickMillis()
    {
        return tickMillis;
    }

    @Override
    public String toString()
    {
        return "systemState=" + systemState
                + ", goodChans=" + goodChans
                + ", onlineChans=" + onlineChans
                + ", lowLimitChange=" + lowLimitChange
                + ", highLimitChange=" + highLimitChange
                + ", tickMillis=" + tickMillis;
    }

}
