/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig.data;

import java.io.Serializable;

public class RefrigState
implements Serializable {
    public static final int MAX_CHANNELS = 24;
    public static final int MAIN_POWER_STATE_BIT = 24;
    public static final int MAIN_TRIPPED_STATE_BIT = 25;
    public static final int LOAD_POWER_STATE_BIT = 26;
    public static final int LOAD_TRIP_ENAB_STATE_BIT = 27;
    public static final int CHANNEL_STATE_MASK = 0xFFFFFF;
    public static final int MAIN_POWER_STATE = 0x1000000;
    public static final int MAIN_TRIPPED_STATE = 0x2000000;
    public static final int LOAD_POWER_STATE = 0x4000000;
    public static final int LOAD_TRIP_ENAB_STATE = 0x8000000;
    int systemState;
    int onlineState;
    int lowLimitChange;
    int highLimitChange;
    int tickMillis;

    public RefrigState(int systemState, int onlineState, int lowLimitChange, int highLimitChange, int tickMillis) {
        this.systemState = systemState;
        this.onlineState = onlineState;
        this.lowLimitChange = lowLimitChange;
        this.highLimitChange = highLimitChange;
        this.tickMillis = tickMillis;
    }

    public int getSystemState() {
        return this.systemState;
    }

    public int getOnlineState() {
        return this.onlineState;
    }

    public int getLowLimitChange() {
        return this.lowLimitChange;
    }

    public int getHighLimitChange() {
        return this.highLimitChange;
    }

    public int getTickMillis() {
        return this.tickMillis;
    }

    public String toString() {
        return "systemState=" + this.toHex(this.systemState) + ", onlineState=" + this.toHex(this.onlineState) + ", lowLimitChange=" + this.toHex(this.lowLimitChange) + ", highLimitChange=" + this.toHex(this.highLimitChange) + ", tickMillis=" + this.tickMillis;
    }

    private String toHex(int value) {
        return String.format("0x%x", value);
    }
}

