package org.lsst.ccs.subsystem.refrig.data;

import java.io.Serializable;

/**
 ***************************************************************************
 **
 **  Contains the state of the refrigeration system
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class RefrigState implements Serializable 
{
    
    public final static int
        MAX_CHANNELS             = 24,
        MAIN_POWER_STATE_BIT     = 24,
        MAIN_TRIPPED_STATE_BIT   = 25,
        LOAD_POWER_STATE_BIT     = 26,
        LOAD_TRIP_ENAB_STATE_BIT = 27,
        CHANNEL_STATE_MASK       = (1 << MAX_CHANNELS) - 1,
        MAIN_POWER_STATE         = 1 << MAIN_POWER_STATE_BIT,
        MAIN_TRIPPED_STATE       = 1 << MAIN_TRIPPED_STATE_BIT,
        LOAD_POWER_STATE         = 1 << LOAD_POWER_STATE_BIT,
        LOAD_TRIP_ENAB_STATE     = 1 << LOAD_TRIP_ENAB_STATE_BIT;

    int systemState,        // Mask of good channels plus power states
        onlineState,        // Mask of online channels
        lowLimitChange,     // Mask of channels with low limit changes
        highLimitChange,    // Mask of channels with high limit changes
        tickMillis;         // Data status update period (ms)
 
    public RefrigState(int systemState, int onlineState, int lowLimitChange,
                       int highLimitChange, int tickMillis)
    {
        this.systemState     = systemState;
        this.onlineState     = onlineState;
        this.lowLimitChange  = lowLimitChange;
        this.highLimitChange = highLimitChange;
        this.tickMillis      = tickMillis;
    }
    
    public int getSystemState()
    {
        return systemState;
    }

    public int getOnlineState()
    {
        return onlineState;
    }

    public int getLowLimitChange()
    {
        return lowLimitChange;
    }

    public int getHighLimitChange()
    {
        return highLimitChange;
    }

    public int getTickMillis()
    {
        return tickMillis;
    }

    @Override
    public String toString()
    {
        return "systemState=" + toHex(systemState)
                + ", onlineState=" + toHex(onlineState)
                + ", lowLimitChange=" + toHex(lowLimitChange)
                + ", highLimitChange=" + toHex(highLimitChange)
                + ", tickMillis=" + tickMillis;
    }

    private String toHex(int value)
    {
        return String.format("0x%x", value);
    }

}
