package org.lsst.ccs.subsystem.refrig.data;

import java.io.Serializable;

/**
 ***************************************************************************
 **
 **  Contains the description of a refrigeration data channel
 **
 **  @author turri
 **
 ***************************************************************************
 */
public class RefrigChannel implements Serializable {
    
    private String name, description, units;
    private double lowLimit, highLimit;
    private float value;


    public RefrigChannel(String name, String description, String units,
                         double lowLimit, double highLimit, float value) {
        this.name = name;
        this.description = description;
        this.units = units;
        this.lowLimit = lowLimit;
        this.highLimit = highLimit;
        this.value = value;
    }
    
    public void setDescription(String description) {
        this.description = description;
    }

    public void setHighLimit(double highLimit) {
        this.highLimit = highLimit;
    }

    public void setLowLimit(double lowLimit) {
        this.lowLimit = lowLimit;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public String getDescription() {
        return description;
    }

    public double getHighLimit() {
        return highLimit;
    }

    public double getLowLimit() {
        return lowLimit;
    }

    public String getName() {
        return name;
    }

    public String getUnits() {
        return units;
    }

    public float getValue() {
        return value;
    }
    
}
