package org.lsst.ccs.subsystem.refrig.data;

import java.io.Serializable;

/**
 ***************************************************************************
 **
 **  Contains the state of the refrigeration system
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class RefrigState implements Serializable 
{
    
    public final static int
        MAIN_POWER_STATE_BIT = 16,
        LOAD_POWER_STATE_BIT = 17,
        LOAD_TRIP_STATE_BIT  = 18,
        CHANNEL_STATE_MASK   = 0xffff;

    int systemState,        // Mask of good channels plus power states
        lowLimitChange,     // Mask of channels with low limit changes
        highLimitChange,    // Mask of channels with high limit changes
        tickMillis;         // Data status update period (ms)
 
    public RefrigState(int systemState, int lowLimitChange,
                       int highLimitChange, int tickMillis)
    {
        this.systemState     = systemState;
        this.lowLimitChange  = lowLimitChange;
        this.highLimitChange = highLimitChange;
        this.tickMillis      = tickMillis;
    }
    
    public int getSystemState()
    {
        return systemState;
    }

    public int getLowLimitChange()
    {
        return lowLimitChange;
    }

    public int getHighLimitChange()
    {
        return highLimitChange;
    }

    public int getTickMillis()
    {
        return tickMillis;
    }

    @Override
    public String toString()
    {
        return "systemState=" + toHex(systemState)
                + ", lowLimitChange=" + toHex(lowLimitChange)
                + ", highLimitChange=" + toHex(highLimitChange)
                + ", tickMillis=" + tickMillis;
    }

    private String toHex(int value)
    {
        return String.format("0x%x", value);
    }

}
