package org.lsst.ccs.subsystem.refrig.data;

import java.io.Serializable;
import java.util.ArrayList;

/**
 ***************************************************************************
 **
 **  Contains information describing the full refrigeration state
 **
 **  <p>
 **  Sent on the status bus upon startup or upon request.
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class RefrigFullState implements Serializable {
    
    private ArrayList<RefrigChannel> channels = new ArrayList<RefrigChannel>();
    private RefrigState refrigState;

    public void addChannel(RefrigChannel chan) {
        channels.add(chan);
    }
    
    public ArrayList<RefrigChannel> getChannelArray() {
        return channels;
    }
    
    public void setRefrigState(RefrigState state) {
        refrigState = state;
    }

    public RefrigState getRefrigState() {
        return refrigState;
    }

}
