/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.alertaction;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.MessagingService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.actions.MpmAction;

public class MpmActionClient
implements HasLifecycle,
AgentPresenceListener {
    private static final Logger LOG = Logger.getLogger(MpmActionClient.class.getName());
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;

    public void init() {
        ((MessagingService)this.agent.getAgentService(MessagingService.class)).getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        this.propertiesService.setAgentProperty(MpmAction.getClientName(), "");
    }

    public void shutdown() {
        ((MessagingService)this.agent.getAgentService(MessagingService.class)).getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener((AgentPresenceListener)this);
    }

    public void connecting(AgentInfo ... agents) {
        for (AgentInfo ai : agents) {
            if (!ai.hasAgentProperty(MpmAction.getManagerName())) continue;
            LOG.log(Level.INFO, "Publishing raised alert summary for agent {0}", ai.getName());
            this.agent.getScheduler().execute(() -> this.alertService.publishRaisedAlertSummary());
            break;
        }
    }
}

