/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.ProtocolFamily;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.channels.DatagramChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Collections;
import java.util.List;
import org.jgroups.util.StackType;
import org.jgroups.util.Util;

public class mcast {
    protected DatagramSocket sock;
    protected InetAddress mcast_addr = null;
    protected InetAddress bind_addr = null;
    protected int mcast_port = 5555;
    protected final int local_port;
    protected final int ttl;
    protected static final boolean can_bind_to_mcast_addr = Util.checkForLinux() && !Util.checkForAndroid() || Util.checkForSolaris() || Util.checkForHp() || Util.checkForMac();
    protected static final StackType ip_version = Util.getIpStackType();
    protected static final ProtocolFamily prot_family = ip_version == StackType.IPv6 ? StandardProtocolFamily.INET6 : StandardProtocolFamily.INET;

    public mcast(InetAddress bind_addr, int local_port, InetAddress mcast_addr, int mcast_port, int ttl) {
        this.bind_addr = bind_addr;
        this.local_port = local_port;
        this.mcast_addr = mcast_addr;
        this.mcast_port = mcast_port;
        this.ttl = ttl;
    }

    protected void start() throws Exception {
        Receiver r = null;
        AbstractInterruptibleChannel channel = null;
        try {
            r = new Receiver();
            r.start();
            channel = ((DatagramChannel)DatagramChannel.open(prot_family).setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)this.ttl)).bind(new InetSocketAddress(this.bind_addr, this.local_port));
            this.sock = ((DatagramChannel)channel).socket();
        }
        catch (Exception ex) {
            if (channel != null) {
                channel.close();
            }
            if (r != null) {
                r.kill();
                r.interrupt();
            }
            throw ex;
        }
        DataInputStream in = new DataInputStream(System.in);
        while (true) {
            System.out.print("> ");
            try {
                String line = Util.readLine(in);
                byte[] buf = line.getBytes();
                DatagramPacket packet = new DatagramPacket(buf, buf.length, this.mcast_addr, this.mcast_port);
                this.sock.send(packet);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) throws Exception {
        InetAddress mcast_addr = null;
        InetAddress bind_addr = null;
        int mcast_port = 5555;
        int local_port = 0;
        int ttl = 8;
        try {
            for (int i = 0; i < args.length; ++i) {
                String tmp = args[i];
                if ("-help".equals(tmp)) {
                    mcast.help();
                    return;
                }
                if ("-bind_addr".equals(tmp)) {
                    bind_addr = InetAddress.getByName(args[++i]);
                    continue;
                }
                if ("-mcast_addr".equals(tmp)) {
                    mcast_addr = InetAddress.getByName(args[++i]);
                    continue;
                }
                if ("-mcast_port".equals(tmp)) {
                    mcast_port = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-port".equals(tmp)) {
                    local_port = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-ttl".equals(tmp)) {
                    ttl = Integer.parseInt(args[++i]);
                    continue;
                }
                mcast.help();
                return;
            }
            if (mcast_addr == null) {
                switch (ip_version) {
                    case IPv4: {
                        mcast_addr = InetAddress.getByName("232.5.5.5");
                        break;
                    }
                    case IPv6: {
                        mcast_addr = InetAddress.getByName("ff0e::8:8:8");
                    }
                }
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
            return;
        }
        mcast mcast2 = new mcast(bind_addr, local_port, mcast_addr, mcast_port, ttl);
        mcast2.start();
    }

    static void help() {
        System.out.println("mcast [-help]\n      [-bind_addr <bind address>]\n      [-port <local port>]\n      [-mcast_addr <multicast address>]\n      [-mcast_port <port for multicast socket>]\n      [-ttl <TTL>]\n(Note that a null bind_addr will join the receiver multicast socket on all interfaces)\n");
    }

    protected void bindToInterfaces(List<NetworkInterface> interfaces, MulticastSocket s) {
        InetSocketAddress tmp_mcast_addr = new InetSocketAddress(this.mcast_addr, this.mcast_port);
        for (NetworkInterface intf : interfaces) {
            try {
                s.joinGroup(tmp_mcast_addr, intf);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected class Receiver
    extends Thread {
        protected MulticastSocket mcast_sock;

        protected Receiver() throws Exception {
            InetSocketAddress saddr = new InetSocketAddress(mcast.this.mcast_addr, mcast.this.mcast_port);
            this.mcast_sock = can_bind_to_mcast_addr ? new MulticastSocket(saddr) : new MulticastSocket(mcast.this.mcast_port);
            if (mcast.this.bind_addr != null) {
                mcast.this.bindToInterfaces(Collections.singletonList(NetworkInterface.getByInetAddress(mcast.this.bind_addr)), this.mcast_sock);
            } else {
                List<NetworkInterface> intf_list = Util.getAllAvailableInterfaces();
                System.out.println("Joining " + saddr + " on interfaces: " + intf_list);
                mcast.this.bindToInterfaces(intf_list, this.mcast_sock);
            }
            System.out.println("Socket=" + this.mcast_sock.getLocalAddress() + ':' + this.mcast_sock.getLocalPort() + ", bind interface=" + this.mcast_sock.getInterface());
        }

        protected void kill() {
            this.mcast_sock.close();
        }

        @Override
        public void run() {
            try {
                while (true) {
                    byte[] buf = new byte[1024];
                    DatagramPacket packet = new DatagramPacket(buf, buf.length);
                    this.mcast_sock.receive(packet);
                    byte[] recv_buf = packet.getData();
                    int recv_len = packet.getLength();
                    System.out.println(new String(recv_buf, 0, recv_len) + " [sender=" + packet.getAddress().getHostAddress() + ':' + packet.getPort() + ']');
                }
            }
            catch (Exception ex) {
                System.err.println("Receiver terminated: " + ex);
                return;
            }
        }
    }
}

