/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb.sim;

import org.lsst.ccs.drivers.reb.sim.SimulationException;

public interface RegisterSet {
    public int baseAddress();

    public int length();

    public void write(int var1, int var2);

    public int read(int var1);

    public static abstract class ReadOnlyLongRegister
    extends SimpleLongRegisterSet {
        ReadOnlyLongRegister(int address) {
            super(address, 1);
        }

        @Override
        long readLong(int index) {
            return this.read();
        }

        @Override
        void writeLong(int index, long longValue) {
            throw new SimulationException("Attempt to write to read-only register");
        }

        public abstract long read();
    }

    public static class ArrayRegisterSet
    extends SimpleRegisterSet {
        private final int[] data;

        ArrayRegisterSet(int address, int[] data) {
            super(address, data.length);
            this.data = data;
        }

        @Override
        int readSimple(int address) {
            return this.data[address];
        }

        @Override
        void writeSimple(int address, int value) {
            this.data[address] = value;
        }
    }

    public static class ConstantRegister
    extends ReadOnlyRegister {
        private final int value;

        public ConstantRegister(int address, int value) {
            super(address);
            this.value = value;
        }

        @Override
        public int read() {
            return this.value;
        }
    }

    public static abstract class WriteOnlyRegister
    extends Register {
        WriteOnlyRegister(int baseAddress) {
            super(baseAddress);
        }

        @Override
        public int read() {
            throw new SimulationException("Attempt to read from write-only register");
        }
    }

    public static abstract class ReadOnlyRegister
    extends Register {
        ReadOnlyRegister(int baseAddress) {
            super(baseAddress);
        }

        @Override
        public void write(int value) {
            throw new SimulationException("Attempt to write to read-only register");
        }
    }

    public static abstract class Register
    implements RegisterSet {
        private final int baseAddress;

        Register(int baseAddress) {
            this.baseAddress = baseAddress;
        }

        @Override
        public int read(int address) {
            this.checkAddress(address);
            return this.read();
        }

        @Override
        public void write(int address, int value) {
            this.checkAddress(address);
            this.write(value);
        }

        @Override
        public int length() {
            return 1;
        }

        @Override
        public int baseAddress() {
            return this.baseAddress;
        }

        public abstract void write(int var1);

        public abstract int read();

        private void checkAddress(int address) {
            if (address != this.baseAddress) {
                throw new SimulationException("Invalid address 0x%08x", address);
            }
        }
    }

    public static abstract class SimpleLongRegisterSet
    extends SimpleRegisterSet {
        private static final long HIGH32BITS = -4294967296L;
        private static final long LOW32BITS = 0xFFFFFFFFL;

        SimpleLongRegisterSet(int address, int length) {
            super(address, 2 * length);
        }

        @Override
        int readSimple(int address) {
            long data = this.readLong(address / 2);
            if (address % 2 == 0) {
                return (int)(data & 0xFFFFFFFFFFFFFFFFL);
            }
            return (int)(data >> 32);
        }

        @Override
        void writeSimple(int address, int value) {
            long longValue = this.readLong(address / 2);
            longValue = address % 2 == 0 ? longValue & 0xFFFFFFFF00000000L | (long)value & 0xFFFFFFFFL : longValue & 0xFFFFFFFFL | (long)value << 32;
            this.writeLong(address / 2, longValue);
        }

        abstract long readLong(int var1);

        abstract void writeLong(int var1, long var2);
    }

    public static class LongArrayRegisterSet
    extends SimpleLongRegisterSet {
        private final long[] data;

        LongArrayRegisterSet(int address, long[] data) {
            super(address, data.length);
            this.data = data;
        }

        @Override
        long readLong(int index) {
            return this.data[index];
        }

        @Override
        void writeLong(int index, long value) {
            this.data[index] = value;
        }
    }

    public static abstract class SimpleRegisterSet
    implements RegisterSet {
        private final int baseAddress;
        private final int length;

        SimpleRegisterSet(int address, int length) {
            this.baseAddress = address;
            this.length = length;
        }

        @Override
        public int read(int address) {
            return this.readSimple(this.checkAddress(address));
        }

        @Override
        public void write(int address, int value) {
            this.writeSimple(this.checkAddress(address), value);
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public int baseAddress() {
            return this.baseAddress;
        }

        private int checkAddress(int address) {
            if (address < this.baseAddress | address >= this.baseAddress + this.length) {
                throw new SimulationException("Invalid address 0x%08x", address);
            }
            return address - this.baseAddress;
        }

        abstract int readSimple(int var1);

        abstract void writeSimple(int var1, int var2);
    }
}

