/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.data.RaisedAlertInstance;
import org.lsst.ccs.bus.states.AlertState;

public class RaisedAlertSummary
implements Serializable {
    private static final long serialVersionUID = -9649721904826248L;
    protected final List<RaisedAlertHistory> raisedAlerts = new CopyOnWriteArrayList<RaisedAlertHistory>();

    public RaisedAlertSummary() {
    }

    public RaisedAlertSummary(RaisedAlertSummary other) {
        for (RaisedAlertHistory history : other.raisedAlerts) {
            this.raisedAlerts.add(new RaisedAlertHistory(history));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RaisedAlertHistory getRaisedAlert(String alertId) {
        List<RaisedAlertHistory> list = this.raisedAlerts;
        synchronized (list) {
            for (RaisedAlertHistory raisedAlert : this.raisedAlerts) {
                if (!raisedAlert.getLatestAlert().getAlertId().equals(alertId)) continue;
                return raisedAlert;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlertState getAlertState() {
        AlertState base = AlertState.NOMINAL;
        List<RaisedAlertHistory> list = this.raisedAlerts;
        synchronized (list) {
            for (RaisedAlertHistory alert : this.raisedAlerts) {
                if (alert.getHighestAlertState().compareTo(base) <= 0) continue;
                base = alert.getHighestAlertState();
            }
            return base;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RaisedAlertHistory> getAllRaisedAlertHistories() {
        List<RaisedAlertHistory> list = this.raisedAlerts;
        synchronized (list) {
            return new HashSet<RaisedAlertHistory>(this.raisedAlerts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Alarm Summary\n");
        List<RaisedAlertHistory> list = this.raisedAlerts;
        synchronized (list) {
            sb.append("Severity : ").append(this.getAlertState()).append("\n");
            for (RaisedAlertHistory alert : this.raisedAlerts) {
                sb.append("Alert: ").append(alert.getLatestAlert().getAlertId()).append(" instances: ").append(alert.getNumberOfInstances()).append(" severity: ").append(alert.getHighestAlertState()).append("\n");
                for (RaisedAlertInstance instance : alert.getRaisedAlertInstancesList()) {
                    sb.append("\t").append(instance.getCause()).append(" (").append(instance.getAlertState()).append("@").append(instance.getCCSTimeStamp().getUTCInstant().toEpochMilli()).append(")\n");
                }
            }
        }
        return sb.toString();
    }
}

