/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.visualization.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.lsst.ccs.visualization.client.Message;

public class DataMessage
extends Message {
    private final int offset;
    private final int stepLength;
    private final int stepOffset;
    private final int dataLength;
    private ByteBuffer data;

    public DataMessage(String imageName, int offset, int stepLength, int stepOffset, ByteBuffer data) {
        this(imageName, offset, stepLength, stepOffset, data.remaining());
        this.data = data;
    }

    private DataMessage(String imageName, int offset, int stepLength, int stepOffset, int dataLength) {
        super(Message.MessageType.DATA, 16, imageName);
        this.offset = offset;
        this.stepLength = stepLength;
        this.stepOffset = stepOffset;
        this.dataLength = dataLength;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getStepLength() {
        return this.stepLength;
    }

    public int getStepOffset() {
        return this.stepOffset;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    @Override
    void encodeAdditional(ByteBuffer bb) {
        bb.putInt(this.offset);
        bb.putInt(this.stepLength);
        bb.putInt(this.stepOffset);
        bb.putInt(this.dataLength);
    }

    @Override
    void encode(SocketChannel out) throws IOException {
        super.encode(out);
        out.write(this.data);
    }

    static Message decode(ByteBuffer bb, CharSequence name) {
        int offset = bb.getInt();
        int stepLength = bb.getInt();
        int stepOffset = bb.getInt();
        int dataLength = bb.getInt();
        return new DataMessage(name.toString(), offset, stepLength, stepOffset, dataLength);
    }

    public String toString() {
        return "DataMessage{imageName=" + this.getImageName() + ", offset=" + this.offset + ", stepLength=" + this.stepLength + ", stepOffset=" + this.stepOffset + ", dataLength=" + this.dataLength + '}';
    }
}

