/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.indexed;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.AbstractDiskCache;
import org.apache.commons.jcs3.auxiliary.disk.behavior.IDiskCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.indexed.IndexedDisk;
import org.apache.commons.jcs3.auxiliary.disk.indexed.IndexedDiskCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.indexed.IndexedDiskElementDescriptor;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.control.group.GroupAttrName;
import org.apache.commons.jcs3.engine.control.group.GroupId;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEvent;
import org.apache.commons.jcs3.engine.stats.StatElement;
import org.apache.commons.jcs3.engine.stats.Stats;
import org.apache.commons.jcs3.engine.stats.behavior.IStats;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.struct.AbstractLRUMap;
import org.apache.commons.jcs3.utils.struct.LRUMap;
import org.apache.commons.jcs3.utils.timing.ElapsedTimer;

public class IndexedDiskCache<K, V>
extends AbstractDiskCache<K, V> {
    private static final Log log = LogManager.getLog(IndexedDiskCache.class);
    protected final String logCacheName;
    private final String fileName;
    private IndexedDisk dataFile;
    private IndexedDisk keyFile;
    private final Map<K, IndexedDiskElementDescriptor> keyHash;
    private final int maxKeySize;
    private File rafDir;
    private boolean doRecycle = true;
    private boolean isRealTimeOptimizationEnabled = true;
    private boolean isShutdownOptimizationEnabled = true;
    private boolean isOptimizing = false;
    private int timesOptimized = 0;
    private volatile Thread currentOptimizationThread;
    private int removeCount = 0;
    private boolean queueInput = false;
    private final ConcurrentSkipListSet<IndexedDiskElementDescriptor> queuedPutList;
    private final ConcurrentSkipListSet<IndexedDiskElementDescriptor> recycle;
    private final IndexedDiskCacheAttributes cattr;
    private int recycleCnt = 0;
    private int startupSize = 0;
    private final AtomicLong bytesFree = new AtomicLong(0L);
    private IDiskCacheAttributes.DiskLimitType diskLimitType = IDiskCacheAttributes.DiskLimitType.COUNT;
    private final AtomicInteger hitCount = new AtomicInteger(0);
    protected ReentrantReadWriteLock storageLock = new ReentrantReadWriteLock();

    public IndexedDiskCache(IndexedDiskCacheAttributes cacheAttributes) {
        this(cacheAttributes, null);
    }

    public IndexedDiskCache(IndexedDiskCacheAttributes cattr, IElementSerializer elementSerializer) {
        super(cattr);
        this.setElementSerializer(elementSerializer);
        this.cattr = cattr;
        this.maxKeySize = cattr.getMaxKeySize();
        this.isRealTimeOptimizationEnabled = cattr.getOptimizeAtRemoveCount() > 0;
        this.isShutdownOptimizationEnabled = cattr.isOptimizeOnShutdown();
        this.logCacheName = "Region [" + this.getCacheName() + "] ";
        this.diskLimitType = cattr.getDiskLimitType();
        this.fileName = this.getCacheName().replaceAll("[^a-zA-Z0-9-_\\.]", "_");
        this.keyHash = this.createInitialKeyMap();
        this.queuedPutList = new ConcurrentSkipListSet<IndexedDiskElementDescriptor>(new PositionComparator());
        this.recycle = new ConcurrentSkipListSet();
        try {
            this.initializeFileSystem(cattr);
            this.initializeKeysAndData(cattr);
            this.setAlive(true);
            log.info("{0}: Indexed Disk Cache is alive.", this.logCacheName);
            if (this.isRealTimeOptimizationEnabled && this.keyHash.size() > 0) {
                this.doOptimizeRealTime();
            }
        }
        catch (IOException e) {
            log.error("{0}: Failure initializing for fileName: {1} and directory: {2}", this.logCacheName, this.fileName, this.rafDir.getAbsolutePath(), e);
        }
    }

    private void initializeFileSystem(IndexedDiskCacheAttributes cattr) {
        this.rafDir = cattr.getDiskPath();
        log.info("{0}: Cache file root directory: {1}", this.logCacheName, this.rafDir);
    }

    private void initializeKeysAndData(IndexedDiskCacheAttributes cattr) throws IOException {
        this.dataFile = new IndexedDisk(new File(this.rafDir, this.fileName + ".data"), this.getElementSerializer());
        this.keyFile = new IndexedDisk(new File(this.rafDir, this.fileName + ".key"), this.getElementSerializer());
        if (cattr.isClearDiskOnStartup()) {
            log.info("{0}: ClearDiskOnStartup is set to true.  Ingnoring any persisted data.", this.logCacheName);
            this.initializeEmptyStore();
        } else if (this.keyFile.length() > 0L) {
            this.initializeStoreFromPersistedData();
        } else {
            this.initializeEmptyStore();
        }
    }

    private void initializeEmptyStore() throws IOException {
        this.keyHash.clear();
        if (this.dataFile.length() > 0L) {
            this.dataFile.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeStoreFromPersistedData() throws IOException {
        this.loadKeys();
        if (this.keyHash.isEmpty()) {
            this.dataFile.reset();
        } else {
            boolean isOk = this.checkKeyDataConsistency(false);
            if (!isOk) {
                this.keyHash.clear();
                this.keyFile.reset();
                this.dataFile.reset();
                log.warn("{0}: Corruption detected. Resetting data and keys files.", this.logCacheName);
            } else {
                IndexedDiskCache indexedDiskCache = this;
                synchronized (indexedDiskCache) {
                    this.startupSize = this.keyHash.size();
                }
            }
        }
    }

    protected void loadKeys() {
        log.debug("{0}: Loading keys for {1}", () -> this.logCacheName, () -> this.keyFile.toString());
        this.storageLock.writeLock().lock();
        try {
            this.keyHash.clear();
            HashMap keys = (HashMap)this.keyFile.readObject(new IndexedDiskElementDescriptor(0L, (int)this.keyFile.length() - 4));
            if (keys != null) {
                log.debug("{0}: Found {1} in keys file.", this.logCacheName, keys.size());
                this.keyHash.putAll(keys);
                log.info("{0}: Loaded keys from [{1}], key count: {2}; up to {3} will be available.", () -> this.logCacheName, () -> this.fileName, () -> this.keyHash.size(), () -> this.maxKeySize);
            }
            if (log.isTraceEnabled()) {
                this.dump(false);
            }
        }
        catch (Exception e) {
            log.error("{0}: Problem loading keys for file {1}", this.logCacheName, this.fileName, e);
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
    }

    private boolean checkKeyDataConsistency(boolean checkForDedOverlaps) {
        ElapsedTimer timer = new ElapsedTimer();
        log.debug("{0}: Performing inital consistency check", this.logCacheName);
        boolean isOk = true;
        long fileLength = 0L;
        try {
            fileLength = this.dataFile.length();
            for (Map.Entry<K, IndexedDiskElementDescriptor> e : this.keyHash.entrySet()) {
                IndexedDiskElementDescriptor ded = e.getValue();
                isOk = ded.pos + 4L + (long)ded.len <= fileLength;
                if (isOk) continue;
                log.warn("{0}: The dataFile is corrupted!\n raf.length() = {1}\n ded.pos = {2}", this.logCacheName, fileLength, ded.pos);
                break;
            }
            if (isOk && checkForDedOverlaps) {
                isOk = this.checkForDedOverlaps(this.createPositionSortedDescriptorList());
            }
        }
        catch (IOException e) {
            log.error(e);
            isOk = false;
        }
        log.info("{0}: Finished inital consistency check, isOk = {1} in {2}", this.logCacheName, isOk, timer.getElapsedTimeString());
        return isOk;
    }

    protected boolean checkForDedOverlaps(IndexedDiskElementDescriptor[] sortedDescriptors) {
        ElapsedTimer timer = new ElapsedTimer();
        boolean isOk = true;
        long expectedNextPos = 0L;
        for (int i = 0; i < sortedDescriptors.length; ++i) {
            IndexedDiskElementDescriptor ded = sortedDescriptors[i];
            if (expectedNextPos > ded.pos) {
                log.error("{0}: Corrupt file: overlapping deds {1}", this.logCacheName, ded);
                isOk = false;
                break;
            }
            expectedNextPos = ded.pos + 4L + (long)ded.len;
        }
        log.debug("{0}: Check for DED overlaps took {1} ms.", () -> this.logCacheName, () -> timer.getElapsedTime());
        return isOk;
    }

    protected void saveKeys() {
        try {
            log.info("{0}: Saving keys to: {1}, key count: {2}", () -> this.logCacheName, () -> this.fileName, () -> this.keyHash.size());
            this.keyFile.reset();
            HashMap<K, IndexedDiskElementDescriptor> keys = new HashMap<K, IndexedDiskElementDescriptor>();
            keys.putAll(this.keyHash);
            if (keys.size() > 0) {
                this.keyFile.writeObject(keys, 0L);
            }
            log.info("{0}: Finished saving keys.", this.logCacheName);
        }
        catch (IOException e) {
            log.error("{0}: Problem storing keys.", this.logCacheName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processUpdate(ICacheElement<K, V> ce) {
        if (!this.isAlive()) {
            log.error("{0}: No longer alive; aborting put of key = {1}", () -> this.logCacheName, () -> ce.getKey());
            return;
        }
        log.debug("{0}: Storing element on disk, key: {1}", () -> this.logCacheName, () -> ce.getKey());
        IndexedDiskElementDescriptor ded = null;
        IndexedDiskElementDescriptor old = null;
        try {
            byte[] data = this.getElementSerializer().serialize(ce);
            this.storageLock.writeLock().lock();
            try {
                old = this.keyHash.get(ce.getKey());
                if (old != null && data.length <= old.len) {
                    ded = old;
                    ded.len = data.length;
                } else {
                    IndexedDiskElementDescriptor rep;
                    ded = new IndexedDiskElementDescriptor(this.dataFile.length(), data.length);
                    if (this.doRecycle && (rep = this.recycle.ceiling(ded)) != null) {
                        this.recycle.remove(rep);
                        ded = rep;
                        ded.len = data.length;
                        ++this.recycleCnt;
                        this.adjustBytesFree(ded, false);
                        log.debug("{0}: using recycled ded {1} rep.len = {2} ded.len = {3}", this.logCacheName, ded.pos, rep.len, ded.len);
                    }
                    this.keyHash.put(ce.getKey(), ded);
                    if (this.queueInput) {
                        this.queuedPutList.add(ded);
                        log.debug("{0}: added to queued put list. {1}", () -> this.logCacheName, () -> this.queuedPutList.size());
                    }
                    if (old != null) {
                        this.addToRecycleBin(old);
                    }
                }
                this.dataFile.write(ded, data);
            }
            finally {
                this.storageLock.writeLock().unlock();
            }
            log.debug("{0}: Put to file: {1}, key: {2}, position: {3}, size: {4}", this.logCacheName, this.fileName, ce.getKey(), ded.pos, ded.len);
        }
        catch (IOException e) {
            log.error("{0}: Failure updating element, key: {1} old: {2}", this.logCacheName, ce.getKey(), old, e);
        }
    }

    @Override
    protected ICacheElement<K, V> processGet(K key) {
        if (!this.isAlive()) {
            log.error("{0}: No longer alive so returning null for key = {1}", this.logCacheName, key);
            return null;
        }
        log.debug("{0}: Trying to get from disk: {1}", this.logCacheName, key);
        ICacheElement<K, V> object = null;
        try {
            this.storageLock.readLock().lock();
            try {
                object = this.readElement(key);
            }
            finally {
                this.storageLock.readLock().unlock();
            }
            if (object != null) {
                this.hitCount.incrementAndGet();
            }
        }
        catch (IOException ioe) {
            log.error("{0}: Failure getting from disk, key = {1}", this.logCacheName, key, ioe);
            this.reset();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, ICacheElement<K, V>> processGetMatching(String pattern) {
        HashMap elements = new HashMap();
        HashSet<K> keyArray = null;
        this.storageLock.readLock().lock();
        try {
            keyArray = new HashSet<K>(this.keyHash.keySet());
        }
        finally {
            this.storageLock.readLock().unlock();
        }
        Set matchingKeys = this.getKeyMatcher().getMatchingKeysFromArray(pattern, keyArray);
        for (Object key : matchingKeys) {
            ICacheElement element = this.processGet(key);
            if (element == null) continue;
            elements.put(key, element);
        }
        return elements;
    }

    private ICacheElement<K, V> readElement(K key) throws IOException {
        ICacheElement object = null;
        IndexedDiskElementDescriptor ded = this.keyHash.get(key);
        if (ded != null) {
            log.debug("{0}: Found on disk, key: ", this.logCacheName, key);
            try {
                ICacheElement readObject;
                object = readObject = (ICacheElement)this.dataFile.readObject(ded);
            }
            catch (IOException e) {
                log.error("{0}: IO Exception, Problem reading object from file", this.logCacheName, e);
                throw e;
            }
            catch (Exception e) {
                log.error("{0}: Exception, Problem reading object from file", this.logCacheName, e);
                throw new IOException(this.logCacheName + "Problem reading object from disk.", e);
            }
        }
        return object;
    }

    @Override
    public Set<K> getKeySet() throws IOException {
        HashSet<K> keys = new HashSet<K>();
        this.storageLock.readLock().lock();
        try {
            keys.addAll(this.keyHash.keySet());
        }
        finally {
            this.storageLock.readLock().unlock();
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean processRemove(K key) {
        if (!this.isAlive()) {
            log.error("{0}: No longer alive so returning false for key = {1}", this.logCacheName, key);
            return false;
        }
        if (key == null) {
            return false;
        }
        boolean reset = false;
        boolean removed = false;
        try {
            this.storageLock.writeLock().lock();
            removed = key instanceof String && key.toString().endsWith(":") ? this.performPartialKeyRemoval((String)key) : (key instanceof GroupAttrName && ((GroupAttrName)key).attrName == null ? this.performGroupRemoval(((GroupAttrName)key).groupId) : this.performSingleKeyRemoval(key));
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
        if (reset) {
            this.reset();
        }
        if (removed) {
            this.doOptimizeRealTime();
        }
        return removed;
    }

    private boolean performPartialKeyRemoval(String key) {
        boolean removed = false;
        LinkedList<K> itemsToRemove = new LinkedList<K>();
        for (K k : this.keyHash.keySet()) {
            if (!(k instanceof String) || !k.toString().startsWith(key)) continue;
            itemsToRemove.add(k);
        }
        for (Object fullKey : itemsToRemove) {
            this.performSingleKeyRemoval(fullKey);
            removed = true;
        }
        return removed;
    }

    private boolean performGroupRemoval(GroupId key) {
        boolean removed = false;
        LinkedList<K> itemsToRemove = new LinkedList<K>();
        for (K k : this.keyHash.keySet()) {
            if (!(k instanceof GroupAttrName) || !((GroupAttrName)k).groupId.equals(key)) continue;
            itemsToRemove.add(k);
        }
        for (Object fullKey : itemsToRemove) {
            this.performSingleKeyRemoval(fullKey);
            removed = true;
        }
        return removed;
    }

    private boolean performSingleKeyRemoval(K key) {
        IndexedDiskElementDescriptor ded = this.keyHash.remove(key);
        boolean removed = ded != null;
        this.addToRecycleBin(ded);
        log.debug("{0}: Disk removal: Removed from key hash, key [{1}] removed = {2}", this.logCacheName, key, removed);
        return removed;
    }

    @Override
    public void processRemoveAll() {
        ICacheEvent<String> cacheEvent = this.createICacheEvent(this.getCacheName(), "all", "removeAll");
        try {
            this.reset();
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    private void reset() {
        log.info("{0}: Resetting cache", this.logCacheName);
        try {
            this.storageLock.writeLock().lock();
            if (this.dataFile != null) {
                this.dataFile.close();
            }
            File dataFileTemp = new File(this.rafDir, this.fileName + ".data");
            Files.delete(dataFileTemp.toPath());
            if (this.keyFile != null) {
                this.keyFile.close();
            }
            File keyFileTemp = new File(this.rafDir, this.fileName + ".key");
            Files.delete(keyFileTemp.toPath());
            this.dataFile = new IndexedDisk(dataFileTemp, this.getElementSerializer());
            this.keyFile = new IndexedDisk(keyFileTemp, this.getElementSerializer());
            this.recycle.clear();
            this.keyHash.clear();
        }
        catch (IOException e) {
            log.error("{0}: Failure resetting state", this.logCacheName, e);
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
    }

    private Map<K, IndexedDiskElementDescriptor> createInitialKeyMap() {
        Map keyMap = null;
        if (this.maxKeySize >= 0) {
            keyMap = this.diskLimitType == IDiskCacheAttributes.DiskLimitType.COUNT ? new LRUMapCountLimited(this.maxKeySize) : new LRUMapSizeLimited(this.maxKeySize);
            log.info("{0}: Set maxKeySize to: \"{1}\"", this.logCacheName, this.maxKeySize);
        } else {
            keyMap = new HashMap();
            log.info("{0}: Set maxKeySize to unlimited", this.logCacheName);
        }
        return keyMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDispose() {
        ICacheEvent<String> cacheEvent = this.createICacheEvent(this.getCacheName(), "none", "dispose");
        try {
            Thread t = new Thread(this::disposeInternal, "IndexedDiskCache-DisposalThread");
            t.start();
            try {
                t.join(60000L);
            }
            catch (InterruptedException ex) {
                log.error("{0}: Interrupted while waiting for disposal thread to finish.", this.logCacheName, ex);
            }
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    protected void disposeInternal() {
        if (!this.isAlive()) {
            log.error("{0}: Not alive and dispose was called, filename: {1}", this.logCacheName, this.fileName);
            return;
        }
        this.setAlive(false);
        Thread optimizationThread = this.currentOptimizationThread;
        if (this.isRealTimeOptimizationEnabled && optimizationThread != null) {
            log.debug("{0}: In dispose, optimization already in progress; waiting for completion.", this.logCacheName);
            try {
                optimizationThread.join();
            }
            catch (InterruptedException e) {
                log.error("{0}: Unable to join current optimization thread.", this.logCacheName, e);
            }
        } else if (this.isShutdownOptimizationEnabled && this.getBytesFree() > 0L) {
            this.optimizeFile();
        }
        this.saveKeys();
        try {
            log.debug("{0}: Closing files, base filename: {1}", this.logCacheName, this.fileName);
            this.dataFile.close();
            this.dataFile = null;
            this.keyFile.close();
            this.keyFile = null;
        }
        catch (IOException e) {
            log.error("{0}: Failure closing files in dispose, filename: {1}", this.logCacheName, this.fileName, e);
        }
        log.info("{0}: Shutdown complete.", this.logCacheName);
    }

    protected void addToRecycleBin(IndexedDiskElementDescriptor ded) {
        if (ded != null) {
            this.storageLock.readLock().lock();
            try {
                this.adjustBytesFree(ded, true);
                if (this.doRecycle) {
                    this.recycle.add(ded);
                    log.debug("{0}: recycled ded {1}", this.logCacheName, ded);
                }
            }
            finally {
                this.storageLock.readLock().unlock();
            }
        }
    }

    protected void doOptimizeRealTime() {
        if (this.isRealTimeOptimizationEnabled && !this.isOptimizing && this.removeCount++ >= this.cattr.getOptimizeAtRemoveCount()) {
            this.isOptimizing = true;
            log.info("{0}: Optimizing file. removeCount [{1}] OptimizeAtRemoveCount [{2}]", this.logCacheName, this.removeCount, this.cattr.getOptimizeAtRemoveCount());
            if (this.currentOptimizationThread == null) {
                this.storageLock.writeLock().lock();
                try {
                    if (this.currentOptimizationThread == null) {
                        this.currentOptimizationThread = new Thread(() -> {
                            this.optimizeFile();
                            this.currentOptimizationThread = null;
                        }, "IndexedDiskCache-OptimizationThread");
                    }
                }
                finally {
                    this.storageLock.writeLock().unlock();
                }
                if (this.currentOptimizationThread != null) {
                    this.currentOptimizationThread.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void optimizeFile() {
        ElapsedTimer timer = new ElapsedTimer();
        ++this.timesOptimized;
        log.info("{0}: Beginning Optimization #{1}", this.logCacheName, this.timesOptimized);
        IndexedDiskElementDescriptor[] defragList = null;
        this.storageLock.writeLock().lock();
        try {
            this.queueInput = true;
            this.doRecycle = false;
            defragList = this.createPositionSortedDescriptorList();
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
        long expectedNextPos = this.defragFile(defragList, 0L);
        this.storageLock.writeLock().lock();
        try {
            try {
                if (!this.queuedPutList.isEmpty()) {
                    defragList = this.queuedPutList.toArray(new IndexedDiskElementDescriptor[this.queuedPutList.size()]);
                    expectedNextPos = this.defragFile(defragList, expectedNextPos);
                }
                this.dataFile.truncate(expectedNextPos);
            }
            catch (IOException e) {
                log.error("{0}: Error optimizing queued puts.", this.logCacheName, e);
            }
            this.removeCount = 0;
            this.resetBytesFree();
            this.recycle.clear();
            this.queuedPutList.clear();
            this.queueInput = false;
            this.doRecycle = true;
            this.isOptimizing = false;
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
        log.info("{0}: Finished #{1}, Optimization took {2}", this.logCacheName, this.timesOptimized, timer.getElapsedTimeString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long defragFile(IndexedDiskElementDescriptor[] defragList, long startingPos) {
        long i222;
        ElapsedTimer timer = new ElapsedTimer();
        long preFileSize = 0L;
        long postFileSize = 0L;
        long expectedNextPos = 0L;
        try {
            preFileSize = this.dataFile.length();
            expectedNextPos = startingPos;
            for (int i222 = 0; i222 < defragList.length; ++i222) {
                this.storageLock.writeLock().lock();
                try {
                    if (expectedNextPos != defragList[i222].pos) {
                        this.dataFile.move(defragList[i222], expectedNextPos);
                    }
                    expectedNextPos = defragList[i222].pos + 4L + (long)defragList[i222].len;
                    continue;
                }
                finally {
                    this.storageLock.writeLock().unlock();
                }
            }
            postFileSize = this.dataFile.length();
            i222 = expectedNextPos;
        }
        catch (IOException e) {
            try {
                log.error("{0}: Error occurred during defragmentation.", this.logCacheName, e);
            }
            catch (Throwable throwable) {
                log.info("{0}: Defragmentation took {1}. File Size (before={2}) (after={3}) (truncating to {4})", this.logCacheName, timer.getElapsedTimeString(), preFileSize, postFileSize, expectedNextPos);
                throw throwable;
            }
            log.info("{0}: Defragmentation took {1}. File Size (before={2}) (after={3}) (truncating to {4})", this.logCacheName, timer.getElapsedTimeString(), preFileSize, postFileSize, expectedNextPos);
            return 0L;
        }
        log.info("{0}: Defragmentation took {1}. File Size (before={2}) (after={3}) (truncating to {4})", this.logCacheName, timer.getElapsedTimeString(), preFileSize, postFileSize, expectedNextPos);
        return i222;
    }

    private IndexedDiskElementDescriptor[] createPositionSortedDescriptorList() {
        ArrayList<IndexedDiskElementDescriptor> defragList = new ArrayList<IndexedDiskElementDescriptor>(this.keyHash.values());
        Collections.sort(defragList, new PositionComparator());
        return defragList.toArray(new IndexedDiskElementDescriptor[0]);
    }

    @Override
    public int getSize() {
        return this.keyHash.size();
    }

    protected int getRecyleBinSize() {
        return this.recycle.size();
    }

    protected int getRecyleCount() {
        return this.recycleCnt;
    }

    protected long getBytesFree() {
        return this.bytesFree.get();
    }

    private void resetBytesFree() {
        this.bytesFree.set(0L);
    }

    private void adjustBytesFree(IndexedDiskElementDescriptor ded, boolean add) {
        if (ded != null) {
            int amount = ded.len + 4;
            if (add) {
                this.bytesFree.addAndGet(amount);
            } else {
                this.bytesFree.addAndGet(-amount);
            }
        }
    }

    protected long getDataFileSize() throws IOException {
        long size = 0L;
        this.storageLock.readLock().lock();
        try {
            if (this.dataFile != null) {
                size = this.dataFile.length();
            }
        }
        finally {
            this.storageLock.readLock().unlock();
        }
        return size;
    }

    public void dump() {
        this.dump(true);
    }

    public void dump(boolean dumpValues) {
        if (log.isTraceEnabled()) {
            log.trace("{0}: [dump] Number of keys: {1}", this.logCacheName, this.keyHash.size());
            for (Map.Entry<K, IndexedDiskElementDescriptor> e : this.keyHash.entrySet()) {
                K key = e.getKey();
                IndexedDiskElementDescriptor ded = e.getValue();
                log.trace("{0}: [dump] Disk element, key: {1}, pos: {2}, len: {3}" + (dumpValues ? ", val: " + this.get(key) : ""), this.logCacheName, key, ded.pos, ded.len);
            }
        }
    }

    @Override
    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.cattr;
    }

    @Override
    public synchronized IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Indexed Disk Cache");
        ArrayList elems = new ArrayList();
        elems.add(new StatElement<Boolean>("Is Alive", this.isAlive()));
        elems.add(new StatElement<Integer>("Key Map Size", this.keyHash != null ? this.keyHash.size() : -1));
        try {
            elems.add(new StatElement<Long>("Data File Length", this.dataFile != null ? this.dataFile.length() : -1L));
        }
        catch (IOException e) {
            log.error(e);
        }
        elems.add(new StatElement<Integer>("Max Key Size", this.maxKeySize));
        elems.add(new StatElement<AtomicInteger>("Hit Count", this.hitCount));
        elems.add(new StatElement<AtomicLong>("Bytes Free", this.bytesFree));
        elems.add(new StatElement<Integer>("Optimize Operation Count", this.removeCount));
        elems.add(new StatElement<Integer>("Times Optimized", this.timesOptimized));
        elems.add(new StatElement<Integer>("Recycle Count", this.recycleCnt));
        elems.add(new StatElement<Integer>("Recycle Bin Size", this.recycle.size()));
        elems.add(new StatElement<Integer>("Startup Size", this.startupSize));
        IStats sStats = super.getStatistics();
        elems.addAll(sStats.getStatElements());
        stats.setStatElements(elems);
        return stats;
    }

    protected int getTimesOptimized() {
        return this.timesOptimized;
    }

    @Override
    protected String getDiskLocation() {
        return this.dataFile.getFilePath();
    }

    public class LRUMapCountLimited
    extends LRUMap<K, IndexedDiskElementDescriptor> {
        public LRUMapCountLimited(int maxKeySize) {
            super(maxKeySize);
        }

        @Override
        protected void processRemovedLRU(K key, IndexedDiskElementDescriptor value) {
            IndexedDiskCache.this.addToRecycleBin(value);
            log.debug("{0}: Removing key: [{1}] from key store.", IndexedDiskCache.this.logCacheName, key);
            log.debug("{0}: Key store size: [{1}].", IndexedDiskCache.this.logCacheName, this.size());
            IndexedDiskCache.this.doOptimizeRealTime();
        }
    }

    public class LRUMapSizeLimited
    extends AbstractLRUMap<K, IndexedDiskElementDescriptor> {
        public static final String TAG = "orig";
        private AtomicInteger contentSize;
        private int maxSize;

        public LRUMapSizeLimited() {
            this(-1);
        }

        public LRUMapSizeLimited(int maxKeySize) {
            this.maxSize = maxKeySize;
            this.contentSize = new AtomicInteger(0);
        }

        private void subLengthFromCacheSize(IndexedDiskElementDescriptor value) {
            this.contentSize.addAndGet((value.len + 4) / -1024 - 1);
        }

        private void addLengthToCacheSize(IndexedDiskElementDescriptor value) {
            this.contentSize.addAndGet((value.len + 4) / 1024 + 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IndexedDiskElementDescriptor put(K key, IndexedDiskElementDescriptor value) {
            IndexedDiskElementDescriptor oldValue = null;
            try {
                oldValue = super.put(key, value);
            }
            finally {
                if (value != null) {
                    this.addLengthToCacheSize(value);
                }
                if (oldValue != null) {
                    this.subLengthFromCacheSize(oldValue);
                }
            }
            return oldValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IndexedDiskElementDescriptor remove(Object key) {
            IndexedDiskElementDescriptor value = null;
            try {
                IndexedDiskElementDescriptor indexedDiskElementDescriptor = value = (IndexedDiskElementDescriptor)super.remove(key);
                return indexedDiskElementDescriptor;
            }
            finally {
                if (value != null) {
                    this.subLengthFromCacheSize(value);
                }
            }
        }

        @Override
        protected void processRemovedLRU(K key, IndexedDiskElementDescriptor value) {
            if (value != null) {
                this.subLengthFromCacheSize(value);
            }
            IndexedDiskCache.this.addToRecycleBin(value);
            log.debug("{0}: Removing key: [{1}] from key store.", IndexedDiskCache.this.logCacheName, key);
            log.debug("{0}: Key store size: [{1}].", IndexedDiskCache.this.logCacheName, this.size());
            IndexedDiskCache.this.doOptimizeRealTime();
        }

        @Override
        protected boolean shouldRemove() {
            return this.maxSize > 0 && this.contentSize.get() > this.maxSize && this.size() > 0;
        }
    }

    protected static final class PositionComparator
    implements Comparator<IndexedDiskElementDescriptor>,
    Serializable {
        private static final long serialVersionUID = -8387365338590814113L;

        protected PositionComparator() {
        }

        @Override
        public int compare(IndexedDiskElementDescriptor ded1, IndexedDiskElementDescriptor ded2) {
            if (ded1.pos < ded2.pos) {
                return -1;
            }
            if (ded1.pos == ded2.pos) {
                return 0;
            }
            return 1;
        }
    }
}

