/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.struct;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.jcs3.engine.control.group.GroupAttrName;
import org.apache.commons.jcs3.engine.stats.StatElement;
import org.apache.commons.jcs3.engine.stats.Stats;
import org.apache.commons.jcs3.engine.stats.behavior.IStats;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.struct.DoubleLinkedList;
import org.apache.commons.jcs3.utils.struct.LRUElementDescriptor;

public abstract class AbstractLRUMap<K, V>
implements Map<K, V> {
    private static final Log log = LogManager.getLog(AbstractLRUMap.class);
    private final DoubleLinkedList<LRUElementDescriptor<K, V>> list;
    private final Map<K, LRUElementDescriptor<K, V>> map;
    private final Lock lock = new ReentrantLock();
    private long hitCnt = 0L;
    private long missCnt = 0L;
    private long putCnt = 0L;

    public AbstractLRUMap() {
        this.list = new DoubleLinkedList();
        this.map = new ConcurrentHashMap<K, LRUElementDescriptor<K, V>>();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.map.clear();
            this.list.removeAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Collection<V> values() {
        return this.map.values().stream().map(value -> value.getPayload()).collect(Collectors.toList());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> source) {
        if (source != null) {
            source.entrySet().forEach((? super T entry) -> this.put(entry.getKey(), entry.getValue()));
        }
    }

    @Override
    public V get(Object key) {
        V retVal;
        log.debug("getting item  for key {0}", key);
        LRUElementDescriptor<K, V> me = this.map.get(key);
        if (me == null) {
            ++this.missCnt;
            retVal = null;
        } else {
            ++this.hitCnt;
            retVal = (V)me.getPayload();
            this.list.makeFirst(me);
        }
        if (me == null) {
            log.debug("LRUMap miss for {0}", key);
        } else {
            log.debug("LRUMap hit for {0}", key);
        }
        return retVal;
    }

    public V getQuiet(Object key) {
        V ce = null;
        LRUElementDescriptor<K, V> me = this.map.get(key);
        if (me != null) {
            ce = (V)me.getPayload();
        }
        if (me == null) {
            log.debug("LRUMap quiet miss for {0}", key);
        } else {
            log.debug("LRUMap quiet hit for {0}", key);
        }
        return ce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        log.debug("removing item for key: {0}", key);
        this.lock.lock();
        try {
            LRUElementDescriptor<K, V> me = this.map.remove(key);
            if (me != null) {
                this.list.remove(me);
                Object t = me.getPayload();
                return (V)t;
            }
        }
        finally {
            this.lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        ++this.putCnt;
        LRUElementDescriptor<K, V> old = null;
        LRUElementDescriptor<K, V> me = new LRUElementDescriptor<K, V>(key, value);
        this.lock.lock();
        try {
            this.list.addFirst(me);
            old = this.map.put(key, me);
            if (old != null && key.equals(old.getKey())) {
                this.list.remove(old);
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.shouldRemove()) {
            log.debug("In memory limit reached, removing least recently used.");
            while (this.shouldRemove()) {
                this.lock.lock();
                try {
                    LRUElementDescriptor last = this.list.getLast();
                    if (last != null) {
                        this.processRemovedLRU(last.getKey(), last.getPayload());
                        if (this.map.remove(last.getKey()) == null) {
                            log.warn("update: remove failed for key: {0}", () -> last.getKey());
                            this.verifyCache();
                        }
                        this.list.removeLast();
                        continue;
                    }
                    this.verifyCache();
                    throw new Error("update: last is null!");
                }
                finally {
                    this.lock.unlock();
                }
            }
            log.debug("update: After spool map size: {0}", () -> this.map.size());
            if (this.map.size() != this.list.size()) {
                log.error("update: After spool, size mismatch: map.size() = {0}, linked list size = {1}", () -> this.map.size(), () -> this.list.size());
            }
        }
        if (old != null) {
            return (V)old.getPayload();
        }
        return null;
    }

    protected abstract boolean shouldRemove();

    public void dumpCacheEntries() {
        if (log.isTraceEnabled()) {
            log.trace("dumpingCacheEntries");
            LRUElementDescriptor me = this.list.getFirst();
            while (me != null) {
                log.trace("dumpCacheEntries> key={0}, val={1}", me.getKey(), me.getPayload());
                me = (LRUElementDescriptor)me.next;
            }
        }
    }

    public void dumpMap() {
        if (log.isTraceEnabled()) {
            log.trace("dumpingMap");
            this.map.entrySet().forEach((? super T e) -> log.trace("dumpMap> key={0}, val={1}", e.getKey(), ((LRUElementDescriptor)e.getValue()).getPayload()));
        }
    }

    protected void verifyCache() {
        if (!log.isTraceEnabled()) {
            return;
        }
        log.trace("verifycache: mapContains {0} elements, linked list contains {1} elements", this.map.size(), this.list.size());
        log.trace("verifycache: checking linked list by key");
        LRUElementDescriptor li = this.list.getFirst();
        while (li != null) {
            K key2 = li.getKey();
            if (!this.map.containsKey(key2)) {
                log.error("verifycache: map does not contain key : {0}", li.getKey());
                log.error("li.hashcode={0}", li.getKey().hashCode());
                log.error("key class={0}", key2.getClass());
                log.error("key hashcode={0}", key2.hashCode());
                log.error("key toString={0}", key2.toString());
                if (key2 instanceof GroupAttrName) {
                    GroupAttrName name = (GroupAttrName)key2;
                    log.error("GroupID hashcode={0}", name.groupId.hashCode());
                    log.error("GroupID.class={0}", name.groupId.getClass());
                    log.error("AttrName hashcode={0}", name.attrName.hashCode());
                    log.error("AttrName.class={0}", name.attrName.getClass());
                }
                this.dumpMap();
            } else if (this.map.get(li.getKey()) == null) {
                log.error("verifycache: linked list retrieval returned null for key: {0}", li.getKey());
            }
            li = (LRUElementDescriptor)li.next;
        }
        log.trace("verifycache: checking linked list by value ");
        LRUElementDescriptor li3 = this.list.getFirst();
        while (li3 != null) {
            if (!this.map.containsValue(li3)) {
                log.error("verifycache: map does not contain value : {0}", li3);
                this.dumpMap();
            }
            li3 = (LRUElementDescriptor)li3.next;
        }
        log.trace("verifycache: checking via keysets!");
        this.map.forEach((key, value) -> {
            boolean found = false;
            LRUElementDescriptor li2 = this.list.getFirst();
            while (li2 != null) {
                if (key.equals(li2.getKey())) {
                    found = true;
                    break;
                }
                li2 = (LRUElementDescriptor)li2.next;
            }
            if (!found) {
                log.error("verifycache: key not found in list : {0}", key);
                this.dumpCacheEntries();
                if (this.map.containsKey(key)) {
                    log.error("verifycache: map contains key");
                } else {
                    log.error("verifycache: map does NOT contain key, what the HECK!");
                }
            }
        });
    }

    protected void processRemovedLRU(K key, V value) {
        log.debug("Removing key: [{0}] from LRUMap store, value = [{1}]", key, value);
        log.debug("LRUMap store size: \"{0}\".", this.size());
    }

    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("LRUMap");
        ArrayList elems = new ArrayList();
        elems.add(new StatElement<Integer>("List Size", this.list.size()));
        elems.add(new StatElement<Integer>("Map Size", this.map.size()));
        elems.add(new StatElement<Long>("Put Count", this.putCnt));
        elems.add(new StatElement<Long>("Hit Count", this.hitCnt));
        elems.add(new StatElement<Long>("Miss Count", this.missCnt));
        stats.setStatElements(elems);
        return stats;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.lock.lock();
        try {
            Set<Map.Entry<K, V>> set = this.map.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry(entry.getKey(), ((LRUElementDescriptor)entry.getValue()).getPayload())).collect(Collectors.toSet());
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Set<K> keySet() {
        return this.map.values().stream().map(value -> value.getKey()).collect(Collectors.toSet());
    }
}

