/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystem.rafts.AutoCloseableReentrantLock;
import org.lsst.ccs.subsystem.rafts.SequencerProc;

public class AutoCloseableReentrantLockTest {
    @Test
    public void testSimpleUsage() throws AutoCloseableReentrantLock.AutoCloseableReentrantLockException {
        AutoCloseableReentrantLock lock = new AutoCloseableReentrantLock();
        try (AutoCloseableReentrantLock l = lock.doLock();){
            Assert.assertTrue((boolean)lock.isLocked());
            Assert.assertTrue((boolean)l.isLocked());
        }
        Assert.assertFalse((boolean)lock.isLocked());
    }

    @Test
    public void testMultipleLockingUnlocking() throws AutoCloseableReentrantLock.AutoCloseableReentrantLockException {
        AutoCloseableReentrantLock lock = new AutoCloseableReentrantLock();
        try {
            lock.doUnlock();
            Assert.assertTrue((boolean)false);
        }
        catch (AutoCloseableReentrantLock.AutoCloseableReentrantLockException e) {
            Assert.assertTrue((boolean)e.getMessage().equals("The lock is already unlocked"));
        }
        lock.doLock();
        Assert.assertTrue((boolean)lock.isLocked());
        lock.doLock();
        Assert.assertTrue((boolean)lock.isLocked());
        lock.doLock();
        Assert.assertTrue((boolean)lock.isLocked());
        lock.doUnlock();
        Assert.assertTrue((boolean)lock.isLocked());
        lock.doUnlock();
        Assert.assertTrue((boolean)lock.isLocked());
        lock.doUnlock();
        Assert.assertFalse((boolean)lock.isLocked());
        try {
            lock.doUnlock();
            Assert.assertTrue((boolean)false);
        }
        catch (AutoCloseableReentrantLock.AutoCloseableReentrantLockException e) {
            Assert.assertTrue((boolean)e.getMessage().equals("The lock is already unlocked"));
        }
    }

    @Test
    public void testMultipleLockingUnlockingOnSeparateThreads() {
        AutoCloseableReentrantLock lock = new AutoCloseableReentrantLock();
        LockingRunnable r1 = new LockingRunnable(lock);
        LockingRunnable r2 = new LockingRunnable(lock);
        Thread t1 = new Thread(r1);
        t1.start();
        Thread t2 = new Thread(r2);
        t2.start();
        r1.executeCommand("unlock", false, "The lock is already unlocked");
        r2.executeCommand("unlock", false, "The lock is already unlocked");
        Assert.assertFalse((boolean)lock.isLocked());
        r1.executeCommand("lock", true);
        r2.executeCommand("lock", false, "The lock is already locked");
        Assert.assertTrue((boolean)lock.isLocked());
        r2.executeCommand("unlock", false, "In order to release the lock, this thread must hold it first");
        r1.executeCommand("lock", true);
        r1.executeCommand("lock", true);
        Assert.assertTrue((boolean)lock.isLocked());
        r1.executeCommand("unlock", true);
        r1.executeCommand("unlock", true);
        Assert.assertTrue((boolean)lock.isLocked());
        r1.executeCommand("unlock", true);
        Assert.assertFalse((boolean)lock.isLocked());
        r1.executeCommand("lock", true);
        Assert.assertTrue((boolean)lock.isLocked());
        r2.executeCommand("done", true);
        r1.executeCommand("done", true);
        try {
            t1.join();
            t2.join();
        }
        catch (InterruptedException e) {
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void testSequencerLock() throws InterruptedException {
        AutoCloseableReentrantLock l = null;
        try {
            l = SequencerProc.lockSequencer();
        }
        catch (AutoCloseableReentrantLock.AutoCloseableReentrantLockException ex) {
            Assert.fail((String)("unexpected exception" + ex));
        }
        Thread t1 = new Thread(() -> {
            try (AutoCloseableReentrantLock lock = SequencerProc.lockSequencer();){
                Assert.assertTrue((boolean)false);
            }
            catch (AutoCloseableReentrantLock.AutoCloseableReentrantLockException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("The lock is already locked"));
            }
        });
        t1.start();
        try {
            t1.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        l.unlock();
        Assert.assertFalse((boolean)l.isLocked());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSequencerLockIfPossible() throws InterruptedException {
        AtomicBoolean threadAcquiredLock = new AtomicBoolean(false);
        Thread t = new Thread(() -> {
            try (AutoCloseableReentrantLock lock = SequencerProc.lockSequencer();){
                try {
                    AtomicBoolean atomicBoolean = threadAcquiredLock;
                    synchronized (atomicBoolean) {
                        threadAcquiredLock.set(true);
                        threadAcquiredLock.notify();
                    }
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
            catch (AutoCloseableReentrantLock.AutoCloseableReentrantLockException ex) {
                Assert.fail((String)("unexpected exception " + ex));
            }
        });
        t.start();
        AtomicBoolean atomicBoolean = threadAcquiredLock;
        synchronized (atomicBoolean) {
            if (!threadAcquiredLock.get()) {
                threadAcquiredLock.wait();
            }
        }
        try (AutoCloseableReentrantLock lock = SequencerProc.lockSequencerIfPossible();){
            Assert.assertNull((Object)lock);
        }
        catch (AutoCloseableReentrantLock.AutoCloseableReentrantLockException e) {
            Assert.assertTrue((boolean)false);
        }
        t.join();
    }

    private class LockingRunnable
    implements Runnable {
        private final BlockingQueue<Command> commandQueue = new LinkedBlockingQueue<Command>();
        final AutoCloseableReentrantLock lock;
        private final Object commandLock = new Object();

        LockingRunnable(AutoCloseableReentrantLock lock) {
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    Command cmd = this.commandQueue.take();
                    Object object = this.commandLock;
                    synchronized (object) {
                        try {
                            if (cmd.command.equals("lock")) {
                                this.lock.doLock();
                            } else if (cmd.command.equals("unlock")) {
                                this.lock.doUnlock();
                            } else if (cmd.command.equals("done")) {
                                this.commandLock.notifyAll();
                                return;
                            }
                            Assert.assertTrue((boolean)cmd.successful);
                        }
                        catch (AutoCloseableReentrantLock.AutoCloseableReentrantLockException e) {
                            Assert.assertTrue((!cmd.successful ? 1 : 0) != 0);
                            Assert.assertTrue((boolean)e.getMessage().contains(cmd.msg));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            Assert.assertTrue((boolean)false);
                        }
                        this.commandLock.notifyAll();
                    }
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        void executeCommand(String command, boolean successful) {
            this.executeCommand(command, successful, "");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void executeCommand(String command, boolean successful, String msg) {
            try {
                this.commandQueue.put(new Command(command, successful, msg));
                Object object = this.commandLock;
                synchronized (object) {
                    this.commandLock.wait();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        private static class Command {
            final String command;
            final boolean successful;
            final String msg;

            Command(String command, boolean successful, String msg) {
                this.command = command;
                this.successful = successful;
                this.msg = msg;
                if (!successful && msg.isBlank()) {
                    throw new RuntimeException("Please provide a message");
                }
            }
        }
    }
}

