package org.lsst.ccs.subsystem.rafts;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

/**
 * 
 * @author turri
 */
public class AutoCloseableReentrantLock extends ReentrantLock implements AutoCloseable {

    AutoCloseableReentrantLock doLock(long timeout, TimeUnit unit) throws AutoCloseableReentrantLockException {
        try {
            if (!super.tryLock(timeout, unit)) {
                throw new AutoCloseableReentrantLockException("The lock is already locked");
            }
        } catch (InterruptedException ie) {
            throw new AutoCloseableReentrantLockException(ie);
        }
        return this;
    }

    AutoCloseableReentrantLock doLock() throws AutoCloseableReentrantLockException {
        if (! super.tryLock() ) {
            throw new AutoCloseableReentrantLockException("The lock is already locked");
        }        
        return this;
    }
    
    void doUnlock() throws AutoCloseableReentrantLockException {
        if ( !isLocked() ) {
            throw new AutoCloseableReentrantLockException("The lock is already unlocked");
        }
        try {
            super.unlock();
        } catch (IllegalMonitorStateException e) {
            throw new AutoCloseableReentrantLockException("In order to release the lock, this thread must hold it first.");            
        }
    }
    
    @Override
    public void close() throws AutoCloseableReentrantLockException {
        doUnlock();
    }

    public static class AutoCloseableReentrantLockException extends Exception {

        public AutoCloseableReentrantLockException(String msg) {
            super(msg);
        }

        public AutoCloseableReentrantLockException(Exception e) {
            super(e);
        }

    }
}
