
import org.lsst.ccs.drivers.reb.sim.ClientFactorySimulation
import org.lsst.ccs.subsystem.rafts.RaftsMain;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.DacControl;
import org.lsst.ccs.subsystem.rafts.AspicControl;
import org.lsst.ccs.subsystem.rafts.BiasControl;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.utilities.ccd.*;
import org.lsst.ccs.utilities.image.*;
import org.lsst.ccs.subsystem.ts8.sim.*;
import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystem.rafts.TestClientFactorySimulator;
import org.lsst.ccs.daq.utilities.FitsService

//def raftBuilder = Class.forName("org.lsst.ccs.utilities.ccd.Raft");
//raftGeometry = raftBuilder.createRaft("R00",CCDType.E2V);
CCDType type = new E2VCCDType();

raftGeometry = new Raft(type);
reb0 = Reb.createReb(type);
raftGeometry.addChildGeometry(reb0, 0, 0);

def runMode = System.getProperty("org.lsst.ccs.run.mode","normal");
System.out.println("Building Reb test in run mode: "+runMode);

clientFactory = runMode.equals("simulation") ? new TestClientFactorySimulator() : null;

CCSBuilder builder = ["reb_tests"]

builder.
    "main" (RaftsMain, clientFactory:clientFactory) {

        fitsService (FitsService, headerFilesList:["primary", "extended"])
    
        for (Reb rebGeometry : raftGeometry.getChildrenList() ) {
            def rebCount = rebGeometry.getParallelPosition();
            def reb = rebGeometry.getUniqueId();
            def dreb = "D$reb"
            


            "$reb" (REBDevice, hdwType:"DAQ1",id:rebCount, ifcName:"", ccdMask:7, clientFactory:clientFactory) {

                "${reb}.DAC"  (DacControl)

                for (int j = 0; j < 6; j++) {
                    def apc = "ASPIC$j"
                    "${reb}.${apc}" (AspicControl, hwChan:j)
                }

                for (int j = 0; j < 3; j++) {
                    def bias = "Bias$j"
                    "${reb}.${bias}" (BiasControl, hwChan:j)
                }
            }

        for (int j = 1; j <= 2; j++) {
                "${dreb}.Temp$j" (Channel, description: "${dreb} temperature $j", units: "\u00b0C",
                        devcName: "${reb}", hwChan: j - 1, type: "TEMP")
        }

        for (int j = 1; j <= 8; j++) {
                "${reb}.Temp$j" (Channel, description: "${reb} temperature $j", units: "\u00b0C",
                        devcName: "${reb}", hwChan: j + 1, type: "TEMP")
        }
                
        "${dreb}.6Vv"   (Channel, description: "${dreb} 6V voltage", units: "Volts",
                        devcName: "${reb}", hwChan:0, type: "POWER")
                    
        "${dreb}.6Vi"   (Channel, description: "${dreb} 6V current", units: "Amps",
                        devcName: "${reb}", hwChan:1, type: "POWER")
                    
        "${dreb}.9Vv"   (Channel, description: "${dreb} 9V voltage", units: "Volts",
                        devcName: "${reb}", hwChan:2, type: "POWER")
                    
        "${dreb}.9Vi"   (Channel, description: "${dreb} 9V current", units: "Amps",
                        devcName: "${reb}", hwChan:3, type: "POWER")
                         
        "${dreb}.24Vv"  (Channel, description: "${dreb} 24V voltage", units: "Volts",
                        devcName: "${reb}", hwChan:4, type: "POWER")

        "${dreb}.24Vi"  (Channel, description: "${dreb} 24V current", units: "Amps",
                        devcName: "${reb}", hwChan:5, type: "POWER")
                    
        "${dreb}.40Vv"  (Channel, description: "${dreb} 40V voltage", units: "Volts",
                        devcName: "${reb}", hwChan:6, type: "POWER")

        "${dreb}.40Vi"  (Channel, description: "${dreb} 40V current", units: "Amps",
                        devcName: "${reb}", hwChan:7, type: "POWER")

        }
         
     }

