/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.ConfigurationListener;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.data.RunMode;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;
import org.lsst.ccs.daq.utilities.FitsHeaderKeywordData;
import org.lsst.ccs.daq.utilities.FitsService;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.drivers.reb.Aspic;
import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.BoardDacs;
import org.lsst.ccs.drivers.reb.ClientFactory;
import org.lsst.ccs.drivers.reb.ImageClient;
import org.lsst.ccs.drivers.reb.ImageMetadata;
import org.lsst.ccs.drivers.reb.PowerAdcs;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.REBTimeoutException;
import org.lsst.ccs.drivers.reb.RegClient;
import org.lsst.ccs.drivers.reb.Sequencer;
import org.lsst.ccs.drivers.reb.SlowAdcs;
import org.lsst.ccs.drivers.reb.StatusSet;
import org.lsst.ccs.drivers.reb.TempAdcs;
import org.lsst.ccs.drivers.reb.TempRtds;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Control;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorUpdateTask;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.rafts.AspicControl;
import org.lsst.ccs.subsystem.rafts.BiasControl;
import org.lsst.ccs.subsystem.rafts.DacControl;
import org.lsst.ccs.subsystem.rafts.GlobalProc;
import org.lsst.ccs.subsystem.rafts.ImageProc;
import org.lsst.ccs.subsystem.rafts.SequencerProc;
import org.lsst.ccs.subsystem.rafts.alerts.RaftAlert;
import org.lsst.ccs.subsystem.rafts.config.ASPIC;
import org.lsst.ccs.subsystem.rafts.config.BiasDACS;
import org.lsst.ccs.subsystem.rafts.config.REB;
import org.lsst.ccs.subsystem.rafts.data.ImageData;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.subsystem.rafts.data.RegisterData;
import org.lsst.ccs.subsystem.rafts.data.StatusData;
import org.lsst.ccs.subsystem.rafts.states.CCDsPowerState;
import org.lsst.ccs.subsystem.rafts.states.HVBiasState;
import org.lsst.ccs.subsystem.rafts.states.RebDeviceState;
import org.lsst.ccs.subsystem.rafts.states.RebValidationState;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class REBDevice
extends Device
implements ConfigurationListener,
ClearAlertHandler,
ConfigurationBulkChangeHandler {
    private static final String SERIAL_NUM = "serialNum";
    public static final String RAFTS = "Rafts";
    public static final String RAFTS_LIMITS = "RaftsLimits";
    public static final String RAFTS_POWER = "RaftsPower";
    public static final int TYPE_BD_TEMP = 0;
    public static final int TYPE_BD_POWER = 1;
    public static final int TYPE_RTD = 2;
    public static final int TYPE_ASP_TEMP = 3;
    public static final int TYPE_BIAS_VOLT = 4;
    public static final int TYPE_CCD_CURR = 5;
    public static final int TYPE_CR_VOLT = 6;
    public static final int TYPE_HEATER = 7;
    public static final int TYPE_HV_SWITCH = 8;
    public static final int CHAN_TOTAL_POWER = -1;
    public static final int CHAN_HTR_VOLTS = 0;
    public static final int CHAN_HTR_POWER = 1;
    public static final int NUM_HTR_CHANS = 2;
    public static final int CHAN_RTD_INT_TEMP = 4;
    public static final int CHAN_RTD_INT_VOLT = 5;
    public static final int NUM_RTD_CHANS = 6;
    static final int REB_NUM_MASK = 3;
    static final int RAFT_NUM_MASK = 63;
    static final int RAFT_NUM_SHIFT = 2;
    static final int POWER_ON_DELAY = 160;
    static final int DAC_DELTA_DELAY = 60;
    static final int POWER_OFF_DELAY = 50;
    static final int DAC_LIMIT = 4095;
    static final double DAC_CONV = 819.0;
    static final double HTR_CONV = 409.5;
    static final double HTR_CONV_R5 = 409.5;
    static final double HEATER_OHMS = 14.5;
    static final double HTR_LEAD_OHMS = 0.3;
    static final int ADC_PCLK_L = 0;
    static final int ADC_PCLK_U = 1;
    static final int ADC_SCLK_L = 2;
    static final int ADC_SCLK_U = 3;
    static final int ADC_RG_L = 4;
    static final int ADC_RG_U = 5;
    static final int ADC_GD_0 = 6;
    static final int ADC_OD_0 = 7;
    static final int ADC_OG_0 = 8;
    static final int ADC_RD_0 = 9;
    static final int NUM_WREB_ADCS = 10;
    static final int ADC_GD_1 = 10;
    static final int ADC_OD_1 = 11;
    static final int ADC_OG_1 = 12;
    static final int ADC_RD_1 = 13;
    static final int NUM_GREB_ADCS = 14;
    static final int ADC_GD_2 = 14;
    static final int ADC_OD_2 = 15;
    static final int ADC_OG_2 = 16;
    static final int ADC_RD_2 = 17;
    static final int NUM_SREB_ADCS = 18;
    private List<MonitorUpdateTask> tasksForDevice = null;
    private static final Map<String, Integer> hdwTypeMap = new HashMap<String, Integer>();
    private static final Map<String, Integer> typeMap;
    private static final int[] adcChans;
    private static final String[] adcNames;
    private static final Map<Integer, Integer> hwChanToAdcs;
    private static final int seqClockLines = 4080;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService sce;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService stateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private GlobalProc globalProc;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private FitsService fitsService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final Map<String, Channel> childChannels = new HashMap<String, Channel>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final Map<String, Control> controlsMap = new LinkedHashMap<String, Control>();
    @LookupPath
    String rebPath;
    @ConfigurationParameter(name="serialNum", category="Rafts")
    private volatile long serialNum;
    @ConfigurationParameter(category="Rafts", isFinal=true)
    private volatile int id = -1;
    @ConfigurationParameter(category="Rafts", isFinal=true)
    private volatile boolean useScienceCCD = false;
    @ConfigurationParameter(category="Rafts", description="Disables the RTD derived CCD type check.")
    private volatile boolean disableRTDHardwareCheck = false;
    boolean processImages = true;
    @ConfigurationParameter(category="RaftsPower", range="0.0..0.006", description="Max OFF_State ODI (A) per CCD", units="Amps")
    private volatile double odiQmax;
    @ConfigurationParameter(category="RaftsPower", description="Minimum ON_State ODI (A) per CCD", units="Amps")
    private volatile double odiAmin;
    @ConfigurationParameter(category="RaftsPower", range="0.0..0.050", description="Max OFF_State CLKLI (A) per REB", units="Amps")
    private volatile double clkliQmax;
    @ConfigurationParameter(category="RaftsPower", description="Minimum ON_State CLKLI (A) per REB", units="Amps")
    private volatile double clkliAmin;
    @ConfigurationParameter(category="RaftsPower", range="0.0..0.093", description="Max OFF_State CLKHI (A) per REB", units="Amps")
    private volatile double clkhiQmax;
    @ConfigurationParameter(category="RaftsPower", description="Minimum ON_State CLKHI (A) per REB", units="Amps")
    private volatile double clkhiAmin;
    @ConfigurationParameter(category="RaftsPower", range="0.0..0.5", description="Max allowed SlowAdcs step", units="Volts")
    private volatile double maxStep;
    @ConfigurationParameter(category="RaftsPower", range="0.3..1.5", description="Max allowed SlowAdcs delta", units="Volts")
    private volatile double maxDelta;
    @ConfigurationParameter(category="RaftsPower", range="0.01..0.2", description="Min allowed SlowAdcs tolerance", units="Volts")
    private volatile double minTol;
    @ConfigurationParameter(name="nPowerOnPub", category="RaftsPower", description="Number of consequtive monitor-update pubs after trigger")
    private volatile int nPowerOnPub = 15;
    private String hdwType = "daq";
    private String ifcName;
    private volatile int rebType = 0;
    private int[] dataSegmentMap = null;
    private static final Logger LOG;
    private final BaseSet bss = new BaseSet();
    private final StatusSet sts = new StatusSet(this.bss);
    private final TempAdcs tmp = new TempAdcs(this.bss);
    private final PowerAdcs pwr = new PowerAdcs(this.bss);
    private final SlowAdcs slow = new SlowAdcs(this.bss);
    private final TempRtds rtd = new TempRtds(this.bss);
    private final BoardDacs dac = new BoardDacs(this.bss);
    private final Aspic asp = new Aspic(this.bss);
    private final Sequencer seq = new Sequencer(this.bss);
    private final ImageClient imc = new ImageClient((RegClient)this.bss);
    private final BiasControl[] biases = new BiasControl[3];
    private final AspicControl[] aspics = new AspicControl[6];
    private ImageProc img;
    private final SequencerProc sqp = new SequencerProc(this.bss);
    private volatile DacControl dacCtrl;
    private final Map<Integer, String> sadcChannelMap = new HashMap<Integer, String>();
    private final Map<Integer, String> pwrChannelMap = new HashMap<Integer, String>();
    private volatile long hwSerialNum = 0L;
    private volatile boolean serialNumValid = false;
    protected int hdwTypeI;
    protected int configCcdMask;
    protected volatile int realCcdMask;
    protected volatile int hwVersion;
    private volatile int maxTemp;
    private volatile int maxPower;
    private volatile int maxAtemp;
    private volatile int maxCcdI;
    private volatile int numBiasVolt;
    private volatile int numCcdCurrents;
    private volatile int numTemp;
    private volatile int numPower;
    private volatile int numAtemp;
    private volatile int numCrVolt;
    private volatile int numRtd;
    private volatile boolean dacRaw;
    private volatile boolean biasRaw;
    private volatile double[] tempValues;
    private volatile double[] powerValues;
    private volatile double[] atempValues;
    private volatile double[] adcValues;
    private volatile double[] ccdCurrents;
    private final double[] heaterValues = new double[2];
    private volatile int errorCount;
    private volatile int dacLoadDelay = 0;
    private volatile int dacClearDelay = 0;
    private volatile int dacDeltaDelay = 0;
    private Boolean useFullPath;
    private volatile CCDType ccdType = null;
    private volatile CCDType hwCcdType = null;
    private Reb rebGeometry;
    private volatile boolean updateCCDsPowerState = false;
    private volatile int exceptionCount = 0;
    private volatile String exceptionText;
    private static final Map<String, Integer> rsetNames;

    public void build() {
        super.build();
        ComponentLookup lookupService = this.subsys.getComponentLookup();
        ComponentNode rebNode = lookupService.getComponentNodeForObject((Object)this);
        if (this.processImages) {
            this.img = new ImageProc(this.imc);
            ComponentNode imageProcNode = new ComponentNode("imageProc", (Object)this.img);
            lookupService.addComponentNodeToLookup(rebNode, imageProcNode);
            if (this.dataSegmentMap != null) {
                this.img.setDataSegmentMap(this.dataSegmentMap);
            }
            if (this.fitsService == null) {
                LOG.log(Level.WARNING, "No fits service for {0} is defined in groovy. For now using internal instance.", this.rebPath);
                FitsService fitsSrvc = new FitsService();
                ComponentNode fitsServiceNode = new ComponentNode(this.name + ".FitsService", (Object)fitsSrvc);
                lookupService.addComponentNodeToLookup(rebNode, fitsServiceNode);
                fitsSrvc.setHeaderFilesList(Arrays.asList("primary", "extended", "Fits_primary_header.spec:primary"));
            }
        } else {
            LOG.log(Level.INFO, "No images will be processed by this device: {0}", this.rebPath);
        }
    }

    public void setRebGeometry(Reb reb) {
        this.rebGeometry = reb;
        if (this.img != null) {
            this.img.setRebGeometry(reb);
        }
        this.setCcdType(reb.getCCDType());
    }

    public Reb getRebGeometry() {
        return this.rebGeometry;
    }

    public void postStart() {
        this.sce.addConfigurationListener((ConfigurationListener)this);
    }

    public synchronized void setUpdateCCDsPowerState() {
        this.updateCCDsPowerState = true;
        LOG.log(Level.INFO, "setting updateCCDsPowerState flag on " + this.rebPath);
    }

    @Command(type=Command.CommandType.ACTION, description="Clear the updateCCDsPowerState flag")
    public synchronized void clearUpdateCCDsPowerState() {
        this.updateCCDsPowerState = false;
        LOG.log(Level.INFO, "clearing updateCCDsPowerState flag on " + this.rebPath);
    }

    @Command(type=Command.CommandType.QUERY, description="Get the value of the updateCCDsPowerState flag")
    public synchronized boolean getUpdateCCDsPowerState() {
        this.updateCCDsPowerState = false;
        LOG.log(Level.INFO, String.format("updateCCDsPowerState= %s on %s", this.updateCCDsPowerState ? "TRUE" : "FALSE", this.rebPath));
        return this.updateCCDsPowerState;
    }

    public void validateBulkChange(Map<String, Object> params) {
        long sNum = (Long)params.get(SERIAL_NUM);
        if (this.hwSerialNum != 0L) {
            if (sNum != -1L && sNum != this.hwSerialNum) {
                String msg = "Configuration has wrong REB s/n: " + sNum + "; " + this.rebPath + " s/n is " + this.hwSerialNum;
                throw new IllegalArgumentException(msg);
            }
            LOG.log(Level.INFO, String.format("Configured %s s/n (%d) is valid", this.rebPath, sNum));
            this.serialNumValid = true;
            this.stateService.updateAgentComponentState((Object)this, new Enum[]{RebValidationState.VALID});
        }
    }

    public void configurationChanged(ConfigurationInfo newConfigurationInfo, ConfigurationInfo oldConfigurationInfo, ConfigurationListener.ConfigurationOperation configOperation) {
        List latestChanges = newConfigurationInfo.diff(oldConfigurationInfo);
        if (!latestChanges.isEmpty() && this.updateCCDsPowerState) {
            LOG.log(Level.INFO, String.format("%s:configurationChanged() found %d changes", this.rebPath, latestChanges.size()));
            ArrayList<AdcData> adcDataList = new ArrayList<AdcData>();
            CCDsPowerState powerState = CCDsPowerState.UNKNOWN;
            try {
                powerState = this.setCCDsPowerState(adcDataList, true);
            }
            catch (RaftException e) {
                LOG.log(Level.SEVERE, String.format("FAILED to determine CCDsPowerState for %s", this.rebPath));
                LOG.log(Level.SEVERE, String.format("CCDsPowerState changed to %s", this.stateService.getComponentState(this.rebPath, CCDsPowerState.class).name()));
                LOG.log(Level.SEVERE, String.format("forcing powerCCDsOff() called for %s", this.rebPath));
                try {
                    this.powerCCDsOff(adcDataList);
                }
                catch (RaftException et) {
                    LOG.log(Level.SEVERE, String.format("powerCCDsOff() FAILED for %s", this.rebPath));
                    LOG.log(Level.SEVERE, String.format("CCD state undefined for %s", this.rebPath));
                    LOG.log(Level.SEVERE, String.format("powerCCDsOff failed, check/reboot %s", this.rebPath), et);
                }
            }
            this.publishAllAdcData(adcDataList);
            this.clearUpdateCCDsPowerState();
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the REB ID")
    public int getId() {
        return this.id;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the network interface name")
    public String getIfcName() {
        return this.ifcName;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the mask of CCDs being used")
    public int getCcdMask() {
        return this.realCcdMask;
    }

    public void setCcdType(CCDType ccdType) {
        LOG.log(Level.INFO, "setCcdType to {0} for {1}", new Object[]{ccdType, this.rebPath});
        this.ccdType = ccdType;
        this.dacLoadDelay = ccdType == null ? 0 : 160;
        this.dacDeltaDelay = ccdType == null ? 0 : 60;
        this.dacClearDelay = ccdType == null ? 0 : 50;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the type of CCDs being used")
    public CCDType getCcdType() {
        return this.ccdType;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the hardware type of CCDs being used")
    public CCDType getHwCcdType() {
        return this.hwCcdType;
    }

    @Command(type=Command.CommandType.ACTION, description="Set whether a WREB is using a science CCD")
    public void setScienceCCD(@Argument(description="Whether a science CCD") boolean useScience) {
        this.rtd.setScienceCCD(useScience);
    }

    public void setClientFactory(ClientFactory factory) {
        if (factory != null) {
            this.bss.setClientFactory(factory);
            this.imc.setClientFactory(factory);
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the REB type")
    public int getRebType() {
        return this.rebType;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the REB number")
    public int getRebNumber() {
        return this.id & 3;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the raft number")
    public int getRaftNumber() {
        return this.id >> 2 & 0x3F;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the hardware type")
    public int getHdwType() {
        return this.hdwTypeI;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the hardware version")
    public int getHwVersion() {
        return this.hwVersion;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the serial number")
    public long getSerialNumber() {
        return this.hwSerialNum;
    }

    public boolean isSerialNumValid() {
        return this.serialNumValid;
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
        if (alert.getAlertId().equals(RaftAlert.REB_NOT_CONNECTED.getAlertId())) {
            return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
        }
        return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
    }

    private void addToChannelMap(Map map, int hwChan, String chName) {
        if (this.useFullPath == null) {
            String fpProperty = this.subsys.getAgentInfo().getAgentProperty("org.lsst.ccs.use.full.paths", "false");
            this.useFullPath = "true".equals(fpProperty.toLowerCase());
        }
        if (this.useFullPath.booleanValue()) {
            Channel chan = this.childChannels.get(chName);
            if (chan == null) {
                chan = this.mon.getChannel(chName);
            }
            map.put(hwChan, chan.getPath());
        } else {
            map.put(hwChan, chName);
        }
    }

    protected void initDevice() {
        String partition;
        this.stateService.registerState(RebDeviceState.class, "Reb Device ONLINE/OFFLINE State", (Object)this);
        this.stateService.registerState(RebValidationState.class, "Reb Device Validation State", (Object)this);
        this.stateService.registerState(HVBiasState.class, "High Voltage Bias ON/OFF State", (Object)this);
        this.stateService.registerState(CCDsPowerState.class, "CCDs Power ON/OFF State", (Object)this);
        this.stateService.updateAgentComponentState((Object)this, new Enum[]{RebDeviceState.OFFLINE, RebValidationState.UNKNOWN, HVBiasState.UNKNOWN, CCDsPowerState.UNKNOWN});
        if (this.id < 0) {
            LOG.log(Level.SEVERE, "{0} config parameter {1} {2}", new Object[]{this.rebPath, "id", "has not been specified"});
            throw new RuntimeException("Fatal configuration error");
        }
        if (this.globalProc != null && (partition = this.globalProc.getPartition()) != null && !partition.isEmpty()) {
            this.ifcName = partition;
        }
        if (this.ifcName == null) {
            LOG.log(Level.SEVERE, "{0} config parameter {1} {2}", new Object[]{this.rebPath, "ifcName", "has not been specified"});
            throw new RuntimeException("Fatal configuration error");
        }
        Integer type = hdwTypeMap.get(this.hdwType.toUpperCase());
        if (type == null) {
            LOG.log(Level.SEVERE, "{0} config parameter {1} {2}", new Object[]{this.rebPath, "hdwType", "is invalid"});
            throw new RuntimeException("Fatal configuration error");
        }
        this.hdwTypeI = type;
        this.imc.setRebId("reb-" + this.id);
        if (this.img != null) {
            this.img.configure(null);
        }
        int biasMask = 0;
        int aspMask = 0;
        int aspicMask = 0;
        for (Control ctrl : this.controlsMap.values()) {
            if (ctrl instanceof BiasControl) {
                biasMask |= 1 << ctrl.getHwChan();
                continue;
            }
            if (!(ctrl instanceof AspicControl)) continue;
            aspMask |= 1 << ctrl.getHwChan();
        }
        int j = 0;
        while (j < 3) {
            int pair = aspMask & 3;
            if (pair != 0) {
                if (pair == 3) {
                    aspicMask |= 1 << j;
                } else {
                    LOG.log(Level.SEVERE, "Unpaired configuration for {0} ASPIC {1} ignored", new Object[]{this.rebPath, 2 * j + pair - 1});
                }
            }
            ++j;
            aspMask >>= 2;
        }
        if (biasMask != 0 && biasMask != aspicMask) {
            LOG.log(Level.WARNING, "{0} ASPIC and bias configurations don't match", this.rebPath);
        }
        this.configCcdMask = biasMask | aspicMask;
        for (Control ctrl : this.controlsMap.values()) {
            if (ctrl instanceof DacControl) {
                this.dacCtrl = (DacControl)ctrl;
                continue;
            }
            if (ctrl instanceof BiasControl) {
                if ((1 << ctrl.getHwChan() & this.configCcdMask) == 0) continue;
                this.biases[ctrl.getHwChan()] = (BiasControl)ctrl;
                continue;
            }
            if (!(ctrl instanceof AspicControl) || (1 << ctrl.getHwChan() / 2 & this.configCcdMask) == 0) continue;
            this.aspics[ctrl.getHwChan()] = (AspicControl)ctrl;
        }
        this.tasksForDevice = this.getDeviceMonitorUpdateTasks();
        this.bss.setDefaultRebType(0);
        try {
            this.realCcdMask = this.configCcdMask & (1 << this.bss.getNumStrips()) - 1;
        }
        catch (REBException e) {
            LOG.log(Level.SEVERE, "Error getting expected {0} CCD count: {1}", new Object[]{this.rebPath, e});
        }
        this.fullName = this.name;
    }

    protected void initialize() {
        try {
            int j;
            this.bss.open(this.hdwTypeI, this.id, this.ifcName);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.bss.disable();
            this.bss.setTime();
            this.bss.enable();
            this.rebType = this.bss.getRebType();
            this.hwVersion = this.bss.getHwVersion();
            this.maxTemp = this.tmp.getNumRegs();
            this.maxPower = this.pwr.getNumRegs();
            this.maxAtemp = this.slow.getNumAspicTemps();
            this.maxCcdI = this.slow.getNumCcdCurrents();
            this.numCcdCurrents = 0;
            this.numBiasVolt = 0;
            this.numRtd = 0;
            this.numCrVolt = 0;
            this.numAtemp = 0;
            this.numPower = 0;
            this.numTemp = 0;
            this.tempValues = new double[this.maxTemp];
            this.powerValues = new double[this.maxPower];
            this.adcValues = new double[36];
            this.ccdCurrents = new double[this.maxCcdI];
            this.atempValues = new double[this.maxAtemp];
            this.realCcdMask = this.configCcdMask & (1 << this.bss.getNumStrips()) - 1;
            if (this.img != null) {
                this.img.setCcdMask(this.realCcdMask);
                this.img.setNumRebCcds(this.bss.getNumStrips());
                this.img.setDataInversion(this.bss.getRebType() == 0);
            }
            if (this.dacCtrl != null && !this.dacCtrl.checkConfig()) {
                this.dacCtrl = null;
            }
            this.dacRaw = this.dacCtrl != null ? this.dacCtrl.isRaw() : false;
            this.biasRaw = false;
            for (j = 0; j < this.biases.length; ++j) {
                BiasControl bias = this.biases[j];
                if (bias != null && !bias.checkConfig()) {
                    bias = null;
                }
                if (bias != null) {
                    this.biasRaw = bias.isRaw();
                }
                this.biases[j] = bias;
            }
            for (j = 0; j < this.aspics.length; ++j) {
                AspicControl aspic = this.aspics[j];
                if (aspic != null && !aspic.checkConfig()) {
                    aspic = null;
                }
                this.aspics[j] = aspic;
            }
            try {
                this.hwSerialNum = this.bss.getRebSerial();
            }
            catch (REBException e) {
                LOG.log(Level.SEVERE, "Error reading {0} serial number", this.rebPath);
                this.hwSerialNum = -1L;
            }
            this.rtd.initialize();
            if (!this.disableRTDHardwareCheck) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOG.log(Level.SEVERE, "Thread.sleep(100) interrupted at rtd.initialize() for {0}", this.rebPath);
                }
                try {
                    int type = this.rtd.getCCDType();
                    Object object = type == 2 ? CCDType.getCCDType((String)"e2v") : (this.hwCcdType = type == 1 ? CCDType.getCCDType((String)"itl") : null);
                    if (RunMode.isSimulation()) {
                        this.hwCcdType = CCDType.getCCDType((String)this.ccdType.getName());
                    }
                    LOG.log(Level.INFO, "found hwCcdType {0} for {1}", new Object[]{this.hwCcdType, this.rebPath});
                    CCDType manufacturerType = CCDType.getCCDType((String)this.ccdType.getManufacturer());
                    if (this.hwCcdType == null || !this.hwCcdType.equals((Object)manufacturerType)) {
                        throw new RuntimeException("CCD Hardware type " + this.hwCcdType + " is inconsistent with configured CCD Type " + manufacturerType);
                    }
                }
                catch (REBException e) {
                    LOG.log(Level.SEVERE, "Error getting CCD type for" + this.rebPath, e);
                    this.hwCcdType = null;
                }
            }
            this.rtd.setScienceCCD(this.useScienceCCD);
            this.errorCount = 0;
            this.initSensors();
            this.imc.open(this.hdwTypeI, this.id, this.ifcName);
            this.setOnline(true);
            this.logExceptionCount();
            LOG.log(Level.INFO, "Connected to {0}", this.rebPath);
            LOG.log(Level.INFO, String.format("%s has firmware version: 0x%x", this.rebPath, this.hwVersion));
            LOG.log(Level.INFO, String.format("%s has serialNumber: %d", this.rebPath, this.hwSerialNum));
            if (this.inited) {
                this.alertService.raiseAlert(RaftAlert.REB_NOT_CONNECTED.getAlert(), AlertState.NOMINAL, this.rebPath + " is connected");
            }
            this.exceptionCount = 0;
            try {
                if (this.sqp.isRunning()) {
                    LOG.log(Level.INFO, "Sequencer is running for {0}", this.rebPath);
                } else {
                    LOG.log(Level.INFO, "Sequencer is idle for {0}", this.rebPath);
                }
            }
            catch (REBException e) {
                LOG.log(Level.SEVERE, "Failed to determine sequencer state for " + this.rebPath, e);
            }
            try {
                this.slow.readVoltages();
            }
            catch (REBException e) {
                LOG.log(Level.SEVERE, "SlowAdcs.readVoltages() exception for " + this.rebPath, e);
            }
            try {
                CCDsPowerState powerState = this.setCCDsPowerState(true);
                this.clearUpdateCCDsPowerState();
                LOG.log(Level.INFO, "CCDsPowerState for {0} is {1}", new Object[]{this.rebPath, powerState.name()});
            }
            catch (RaftException e) {
                LOG.log(Level.SEVERE, "Error getting CCDsPowerState for " + this.rebPath, e);
                LOG.log(Level.SEVERE, "CCDsPowerState changed to {0}", this.stateService.getComponentState(this.rebPath, CCDsPowerState.class).name());
                LOG.log(Level.SEVERE, "calling powerCCDsOff() for " + this.rebPath);
                try {
                    this.powerCCDsOff();
                }
                catch (RaftException et) {
                    LOG.log(Level.SEVERE, String.format("powerCCDsOff() FAILED for %s", this.rebPath));
                    LOG.log(Level.SEVERE, String.format("CCDsPowerState changed to %s", this.stateService.getComponentState(this.rebPath, CCDsPowerState.class).name()));
                }
            }
            boolean bl = this.serialNumValid = this.serialNum == -1L || this.serialNum == this.hwSerialNum;
            if (!this.serialNumValid) {
                this.stateService.updateAgentComponentState((Object)this, new Enum[]{RebValidationState.INVALID});
                LOG.log(Level.SEVERE, "{0} s/n ({1}) doesn''t match configuration value ({2})", new Object[]{this.rebPath, this.hwSerialNum, this.serialNum});
            } else {
                this.stateService.updateAgentComponentState((Object)this, new Enum[]{RebValidationState.VALID});
            }
            this.forceDataPublicationForNextUpdateIterations(this.nPowerOnPub);
        }
        catch (REBException e) {
            String text = e.getMessage();
            if (this.exceptionCount == 0 || !this.exceptionText.equals(text)) {
                this.logExceptionCount();
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.name, e});
                if (this.exceptionCount == 0) {
                    this.close("could not connect");
                }
                this.exceptionCount = 0;
                this.exceptionText = text;
            }
            ++this.exceptionCount;
        }
        this.inited = true;
    }

    protected void close() {
        this.close("was disconnected");
    }

    private void close(String alertText) {
        try {
            this.rebType = -1;
            this.hwVersion = 0;
            this.hwSerialNum = 0L;
            this.hwCcdType = null;
            this.bss.close();
        }
        catch (REBException rEBException) {
            // empty catch block
        }
        try {
            this.imc.close();
        }
        catch (REBException rEBException) {
            // empty catch block
        }
        if (alertText != null) {
            this.alertService.raiseAlert(RaftAlert.REB_NOT_CONNECTED.getAlert(), AlertState.ALARM, this.name + " " + alertText);
        }
    }

    private Integer convertTypeStrToInt(String typeStr) throws Exception {
        Integer iType = typeMap.get(typeStr.toUpperCase());
        if (iType == null) {
            LOG.log(Level.SEVERE, "{0} config parameter {1} {2}", new Object[]{this.rebPath, "channel type", typeStr});
            throw new RuntimeException("Fatal configuration error");
        }
        return iType;
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType = this.convertTypeStrToInt(type);
        return new int[]{iType, 0};
    }

    protected void initChannel(String name, int id, int hwChan, int type, int subtype) {
        try {
            boolean chanOk;
            if (type == 4 || type == 6) {
                chanOk = this.slow.testChannel(hwChan);
                if (chanOk) {
                    this.addToChannelMap(this.sadcChannelMap, hwChan, name);
                }
            } else {
                int maxChan = type == 0 ? this.maxTemp : (type == 1 ? this.maxPower : (type == 3 ? this.maxAtemp : (type == 5 ? this.maxCcdI : (type == 2 ? 6 : (type == 7 ? 2 : (type == 8 ? 1 : 0))))));
                boolean bl = chanOk = (hwChan >= 0 || type == 1) && hwChan < maxChan;
                if (chanOk && type == 1 && hwChan >= 0) {
                    this.addToChannelMap(this.pwrChannelMap, hwChan, name);
                }
            }
            if (!chanOk) {
                LOG.log(Level.SEVERE, "{0} config parameter {1} {2}", new Object[]{this.rebPath, "hw channel number", hwChan});
                throw new RuntimeException("Fatal configuration error");
            }
            switch (type) {
                case 0: {
                    ++this.numTemp;
                    break;
                }
                case 1: {
                    ++this.numPower;
                    break;
                }
                case 3: {
                    ++this.numAtemp;
                    break;
                }
                case 4: {
                    ++this.numBiasVolt;
                    break;
                }
                case 6: {
                    ++this.numCrVolt;
                    break;
                }
                case 5: {
                    ++this.numCcdCurrents;
                    break;
                }
                case 2: {
                    ++this.numRtd;
                }
            }
        }
        catch (Exception e) {
            this.dropChannel(id);
        }
    }

    protected String getGroupForChannel(Channel ch) {
        try {
            String typeStr = ch.getTypeStr();
            int type = this.convertTypeStrToInt(typeStr);
            switch (type) {
                case 0: {
                    return ChannelGroup.rebTemp.name();
                }
                case 1: {
                    return ChannelGroup.boardPower.name();
                }
                case 3: {
                    return ChannelGroup.aspicTemp.name();
                }
                case 6: {
                    return ChannelGroup.crVolt.name();
                }
                case 4: {
                    return ChannelGroup.biasVolt.name();
                }
                case 5: {
                    return ChannelGroup.ccdCurrent.name();
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Problem fetching group information for channel " + ch.getName(), e);
        }
    }

    private double[] getNaNArray(int length) {
        double[] allNaN = new double[length];
        for (int i = 0; i < length; ++i) {
            allNaN[i] = Double.NaN;
        }
        return allNaN;
    }

    protected void readChannelGroup(String group) {
        try {
            ChannelGroup g = ChannelGroup.valueOf(group);
            if (!this.online) {
                return;
            }
            String item = "";
            try {
                switch (g) {
                    case aspicTemp: {
                        if (this.numAtemp <= 0) break;
                        item = "aspic temperatures";
                        this.atempValues = this.slow.readAspicTemps(0, this.maxAtemp);
                        break;
                    }
                    case biasVolt: 
                    case crVolt: {
                        if (this.numBiasVolt + this.numCrVolt <= 0) break;
                        item = "CCD voltages";
                        try {
                            this.adcValues = this.slow.readVoltages();
                            break;
                        }
                        catch (REBException e) {
                            this.adcValues = this.getNaNArray(this.adcValues.length);
                            throw e;
                        }
                    }
                    case ccdCurrent: {
                        if (this.numCcdCurrents <= 0) break;
                        item = "CCD output currents";
                        try {
                            this.ccdCurrents = this.slow.readCurrents();
                            break;
                        }
                        catch (REBException e) {
                            this.ccdCurrents = this.getNaNArray(this.ccdCurrents.length);
                            throw e;
                        }
                    }
                    case boardPower: {
                        if (this.numPower <= 0) break;
                        try {
                            this.powerValues = this.pwr.readAdcs();
                            break;
                        }
                        catch (REBException e) {
                            for (int j = 0; j < this.powerValues.length; ++j) {
                                this.powerValues[j] = Double.NaN;
                            }
                            if (e instanceof REBTimeoutException) break;
                            item = "board power";
                            throw e;
                        }
                    }
                    case rebTemp: {
                        if (this.numTemp <= 0) break;
                        try {
                            this.tempValues = this.tmp.readAdcs();
                            break;
                        }
                        catch (REBException e) {
                            for (int j = 0; j < this.tempValues.length; ++j) {
                                this.tempValues[j] = Double.NaN;
                            }
                            if (e instanceof REBTimeoutException) {
                                LOG.log(Level.FINE, this.rebPath + "tmp.readAdcs(): Completion wait");
                                break;
                            }
                            item = "board temperatures";
                            throw e;
                        }
                    }
                    default: {
                        throw new RuntimeException("Implementation is missing for group: " + (Object)((Object)g));
                    }
                }
                this.errorCount = 0;
            }
            catch (REBException e) {
                LOG.log(Level.SEVERE, "Error reading {0} {1}: {2}", new Object[]{this.name, item, e.getMessage()});
                this.checkErrorCount(e.getMessage());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not read channels for group: " + group, e);
        }
    }

    protected void readChannelGroup() {
    }

    protected double readChannel(int hwChan, int type) {
        double value = Double.NaN;
        if (this.online) {
            String item = "";
            try {
                switch (type) {
                    case 2: {
                        item = "RTD";
                        value = hwChan < 4 ? this.rtd.readTemperature(hwChan) : (hwChan == 4 ? this.rtd.readIntTemperature() : this.rtd.readIntVoltage());
                        this.errorCount = 0;
                        break;
                    }
                    case 8: {
                        item = "HV bias switch";
                        value = this.bss.isBackBiasOn() ? 1.0 : 0.0;
                        HVBiasState newState = value > 0.0 ? HVBiasState.ON : HVBiasState.OFF;
                        this.stateService.updateAgentComponentState((Object)this, new Enum[]{newState});
                        this.errorCount = 0;
                        break;
                    }
                    case 1: {
                        if (hwChan >= 0) {
                            value = this.powerValues[hwChan];
                            break;
                        }
                        value = 0.0;
                        for (int j = 0; j < this.powerValues.length; j += 2) {
                            value += this.powerValues[j] * this.powerValues[j + 1];
                        }
                        value += this.heaterValues[1];
                        break;
                    }
                    case 0: {
                        value = this.tempValues[hwChan];
                        break;
                    }
                    case 3: {
                        value = this.atempValues[hwChan];
                        break;
                    }
                    case 7: {
                        value = this.heaterValues[hwChan];
                        break;
                    }
                    case 5: {
                        value = this.ccdCurrents[hwChan];
                        break;
                    }
                    case 4: 
                    case 6: {
                        value = this.adcValues[hwChan];
                    }
                }
            }
            catch (REBException e) {
                LOG.log(Level.SEVERE, "Error reading {0} {1}: {2}", new Object[]{this.name, item, e.getMessage()});
                this.checkErrorCount(e.getMessage());
            }
        }
        return value;
    }

    public double readChannelNow(int hwChan, int type) {
        double value = Double.NaN;
        if (this.online) {
            String item = "";
            try {
                switch (type) {
                    case 0: {
                        item = "board temperature";
                        value = this.tmp.readAdc(hwChan);
                        this.errorCount = 0;
                        break;
                    }
                    case 1: {
                        item = "board power";
                        value = this.pwr.readAdc(hwChan);
                        this.errorCount = 0;
                        break;
                    }
                    case 3: {
                        item = "aspic temperature";
                        value = this.slow.readAspicTemp(hwChan / 2, hwChan % 2);
                        this.errorCount = 0;
                        break;
                    }
                    case 6: {
                        item = "CCD voltage";
                        value = this.slow.readVoltageNow(hwChan);
                        this.errorCount = 0;
                        break;
                    }
                    default: {
                        value = super.readChannelNow(hwChan, type);
                        break;
                    }
                }
            }
            catch (REBException e) {
                LOG.log(Level.SEVERE, "Error reading {0} {1}: {2}", new Object[]{this.name, item, e.getMessage()});
                this.checkErrorCount(e.getMessage());
            }
        }
        return value;
    }

    public double[] readPowerAdcs() throws RaftException {
        try {
            return this.pwr.readAdcs();
        }
        catch (REBException e) {
            throw new RaftException((Throwable)e);
        }
    }

    public double[] readPowerAdcs(List<AdcData> dataList) throws RaftException {
        CCSTimeStamp tstamp = CCSTimeStamp.currentTime();
        double[] values = this.readPowerAdcs();
        if (dataList != null) {
            for (int chan = 0; chan < values.length; ++chan) {
                dataList.add(new AdcData(0, chan, values[chan], tstamp));
            }
        }
        return values;
    }

    public double[] readSlowAdcs(List<AdcData> dataList) throws RaftException {
        double[] fullData;
        int nAdc = this.rebType == 0 ? 18 : (this.rebType == 1 ? 14 : (this.rebType == 2 ? 10 : 0));
        double[] data = new double[nAdc];
        CCSTimeStamp tstamp = CCSTimeStamp.currentTime();
        if (nAdc == 0) {
            return data;
        }
        try {
            fullData = this.slow.readVoltages();
        }
        catch (REBException e) {
            throw new RaftException((Throwable)e);
        }
        for (int adc = 0; adc < nAdc; ++adc) {
            data[adc] = fullData[adcChans[adc]];
            if (dataList == null) continue;
            dataList.add(new AdcData(1, adcChans[adc], data[adc], tstamp));
        }
        return data;
    }

    public void readAllAdcs(List<AdcData> dataList) throws RaftException {
        this.readSlowAdcs(dataList);
        this.readPowerAdcs(dataList);
    }

    @Command(type=Command.CommandType.ACTION, description="get underMask protection register value")
    public int getUnders() throws RaftException {
        int underMask;
        try {
            underMask = this.dac.getUnders();
        }
        catch (REBException e) {
            throw new RaftException((Throwable)e);
        }
        return underMask;
    }

    public static String getAdcName(int adc) {
        return adcNames[adc];
    }

    public int readSeqIdleState() throws RaftException {
        try {
            return this.seq.readIdleState();
        }
        catch (REBException e) {
            throw new RaftException((Throwable)e);
        }
    }

    public void writeSeqIdleState(int value) throws RaftException {
        try {
            this.seq.writeIdleState(value);
        }
        catch (REBException e) {
            throw new RaftException((Throwable)e);
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the REB configuration data")
    public void setREBConfig(@Argument(name="reb", description="REB configuration data") REB reb) throws RaftException {
        this.dacCtrl.setConfig(reb.getDacs());
        BiasDACS[] biasConfig = reb.getBiases();
        for (int j = 0; j < biasConfig.length; ++j) {
            BiasControl bias = this.biases[j];
            if (bias == null) continue;
            bias.setConfig(biasConfig[j]);
        }
        ASPIC[] aspicConfig = reb.getAspics();
        for (int j = 0; j < aspicConfig.length; ++j) {
            AspicControl aspic = this.aspics[j];
            if (aspic == null) continue;
            aspic.setConfig(aspicConfig[j]);
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the REB configuration data")
    public REB getREBConfig() {
        REB reb = new REB();
        reb.setId(this.id);
        reb.setIfcName(this.ifcName);
        reb.setCcdMask(this.realCcdMask);
        reb.setMaxCcdMask(this.realCcdMask);
        reb.setDacVersion(DacControl.getHwVersion(this.dac));
        reb.setDacRaw(this.dacRaw);
        reb.setBiasVersion(BiasControl.getHwVersion(this.dac));
        reb.setBiasRaw(this.biasRaw);
        reb.setAspicVersion(AspicControl.getHwVersion(this.asp));
        this.dacCtrl.getConfig(reb.getDacs());
        BiasDACS[] biasConfig = reb.getBiases();
        for (int j = 0; j < this.biases.length; ++j) {
            BiasControl bias = this.biases[j];
            if (bias == null) continue;
            biasConfig[j] = bias.getConfig();
        }
        ASPIC[] aspicConfig = reb.getAspics();
        for (int j = 0; j < this.aspics.length; ++j) {
            AspicControl aspic = this.aspics[j];
            if (aspic == null) continue;
            aspicConfig[j] = aspic.getConfig();
        }
        return reb;
    }

    @Command(type=Command.CommandType.CONFIGURATION, description="Set TM for all ASPICs on this REB")
    public void setAllAspicTM(boolean tm) {
        this.setAllAspic("tm", tm ? 1 : 0);
    }

    @Command(type=Command.CommandType.CONFIGURATION, description="Set gain for all ASPICs on this REB")
    public void setAllAspicGain(int gain) {
        this.setAllAspic("gain", gain);
    }

    @Command(type=Command.CommandType.CONFIGURATION, description="Set RC for all ASPICs on this REB")
    public void setAllAspicRc(int rc) {
        this.setAllAspic("rc", rc);
    }

    private void setAllAspic(String parmName, int val) {
        this.setAllAspic(parmName, val, true);
    }

    public void setAllAspic(String parmName, int val, boolean commit) {
        for (AspicControl aspic : this.aspics) {
            if (aspic == null) continue;
            this.subsys.getComponentConfigurationEnvironment((Object)aspic).submitChange(parmName, (Object)val);
        }
        if (commit) {
            this.sce.commitBulkChange();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Perform CCD power on/off sequence", level=3)
    public void powerCCDs(@Argument(description="Whether to power on") boolean on) throws RaftException {
        if (on) {
            this.powerCCDsOn();
        } else {
            this.powerCCDsOff();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="get CCD Power State", level=3)
    public String getCCDsPowerState() throws RaftException {
        ArrayList<AdcData> adcDataList = new ArrayList<AdcData>();
        CCDsPowerState powerState = this.getCCDsPowerState(adcDataList);
        this.publishAllAdcData(adcDataList);
        return powerState.name();
    }

    private CCDsPowerState getCCDsPowerState(List<AdcData> adcDataList) throws RaftException {
        CCDsPowerState powerState = CCDsPowerState.UNKNOWN;
        try {
            powerState = this.setCCDsPowerState(adcDataList, true);
        }
        catch (RaftException e) {
            LOG.log(Level.SEVERE, "FAILED to determine CCDsPowerState for " + this.rebPath);
            LOG.log(Level.SEVERE, "CCDsPowerState changed to " + this.stateService.getComponentState(this.rebPath, CCDsPowerState.class).name());
            LOG.log(Level.SEVERE, "calling powerCCDsOff() on " + this.rebPath);
            try {
                this.powerCCDsOff(adcDataList);
            }
            catch (RaftException et) {
                LOG.log(Level.SEVERE, "powerCCDsOff() FAILED for " + this.rebPath);
                LOG.log(Level.SEVERE, "CCDsPowerState changed to " + this.stateService.getComponentState(this.rebPath, CCDsPowerState.class).name());
                throw new RaftException("powerCCDsOff() FAILED, check/reboot " + this.rebPath, (Throwable)et);
            }
            this.publishAllAdcData(adcDataList);
            throw new RaftException("getCCDsPowerState() FAILED for " + this.rebPath, (Throwable)e);
        }
        return powerState;
    }

    @Command(type=Command.CommandType.ACTION, description="Perform CCD power on sequence", level=3)
    public void powerCCDsOn() throws RaftException {
        Object re = null;
        boolean all = true;
        boolean check = true;
        boolean powerOn = true;
        CCDsPowerState powerState = CCDsPowerState.UNKNOWN;
        ArrayList<AdcData> adcDataList = new ArrayList<AdcData>();
        this.readSlowAdcs(adcDataList);
        this.readPowerAdcs(adcDataList);
        try {
            if (this.sqp.isRunning()) {
                this.publishAllAdcData(adcDataList);
                throw new RaftException("Sequencer is running, it must be off to powerCCDsOn()");
            }
        }
        catch (REBException e) {
            throw new RaftException("Failed to determine sequencer state for " + this.rebPath, (Throwable)e);
        }
        powerState = this.getCCDsPowerState(adcDataList);
        if (!powerState.equals((Object)CCDsPowerState.OFF)) {
            this.publishAllAdcData(adcDataList);
            throw new RaftException("found CCDsPowerState: " + powerState.name() + " != OFF, command aborted");
        }
        try {
            if (this.isITLManufacturedCCD()) {
                this.loadDacs(all, check, powerOn, adcDataList);
                this.loadBiasDacs(all, check, powerOn, adcDataList);
            } else {
                this.loadBiasDacs(all, check, powerOn, adcDataList);
                this.loadDacs(all, check, powerOn, adcDataList);
            }
            this.readSlowAdcs(adcDataList);
            this.readPowerAdcs(adcDataList);
        }
        catch (RaftException e) {
            LOG.log(Level.SEVERE, "powerCCDsOn() FAILED for " + this.rebPath, e);
            LOG.log(Level.SEVERE, "calling powerCCDsOff() on " + this.rebPath);
            try {
                this.powerCCDsOff(adcDataList);
            }
            catch (RaftException et) {
                this.publishAllAdcData(adcDataList);
                LOG.log(Level.SEVERE, "powerCCDsOff() FAILED for " + this.rebPath);
                LOG.log(Level.SEVERE, "CCDsPowerState changed to " + this.stateService.getComponentState(this.rebPath, CCDsPowerState.class).name());
                throw new RaftException("powerCCDsOn failed, powerCCDsOff failed, check/reboot " + this.rebPath, (Throwable)et);
            }
            this.publishAllAdcData(adcDataList);
            LOG.log(Level.SEVERE, "CCDsPowerState changed to " + this.stateService.getComponentState(this.rebPath, CCDsPowerState.class).name());
            throw new RaftException("powerCCDsOn failed, CCS are powered OFF, check " + this.rebPath, (Throwable)e);
        }
        this.publishAllAdcData(adcDataList);
        this.stateService.updateAgentComponentState((Object)this, new Enum[]{CCDsPowerState.ON});
        LOG.log(Level.INFO, "CCDsPowerState changed to " + this.stateService.getComponentState(this.rebPath, CCDsPowerState.class).name());
        this.forceDataPublicationForNextUpdateIterations(this.nPowerOnPub);
    }

    @Command(type=Command.CommandType.ACTION, description="Perform CCD power off sequence", level=3)
    public void powerCCDsOff() throws RaftException {
        ArrayList<AdcData> adcDataList = new ArrayList<AdcData>();
        try {
            this.powerCCDsOff(adcDataList);
        }
        catch (RaftException e) {
            this.publishAllAdcData(adcDataList);
            throw new RaftException("Exception occurred in powerCCDsOff() on" + this.rebPath, (Throwable)e);
        }
        this.publishAllAdcData(adcDataList);
    }

    private synchronized void powerCCDsOff(List<AdcData> adcDataList) throws RaftException {
        boolean backBiasState = true;
        try {
            backBiasState = this.bss.isBackBiasOn();
        }
        catch (REBException e) {
            LOG.log(Level.SEVERE, "Error checking back bias for " + this.rebPath, e);
        }
        try {
            this.bss.setBackBias(false);
        }
        catch (REBException e) {
            LOG.log(Level.SEVERE, "Error setting back bias OFF for " + this.rebPath, e);
        }
        if (backBiasState) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LOG.log(Level.SEVERE, "Thread.sleep(100) interrupted after setBackBias(false) for " + this.rebPath, e);
            }
        }
        try {
            if (this.isITLManufacturedCCD()) {
                this.clearBiasDacs();
                this.clearDacs();
            } else {
                this.clearDacs();
                this.clearBiasDacs();
            }
        }
        catch (RaftException e) {
            this.stateService.updateAgentComponentState((Object)this, new Enum[]{CCDsPowerState.FAULT});
            throw new RaftException("Exception occurred in powerCCDsOff() on" + this.rebPath, (Throwable)e);
        }
        this.readAllAdcs(adcDataList);
        this.stateService.updateAgentComponentState((Object)this, new Enum[]{CCDsPowerState.OFF});
        LOG.log(Level.INFO, String.format("powerCCDsOff(): CCDsPowerState set %s to %s", this.rebPath, this.stateService.getComponentState(this.rebPath, CCDsPowerState.class).name()));
    }

    @Command(type=Command.CommandType.ACTION, description="Set CCD Clock lines to low state", level=3)
    public void setCCDClocksLow() throws RaftException {
        int seqState = this.readSeqIdleState();
        this.writeSeqIdleState(seqState & 0xFFFFF00F);
        LOG.log(Level.INFO, String.format("%s lowering sequencer clocks: 0x%x --> 0x%x", this.rebPath, seqState, seqState & 0xFFFFF00F));
        LOG.log(Level.INFO, String.format("setCCDClocksLow() finished for %s", this.rebPath));
    }

    private CCDsPowerState setCCDsPowerState(boolean forceMeas) throws RaftException {
        ArrayList<AdcData> adcDataList = new ArrayList<AdcData>();
        return this.setCCDsPowerState(adcDataList, forceMeas);
    }

    private synchronized CCDsPowerState setCCDsPowerState(List<AdcData> adcDataList, boolean forceMeas) throws RaftException {
        double[] slowAdcs;
        double[] curPower;
        int nAdc;
        int nccds;
        CCDsPowerState powerState = CCDsPowerState.UNKNOWN;
        int onCnt = 0;
        int offCnt = 0;
        int dltaCnt = 0;
        int testCntTot = 0;
        Object re = null;
        boolean seqLoaded = false;
        boolean failed = false;
        boolean testFailed = false;
        ArrayList<String> tmsgList = new ArrayList<String>();
        int biasDacState = -1;
        int clockDacState = -1;
        int n = this.rebType == 0 ? 3 : (this.rebType == 1 ? 2 : (nccds = this.rebType == 2 ? 1 : 0));
        int n2 = this.rebType == 0 ? 18 : (this.rebType == 1 ? 14 : (nAdc = this.rebType == 2 ? 10 : 0));
        if (!this.isOnline()) {
            if (this.stateService.isComponentInState(this.rebPath, (Enum)CCDsPowerState.UNKNOWN)) {
                LOG.log(Level.INFO, "setCCDsPowerState() called in OFFLINE state on " + this.rebPath);
                return CCDsPowerState.UNKNOWN;
            }
            String pState = this.stateService.getComponentState(this.rebPath, CCDsPowerState.class).name();
            LOG.log(Level.SEVERE, "CCDsPowerState:{0} is inconsistent with OFFLINE {1}", new Object[]{pState, this.rebPath});
            this.stateService.updateAgentComponentState((Object)this, new Enum[]{CCDsPowerState.FAULT});
            throw new RaftException("CCDsPowerState() not UNKNOW when called on OFFLINE " + this.rebPath);
        }
        if (forceMeas) {
            int underMask;
            try {
                seqLoaded = this.readSeqIdleState() != 0;
                curPower = this.readPowerAdcs(adcDataList);
                slowAdcs = this.readSlowAdcs(adcDataList);
                underMask = this.getUnders();
            }
            catch (RaftException e) {
                this.stateService.updateAgentComponentState((Object)this, new Enum[]{CCDsPowerState.FAULT});
                throw new RaftException(String.format("Fault measuring CCDsPowerState for %s", this.rebPath), (Throwable)e);
            }
            int underSet = this.rebType == 0 ? 511 : (this.rebType == 1 ? 63 : (this.rebType == 2 ? 7 : 65535));
            ++testCntTot;
            if (underMask == underSet) {
                tmsgList.add(String.format("%s: firmware protected biases test as OFF: 0x%x == 0x%x", this.rebPath, underMask, underSet));
                ++offCnt;
            } else if (underMask == 0) {
                tmsgList.add(String.format("%s: firmware protected biases test as ON: 0x%x == 0", this.rebPath, underMask));
                ++onCnt;
            } else {
                tmsgList.add(String.format("%s: firmware protection biases in UNDEFINED state: 0x%x != 0x%x", this.rebPath, underMask, underSet));
                failed = true;
                testFailed = true;
            }
            tmsgList.add(String.format("Test %d: %s firmware protection for %s", testCntTot, testFailed ? "FAILED" : "PASSED", this.rebPath));
        } else {
            seqLoaded = true;
            slowAdcs = new double[nAdc];
            for (int adc = 0; adc < nAdc; ++adc) {
                slowAdcs[adc] = this.adcValues[adcChans[adc]];
            }
            curPower = this.powerValues;
        }
        testFailed = false;
        ++testCntTot;
        if (this.odiQmax >= this.odiAmin) {
            tmsgList.add(String.format("Bad configuration: odiQmax:(%f) >= odiAmin:(%f)", this.odiQmax, this.odiAmin));
            failed = true;
            testFailed = true;
        } else if (curPower[7] < (double)nccds * this.odiQmax) {
            tmsgList.add(String.format("ODI current is nominal for CCDs OFF State: %.2f mA", curPower[7] * 1000.0));
            ++offCnt;
        } else if (curPower[7] > (double)nccds * this.odiAmin) {
            tmsgList.add(String.format("ODI current is nominal for CCDs ON State: %.2f mA", curPower[7] * 1000.0));
            ++onCnt;
        } else {
            tmsgList.add(String.format("%s: mixed/undefined power state: %.2f < (ODI = %.2f) < %.2f", this.rebPath, (double)nccds * this.odiQmax * 1000.0, curPower[7] * 1000.0, (double)nccds * this.odiAmin * 1000.0));
            tmsgList.add(String.format("%s: ODI current NOT in ON or OFF range", this.rebPath));
            failed = true;
            testFailed = true;
        }
        tmsgList.add(String.format("Test %d: %s REB ODI current test for  %s", testCntTot, testFailed ? "FAILED" : "PASSED", this.rebPath));
        if (this.rebType == 0) {
            testFailed = false;
            ++testCntTot;
            if (this.clkliQmax >= this.clkliAmin) {
                tmsgList.add(String.format("Bad configuration: clkliQmax:(%f) >= clkliAmin:(%f)", this.clkliQmax, this.clkliAmin));
                failed = true;
                testFailed = true;
            } else if (curPower[9] < this.clkliQmax) {
                tmsgList.add(String.format("CLKLI current is nominal for CCDs OFF State %.2f mA", curPower[9] * 1000.0));
                ++offCnt;
            } else if (curPower[9] > this.clkliAmin) {
                tmsgList.add(String.format("CLKLI current is nominal for CCDs ON State %.2f mA", curPower[9] * 1000.0));
                ++onCnt;
            } else {
                tmsgList.add(String.format("%s: CCDs in mixed or undefined power state: %.2f < (CLKLI = %.2f) < %.2f", this.rebPath, this.clkliQmax * 1000.0, curPower[9] * 1000.0, this.clkliAmin * 1000.0));
                tmsgList.add(String.format("%s: CLKLI current NOT in ON or OFF range", this.rebPath));
                failed = true;
                testFailed = true;
            }
            tmsgList.add(String.format("Test %d: %s REB CLKLI current test for  %s", testCntTot, testFailed ? "FAILED" : "PASSED", this.rebPath));
            testFailed = false;
            ++testCntTot;
            if (this.clkhiQmax >= this.clkhiAmin) {
                tmsgList.add(String.format("Bad configuration: clkhiQmax:(%f) >= clkhiAmin:(%f)", this.clkhiQmax, this.clkhiAmin));
                failed = true;
                testFailed = true;
            }
            if (curPower[5] < this.clkhiQmax) {
                tmsgList.add(String.format("CLKHI current is nominal for CCDs OFF State %.2f mA", curPower[5] * 1000.0));
                ++offCnt;
            } else if (curPower[5] > this.clkhiAmin) {
                tmsgList.add(String.format("CLKHI current is nominal for CCDs ON State %.2f mA", curPower[5] * 1000.0));
                ++onCnt;
            } else {
                tmsgList.add(String.format("%s: CCDs in mixed or undefined power state: %.2f < (CLKHI = %.2f) < %.2f", this.rebPath, this.clkhiQmax * 1000.0, curPower[5] * 1000.0, this.clkhiAmin * 1000.0));
                tmsgList.add(String.format("\n  %s: CLKHI current NOT in ON or OFF range", this.rebPath));
                failed = true;
                testFailed = true;
            }
            tmsgList.add(String.format("Test %d: %s REB CLKHI current test for  %s", testCntTot, testFailed ? "FAILED" : "PASSED", this.rebPath));
        }
        for (BiasControl bias : this.biases) {
            if (bias == null) continue;
            testFailed = false;
            ++testCntTot;
            biasDacState = -1;
            biasDacState = bias.getBiasDacsPowerState(slowAdcs, tmsgList);
            if (biasDacState == 0) {
                ++offCnt;
            } else if (biasDacState == 1) {
                ++onCnt;
            } else if (biasDacState > 1) {
                ++onCnt;
                dltaCnt += biasDacState - 1;
            } else {
                tmsgList.add(String.format("%s: CCDs Bias voltage test FAILED", this.rebPath));
                failed = true;
                testFailed = true;
            }
            tmsgList.add(String.format("Test %d: %s Bias level test for  %s", testCntTot, testFailed ? "FAILED" : "PASSED", bias.biasPath));
        }
        testFailed = false;
        ++testCntTot;
        clockDacState = -1;
        double uClockDacOffset = seqLoaded ? 0.9 : 0.0;
        clockDacState = this.dacCtrl.getClockDacsPowerState(slowAdcs, tmsgList, uClockDacOffset);
        if (clockDacState == 0) {
            ++offCnt;
        } else if (clockDacState == 1) {
            ++onCnt;
        } else if (clockDacState > 1) {
            ++onCnt;
            dltaCnt += clockDacState - 1;
        } else {
            tmsgList.add(String.format("%s: CCDs clock voltage test FAILED", this.rebPath));
            failed = true;
            testFailed = true;
        }
        tmsgList.add(String.format("Test %d: %s Clock rails test for  %s", testCntTot, testFailed ? "FAILED" : "PASSED", this.dacCtrl.dacPath));
        if (offCnt == testCntTot) {
            powerState = CCDsPowerState.OFF;
        } else if (onCnt == testCntTot && dltaCnt == 0) {
            powerState = CCDsPowerState.ON;
        } else if (onCnt == testCntTot && dltaCnt > 0) {
            powerState = CCDsPowerState.DELTA;
        } else {
            powerState = CCDsPowerState.FAULT;
            failed = true;
        }
        this.stateService.updateAgentComponentState((Object)this, new Enum[]{powerState});
        tmsgList.add(String.format("%s: setCCDsPowerState() %s: %d:%d:%d OFF:ON:DELTA of %d tests passed", this.rebPath, failed ? "FAILED" : "PASSED", offCnt, onCnt, dltaCnt, testCntTot));
        tmsgList.add(String.format("%s CCDsPowerState updated to %s", this.rebPath, powerState.name()));
        for (String tmsg : tmsgList) {
            LOG.log(failed ? Level.SEVERE : Level.FINE, tmsg);
        }
        if (failed) {
            throw new RaftException(String.format("%s, see logfile for details", tmsgList.get(tmsgList.size() - 1)));
        }
        return powerState;
    }

    @Command(type=Command.CommandType.ACTION, description="Report Bias, Clock lines set/read deltas and DAC calibration", level=3)
    public String checkDacsCalibration() throws RaftException {
        ArrayList<AdcData> adcDataList = new ArrayList<AdcData>();
        String result = this.setDacsCalibration(adcDataList, false);
        this.publishAllAdcData(adcDataList);
        return result;
    }

    @Command(type=Command.CommandType.ACTION, description="Report and update Bias, Clock lines set/read deltas and DAC calibration", level=3)
    public String updateDacsCalibration() throws RaftException {
        ArrayList<AdcData> adcDataList = new ArrayList<AdcData>();
        String result = this.setDacsCalibration(adcDataList, true);
        this.publishAllAdcData(adcDataList);
        return result;
    }

    private String setDacsCalibration(List<AdcData> adcDataList, boolean action) throws RaftException {
        double[] slowAdcs;
        CCDsPowerState powerState = CCDsPowerState.UNKNOWN;
        boolean testCntTot = false;
        ArrayList<String> tmsgList = new ArrayList<String>();
        StringBuilder result = new StringBuilder();
        boolean doAction = false;
        int errCnt = 0;
        int hdrStart = 0;
        this.readSlowAdcs(adcDataList);
        this.readPowerAdcs(adcDataList);
        try {
            if (this.sqp.isRunning()) {
                this.publishAllAdcData(adcDataList);
                throw new RaftException("Sequencer is running, it must be idle");
            }
        }
        catch (REBException e) {
            throw new RaftException(String.format("failed to determine Sequencer state on %s", this.rebPath), (Throwable)e);
        }
        powerState = this.setCCDsPowerState(adcDataList, true);
        if (!powerState.equals((Object)CCDsPowerState.ON)) {
            this.publishAllAdcData(adcDataList);
            throw new RaftException("command aborted, CCDsPowerState must be ON for this command");
        }
        if (this.isBackBiasOn()) {
            this.publishAllAdcData(adcDataList);
            throw new RaftException("command aborted, backBias must be off for this command");
        }
        if (action && this.checkCategoriesForIsDirty(RAFTS, RAFTS_POWER)) {
            throw new RaftException("command aborted: Rafts or RaftsPower categories are DIRTY");
        }
        if (action) {
            doAction = true;
        }
        if (action && !this.sce.getAllSubmittedChanges().isEmpty()) {
            throw new RaftException("command aborted: subsystem has uncommitted changes");
        }
        if (action) {
            doAction = true;
        }
        try {
            slowAdcs = this.readSlowAdcs(adcDataList);
        }
        catch (RaftException e) {
            throw new RaftException("REB voltage measurements failed for " + this.rebPath, (Throwable)e);
        }
        for (BiasControl bias : this.biases) {
            if (bias == null) continue;
            errCnt += bias.setBiasDacsCalibration(slowAdcs, tmsgList, doAction);
        }
        if ((errCnt += this.dacCtrl.setClockDacsCalibration(slowAdcs, tmsgList, doAction)) == 0 && doAction) {
            try {
                this.sce.commitBulkChange();
            }
            catch (Exception e) {
                this.sce.dropAllSubmittedChanges();
                throw new RaftException("Configuration change failed", (Throwable)e);
            }
        } else if (errCnt > 0 && doAction) {
            tmsgList.add(hdrStart++, String.format("Error: %d Offset adjustments were above limit: %5.2f", errCnt, this.maxStep));
        }
        tmsgList.add(hdrStart++, String.format("\n%-8.8s %-8.8s %6.6s %6.6s  %6.6s --> %-6.6s  %8.7s --> %-8.7s  %5.5s --> %-5.5s  %6.6s --> %-6.6s", "Raft/Reb", "Bias/Clk", "xxP", "xxMeas", "xxCal", "xxCal", "xxTol", "xxTol", "DAC", "DAC", "xxConv", "xxConv"));
        if (action && !doAction) {
            tmsgList.add(hdrStart++, String.format("\nError: Updating not allowed due to errors", new Object[0]));
        }
        for (String tmsg : tmsgList) {
            LOG.log(Level.FINE, tmsg);
            result.append(tmsg);
            result.append("\n");
        }
        return result.toString();
    }

    private boolean checkCategoriesForIsDirty(String ... categories) {
        boolean isDirty = false;
        ConfigurationInfo ci = this.sce.getConfigurationInfo();
        block0: for (String category : categories) {
            Map parsForCategory = ci.getCurrentParameterInfoForCategory(category);
            for (ConfigurationParameterInfo par : parsForCategory.values()) {
                if (!par.getComponentName().contains(this.rebPath) || !par.isDirty()) continue;
                isDirty |= true;
                LOG.log(Level.INFO, par.getCategoryName() + ":" + par.getComponentName() + "/" + par.getParameterName() + " has unsaved changes");
                continue block0;
            }
        }
        return isDirty;
    }

    @Command(type=Command.CommandType.ACTION, description="Perform CCD shorts test", level=3)
    public void testCCDShorts() throws RaftException {
        ArrayList<AdcData> adcDataList = new ArrayList<AdcData>();
        Object re = null;
        boolean failed = false;
        CCDsPowerState powerState = CCDsPowerState.UNKNOWN;
        int seqState = 0;
        ArrayList<String> tmsgList = new ArrayList<String>();
        try {
            if (this.sqp.isRunning()) {
                throw new RaftException("Sequencer is running, it must be off to testCCDShorts()");
            }
            seqState = this.readSeqIdleState();
        }
        catch (REBException e) {
            throw new RaftException((Throwable)e);
        }
        powerState = this.setCCDsPowerState(adcDataList, true);
        if (!powerState.equals((Object)CCDsPowerState.OFF)) {
            throw new RaftException("CCDs must be OFF, found " + powerState.name() + ", testCCDShorts() aborted");
        }
        this.powerCCDsOff(adcDataList);
        try {
            this.writeSeqIdleState(seqState & 0xFFFFF00F);
            LOG.log(Level.INFO, String.format("%s lowering sequencer clocks for shorts test: 0x%x --> 0x%x", this.rebPath, seqState, this.readSeqIdleState()));
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                LOG.log(Level.SEVERE, "Thread.sleep(200) interrupted after lowering sequencer clocks for " + this.rebPath, e);
            }
            for (BiasControl bias : this.biases) {
                if (bias == null) continue;
                failed |= bias.testShorts(adcDataList, tmsgList);
                this.publishAllAdcData(adcDataList);
            }
            failed |= this.dacCtrl.testShorts(adcDataList, tmsgList);
            this.publishAllAdcData(adcDataList);
            LOG.log(Level.INFO, String.format("%s restoring sequencer clocks after shorts test: 0x%x --> 0x%x", this.rebPath, this.readSeqIdleState(), seqState));
            this.writeSeqIdleState(seqState);
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                LOG.log(Level.SEVERE, "Thread.sleep(20) interrupted after restoring sequencer clocks for " + this.rebPath, e);
            }
            this.readSlowAdcs(adcDataList);
            this.readPowerAdcs(adcDataList);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                LOG.log(Level.SEVERE, "Thread.sleep(200) interrupted after restoring sequencer clocks for " + this.rebPath, e);
            }
            this.readSlowAdcs(adcDataList);
            this.readPowerAdcs(adcDataList);
        }
        catch (RaftException e) {
            this.powerCCDsOff(adcDataList);
            this.publishAllAdcData(adcDataList);
            this.writeSeqIdleState(seqState);
            throw new RaftException(String.format("testCCDShorts() FAILED for %s", this.rebPath), (Throwable)e);
        }
        this.publishAllAdcData(adcDataList);
        if (failed) {
            tmsgList.add(String.format("%s shorts test FAILED", this.rebPath));
            for (String tmsg : tmsgList) {
                LOG.log(Level.SEVERE, tmsg);
            }
            throw new RaftException(String.format("%s, see logfile for details", tmsgList.get(tmsgList.size() - 1)));
        }
        for (String tmsg : tmsgList) {
            LOG.log(Level.FINE, tmsg);
        }
        LOG.log(Level.INFO, "testCCDShorts() finished successfully");
        this.forceDataPublicationForNextUpdateIterations(5);
    }

    private void publishAllAdcData(List<AdcData> adcDataList) {
        KeyValueDataList dataList = new KeyValueDataList();
        for (AdcData adcData : adcDataList) {
            String chanName = (adcData.type == 0 ? this.pwrChannelMap : this.sadcChannelMap).get(adcData.hwChan);
            if (chanName == null) continue;
            double conv = adcData.type == 0 && (adcData.hwChan & 1) != 0 ? 1000.0 : 1.0;
            dataList.addData(chanName, (Serializable)Double.valueOf(conv * adcData.value), adcData.timeStamp);
        }
        if (!dataList.getListOfKeyValueData().isEmpty()) {
            this.subsys.publishSubsystemDataOnStatusBus((KeyValueData)dataList);
        }
        adcDataList.clear();
    }

    @Command(type=Command.CommandType.ACTION, description="Applies changed Bias and Clock DAC configuration values on Powered CCDs", level=3)
    public int loadDeltaDacs(@Argument(description="reload all (true) or changes only (false)") boolean all) throws RaftException {
        CCDsPowerState powerState = CCDsPowerState.UNKNOWN;
        int count = 0;
        ArrayList<AdcData> adcDataList = new ArrayList<AdcData>();
        powerState = this.getCCDsPowerState(adcDataList);
        if (!powerState.equals((Object)CCDsPowerState.ON) && !powerState.equals((Object)CCDsPowerState.DELTA)) {
            throw new RaftException("CCDs must be ON|DELTA to use loadDeltaDacs command, command aborted");
        }
        count = this.loadDeltaDacs(all, adcDataList);
        if (count < 0) {
            throw new RaftException(String.format("loadDeltaDacs() FAILED, %d params with step sizes > %.2f", -count, this.maxStep));
        }
        powerState = this.getCCDsPowerState(adcDataList);
        LOG.log(Level.INFO, String.format("%s CCDsPowerState updated to %s", this.rebPath, powerState.name()));
        this.publishAllAdcData(adcDataList);
        return count;
    }

    private int loadDeltaDacs(boolean all, List<AdcData> adcDataList) throws RaftException {
        double[] slowAdcs;
        int count = 0;
        int errCnt = 0;
        ArrayList<String> tmsgList = new ArrayList<String>();
        try {
            slowAdcs = this.readSlowAdcs(adcDataList);
        }
        catch (RaftException e) {
            throw new RaftException("REB voltage and current measurements failed for " + this.rebPath, (Throwable)e);
        }
        for (BiasControl bias : this.biases) {
            errCnt += bias.checkBiasStepLimits(slowAdcs, tmsgList);
        }
        errCnt += this.dacCtrl.checkClockStepLimits(slowAdcs, tmsgList);
        for (String tmsg : tmsgList) {
            LOG.log(errCnt > 0 ? Level.SEVERE : Level.FINE, tmsg);
        }
        if (errCnt > 0) {
            return -errCnt;
        }
        boolean check = true;
        boolean powerOn = false;
        try {
            for (BiasControl bias : this.biases) {
                if (bias == null) continue;
                count += all ? bias.load(this.dacLoadDelay, check, powerOn, adcDataList) : bias.loadChanged(this.dacLoadDelay, check, adcDataList);
            }
            LOG.log(Level.INFO, "Loaded {0} {1} Bias and Clock DACs", new Object[]{count += all ? this.dacCtrl.loadConfig(this.dacLoadDelay, check, powerOn, adcDataList) : this.dacCtrl.loadChanged(this.dacLoadDelay, check, adcDataList), this.rebPath});
        }
        catch (RaftException e) {
            try {
                this.powerCCDsOff(adcDataList);
            }
            catch (RaftException et) {
                LOG.log(Level.SEVERE, "loadDeltaDacs() FAILED for " + this.rebPath, e);
                LOG.log(Level.SEVERE, "CCDsPowerState changed to " + this.stateService.getComponentState(this.rebPath, CCDsPowerState.class).name());
                this.publishAllAdcData(adcDataList);
                throw new RaftException("loadDeltaDacs() failed, powerCCDsOff failed, check/reboot " + this.rebPath, (Throwable)et);
            }
            this.publishAllAdcData(adcDataList);
            LOG.log(Level.SEVERE, "called powerCCDsOff() on " + this.rebPath);
            throw new RaftException("loadDeltaDacs() FAILED for " + this.rebPath, (Throwable)e);
        }
        this.publishAllAdcData(adcDataList);
        this.forceDataPublicationForNextUpdateIterations(5);
        return count;
    }

    private int loadDacs(boolean all, boolean check, boolean powerOn, List<AdcData> adcDataList) throws RaftException {
        int count = all ? this.dacCtrl.loadConfig(this.dacLoadDelay, check, powerOn, adcDataList) : this.dacCtrl.loadChanged(this.dacLoadDelay, check, adcDataList);
        LOG.log(Level.INFO, "Loaded {0} {1} DACs", new Object[]{count, this.rebPath});
        return count;
    }

    private void clearDacs() throws RaftException {
        this.dacCtrl.clear(this.dacClearDelay);
    }

    private int loadBiasDacs(boolean all, boolean check, boolean powerOn, List<AdcData> adcDataList) throws RaftException {
        int count = 0;
        for (BiasControl bias : this.biases) {
            if (bias == null) continue;
            count += all ? bias.load(this.dacLoadDelay, check, powerOn, adcDataList) : bias.loadChanged(this.dacLoadDelay, check, adcDataList);
        }
        LOG.log(Level.INFO, "Loaded {0} {1} bias DACs", new Object[]{count, this.rebPath});
        return count;
    }

    private void clearBiasDacs() throws RaftException {
        for (BiasControl bias : this.biases) {
            if (bias == null) continue;
            bias.clear(this.dacClearDelay);
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Load configuration data to the ASPICs")
    public int loadAspics(boolean all) throws Exception {
        int count = 0;
        for (AspicControl aspic : this.aspics) {
            if (aspic == null) continue;
            count += all ? aspic.load() : aspic.loadChanged();
        }
        LOG.log(Level.INFO, "Loaded {0} {1} ASPICs", new Object[]{count, this.rebPath});
        return count;
    }

    @Command(type=Command.CommandType.ACTION, description="Reset the ASPICs")
    public int resetAspics() throws Exception {
        int count = 0;
        int mask = 0;
        for (AspicControl aspic : this.aspics) {
            int strip;
            if (aspic == null || (mask & 1 << (strip = aspic.getHwChan() / 2)) != 0) continue;
            count += aspic.reset();
            mask |= 1 << strip;
        }
        LOG.log(Level.INFO, "Reset {0} {1} ASPICs", new Object[]{count, this.rebPath});
        return count;
    }

    @Command(type=Command.CommandType.ACTION, description="Check loaded ASPIC configuration")
    public int checkAspics() throws Exception {
        int mask = 0;
        int index = 0;
        for (AspicControl aspic : this.aspics) {
            if (aspic == null) continue;
            mask |= aspic.check() << index;
            index += 4;
        }
        return mask;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the back bias on state")
    public boolean isBackBiasOn() throws RaftException {
        try {
            return this.bss.isBackBiasOn();
        }
        catch (REBException e) {
            throw new RaftException("Error getting back bias for" + this.rebPath, (Throwable)e);
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Turn back bias on or off")
    public void setBackBias(@Argument(description="The on state") boolean value) throws RaftException {
        try {
            this.bss.setBackBias(value);
        }
        catch (REBException e) {
            throw new RaftException("Error setting back bias for" + this.rebPath, (Throwable)e);
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set heater voltage")
    public void setHeater(@Argument(description="Heater number") int heater, @Argument(description="The voltage") double volts) throws RaftException {
        double amps = volts / 14.8;
        this.heaterValues[0] = volts;
        this.heaterValues[1] = amps * amps * 14.5;
        int value = (int)((this.dac.getVersion() == 6 ? 409.5 : 409.5) * volts);
        try {
            this.dac.set(heater == 0 ? 18 : 21, value < 0 ? 0 : (value > 4095 ? 4095 : value), true);
        }
        catch (REBException e) {
            throw new RaftException("Error setting heater for" + this.rebPath, (Throwable)e);
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set heater power")
    public void setHeaterPower(@Argument(description="Heater number") int heater, @Argument(description="The power value") double power) throws RaftException {
        this.setHeater(heater, 14.8 * Math.sqrt(power / 14.5));
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the time base to the current system time")
    public void setTime() throws RaftException {
        try {
            this.bss.disable();
            this.bss.setTime();
            this.bss.enable();
        }
        catch (REBException e) {
            throw new RaftException("setTime() failed" + this.rebPath, (Throwable)e);
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the time base as Unix time")
    public long getTime() throws RaftException {
        try {
            return this.bss.getTime();
        }
        catch (REBException e) {
            return 0L;
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Gets a trigger time as Unix time")
    public long getTime(@Argument(name="regset", description="Register set name") String rSet) throws RaftException {
        Integer regSet = rsetNames.get(rSet.toLowerCase());
        if (regSet == null) {
            throw new RaftException("Invalid register set name");
        }
        try {
            return this.bss.getTriggerTime(regSet.intValue());
        }
        catch (REBException e) {
            return 0L;
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the FITS file test conditions")
    public void setFitsConditions(@Argument(description="Filter name") String filter, @Argument(description="The temperature") double temperature, @Argument(description="The wavelength") double wavelength) {
        FitsHeaderKeywordData data = new FitsHeaderKeywordData(this.rebGeometry.getUniqueId());
        data.addHeaderKeywordValue("primary", "FilterName", (Serializable)((Object)filter), true);
        data.addHeaderKeywordValue("primary", "TemperatureSetPoint", (Serializable)Double.valueOf(temperature), true);
        data.addHeaderKeywordValue("primary", "MonochromatorWavelength", (Serializable)Double.valueOf(wavelength), true);
        this.subsys.publishSubsystemDataOnStatusBus(data.getKeyValueData());
    }

    @Command(type=Command.CommandType.QUERY, description="Get the DAQ metadata for the current image")
    public ImageMetadata getImageMetadata() throws RaftException {
        if (this.img == null) {
            throw new RuntimeException("This REB Device is not configured to process images");
        }
        return this.img.getImageMetadata();
    }

    @Command(type=Command.CommandType.QUERY, description="Gets a portion of the current image")
    public ImageData getImage(@Argument(description="Offset to the pixel data") int offset, @Argument(description="Number of pixels") int count) throws RaftException {
        if (this.img == null) {
            throw new RuntimeException("This REB Device is not configured to process images");
        }
        return this.img.getImage(0, offset, count);
    }

    @Command(type=Command.CommandType.QUERY, description="Gets a portion of the current image")
    public ImageData getImage(@Argument(description="CCD number") int ccd, @Argument(description="Offset to the pixel data") int offset, @Argument(description="Number of pixels") int count) throws RaftException {
        if (this.img == null) {
            throw new RuntimeException("This REB Device is not configured to process images");
        }
        return this.img.getImage(ccd, offset, count);
    }

    @Command(type=Command.CommandType.ACTION, description="Resets the front end")
    public void resetFrontEnd() throws RaftException {
        try {
            this.bss.reset(0);
            this.bss.enable();
            this.bss.setTime();
        }
        catch (REBException e) {
            throw new RaftException(e.getMessage());
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the contents of REB registers")
    public RegisterData getRegister(@Argument(description="Address of the first register") int address, @Argument(description="Number of registers to read") int count) throws RaftException {
        int[] values = new int[count];
        try {
            this.bss.read(address, values);
        }
        catch (REBException e) {
            throw new RaftException(e.getMessage());
        }
        return new RegisterData(address, count, values);
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the contents of REB registers")
    public void setRegister(@Argument(description="Address of the first register") int address, @Argument(description="Values to write") int[] values) throws RaftException {
        try {
            this.bss.write(address, values);
        }
        catch (REBException e) {
            throw new RaftException(e.getMessage());
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the REB status block")
    public StatusData getRebStatus() throws RaftException {
        try {
            return new StatusData(this.sts.readStatus());
        }
        catch (REBException e) {
            return null;
        }
    }

    BoardDacs getBoardDacs() {
        return this.dac;
    }

    Aspic getAspic() {
        return this.asp;
    }

    public ImageProc getImageProc() {
        return this.img;
    }

    public SequencerProc getSequencer() {
        return this.sqp;
    }

    double getTempValue(int hwChan) {
        return this.online ? this.tempValues[hwChan] : 0.0;
    }

    double getPowerValue(int hwChan) {
        return this.online ? this.powerValues[hwChan] : 0.0;
    }

    public double getMaxDelta() {
        return this.maxDelta;
    }

    public double getMaxStep() {
        return this.maxStep;
    }

    public double getMinTol() {
        return this.minTol;
    }

    @Command(simulation=true)
    public void simulateDisconnection() {
        this.setOnline(false);
    }

    private void checkErrorCount(String excpnText) {
        if (++this.errorCount > 4) {
            this.exceptionText = excpnText;
            this.exceptionCount = 1;
            this.setOnline(false);
        }
    }

    private void logExceptionCount() {
        if (this.exceptionCount > 1) {
            LOG.log(Level.INFO, "Previous {0} exception occurred {1} times", new Object[]{this.name, this.exceptionCount});
        }
    }

    protected void setOnline(boolean online) {
        super.setOnline(online);
        if (this.isOnline()) {
            this.stateService.updateAgentComponentState((Object)this, new Enum[]{RebDeviceState.ONLINE});
        } else {
            this.stateService.updateAgentComponentState((Object)this, new Enum[]{RebDeviceState.OFFLINE, RebValidationState.UNKNOWN, HVBiasState.UNKNOWN, CCDsPowerState.UNKNOWN});
        }
    }

    boolean isITLManufacturedCCD() {
        return "itl".equalsIgnoreCase(this.getCcdType().getManufacturer());
    }

    private void forceDataPublicationForNextUpdateIterations(int count) {
        for (MonitorUpdateTask task : this.tasksForDevice) {
            task.forceDataPublicationOnNextUpdates(count);
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Show list of monitor-update task names")
    public String getMonitorTasks() {
        return this.getMonitorTasksAsString();
    }

    private String getMonitorTasksAsString() {
        StringBuilder result = new StringBuilder();
        for (MonitorUpdateTask task : this.tasksForDevice) {
            result.append(task.getName() + " ");
        }
        return result.toString();
    }

    @Command(type=Command.CommandType.QUERY, description="Pause \"all\" or selected monitoring tasks")
    public void pauseMonitorTasks(String ... taskNames) {
        HashSet<MonitorUpdateTask> tasksToPause = new HashSet<MonitorUpdateTask>();
        for (MonitorUpdateTask task : this.tasksForDevice) {
            for (String name : taskNames) {
                if (!name.equals("all") && !name.equals(task.getName())) continue;
                tasksToPause.add(task);
            }
        }
        for (MonitorUpdateTask task : tasksToPause) {
            task.pausePeriodicUpdate();
            LOG.log(Level.FINE, "monitor-update pausing task " + task.getName());
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Resume \"all\" or selected monitoring tasks")
    public void resumeMonitorTasks(String ... taskNames) {
        HashSet<MonitorUpdateTask> tasksToResume = new HashSet<MonitorUpdateTask>();
        for (MonitorUpdateTask task : this.tasksForDevice) {
            for (String name : taskNames) {
                if (!name.equals("all") && !name.equals(task.getName())) continue;
                tasksToResume.add(task);
            }
        }
        for (MonitorUpdateTask task : tasksToResume) {
            task.resumePeriodicUpdate();
            LOG.log(Level.FINE, "monitor-update resuming task " + task.getName());
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Trigger \"all\" or selected monitoring tasks")
    public void triggerMonitorTasks(String ... taskNames) {
        HashSet<MonitorUpdateTask> tasksToTrigger = new HashSet<MonitorUpdateTask>();
        for (MonitorUpdateTask task : this.tasksForDevice) {
            for (String name : taskNames) {
                if (!name.equals("all") && !name.equals(task.getName())) continue;
                tasksToTrigger.add(task);
            }
        }
        for (MonitorUpdateTask task : tasksToTrigger) {
            task.scheduleUpdateAndPublishNow();
            LOG.log(Level.FINE, "monitor-update triggered task " + task.getName());
        }
    }

    static {
        hdwTypeMap.put("DAQ", 6);
        hdwTypeMap.put("DAQ0", 0);
        hdwTypeMap.put("DAQ1", 1);
        hdwTypeMap.put("DAQ2", 2);
        hdwTypeMap.put("DAQ4", 5);
        hdwTypeMap.put("PCI", 4);
        hdwTypeMap.put("PCI0", 3);
        hdwTypeMap.put("PCI1", 4);
        typeMap = new HashMap<String, Integer>();
        typeMap.put("TEMP", 0);
        typeMap.put("POWER", 1);
        typeMap.put("RTD", 2);
        typeMap.put("ATEMP", 3);
        typeMap.put("BIAS", 4);
        typeMap.put("CURR", 5);
        typeMap.put("CRVOLT", 6);
        typeMap.put("HEATER", 7);
        typeMap.put("HVSWCH", 8);
        adcChans = new int[18];
        REBDevice.adcChans[0] = 26;
        REBDevice.adcChans[1] = 27;
        REBDevice.adcChans[2] = 20;
        REBDevice.adcChans[3] = 21;
        REBDevice.adcChans[4] = 22;
        REBDevice.adcChans[5] = 23;
        REBDevice.adcChans[6] = 3;
        REBDevice.adcChans[7] = 0;
        REBDevice.adcChans[9] = 2;
        REBDevice.adcChans[8] = 1;
        REBDevice.adcChans[10] = 7;
        REBDevice.adcChans[11] = 4;
        REBDevice.adcChans[13] = 6;
        REBDevice.adcChans[12] = 5;
        REBDevice.adcChans[14] = 11;
        REBDevice.adcChans[15] = 8;
        REBDevice.adcChans[17] = 10;
        REBDevice.adcChans[16] = 9;
        adcNames = new String[18];
        REBDevice.adcNames[0] = "PclkLow";
        REBDevice.adcNames[1] = "PclkHigh";
        REBDevice.adcNames[2] = "SclkLow";
        REBDevice.adcNames[3] = "SclkHigh";
        REBDevice.adcNames[4] = "RGLow";
        REBDevice.adcNames[5] = "RGHigh";
        REBDevice.adcNames[6] = "GD0";
        REBDevice.adcNames[7] = "OD0";
        REBDevice.adcNames[8] = "OG0";
        REBDevice.adcNames[9] = "RD0";
        REBDevice.adcNames[10] = "GD1";
        REBDevice.adcNames[11] = "OD1";
        REBDevice.adcNames[12] = "OG1";
        REBDevice.adcNames[13] = "RD1";
        REBDevice.adcNames[14] = "GD2";
        REBDevice.adcNames[15] = "OD2";
        REBDevice.adcNames[16] = "OG2";
        REBDevice.adcNames[17] = "RD2";
        hwChanToAdcs = new HashMap<Integer, Integer>();
        hwChanToAdcs.put(26, 0);
        hwChanToAdcs.put(27, 1);
        hwChanToAdcs.put(20, 2);
        hwChanToAdcs.put(21, 3);
        hwChanToAdcs.put(22, 4);
        hwChanToAdcs.put(23, 5);
        hwChanToAdcs.put(3, 6);
        hwChanToAdcs.put(0, 7);
        hwChanToAdcs.put(2, 9);
        hwChanToAdcs.put(1, 8);
        hwChanToAdcs.put(7, 10);
        hwChanToAdcs.put(4, 11);
        hwChanToAdcs.put(6, 13);
        hwChanToAdcs.put(5, 12);
        hwChanToAdcs.put(11, 14);
        hwChanToAdcs.put(8, 15);
        hwChanToAdcs.put(10, 17);
        hwChanToAdcs.put(9, 16);
        LOG = Logger.getLogger(REBDevice.class.getName());
        rsetNames = new HashMap<String, Integer>();
        rsetNames.put("stat", 0);
        rsetNames.put("time", 1);
        rsetNames.put("seq", 2);
        rsetNames.put("tadc", 4);
        rsetNames.put("padc", 3);
    }

    private static enum ChannelGroup {
        rebTemp,
        aspicTemp,
        boardPower,
        crVolt,
        biasVolt,
        ccdCurrent;

    }

    public static class AdcData {
        static final int TYPE_POWER = 0;
        static final int TYPE_SLOW = 1;
        final int type;
        final int hwChan;
        final double value;
        final CCSTimeStamp timeStamp;

        public AdcData(int type, int hwChan, double value, CCSTimeStamp timeStamp) {
            this.type = type;
            this.hwChan = hwChan;
            this.value = value;
            this.timeStamp = timeStamp == null ? CCSTimeStamp.currentTime() : timeStamp;
        }
    }
}

