/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.SequencerUtils;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.subsystem.rafts.data.SequencerData;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2Model;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2ModelBuilder;

public class SequencerProc {
    private final BaseSet bss;
    private final SequencerUtils seq;
    private int zeroReg;
    private FPGA2Model fpgaModel;

    public SequencerProc(BaseSet bss) {
        this.bss = bss;
        this.seq = new SequencerUtils(bss);
    }

    public int loadSequencer(String fileName) throws REBException, IOException {
        FPGA2Model model = new FPGA2ModelBuilder().compileFile(new File(fileName));
        return this.loadSequencer(model);
    }

    public int loadSequencer(InputStream in) throws IOException, REBException {
        FPGA2Model model = new FPGA2ModelBuilder().compileFile(in);
        return this.loadSequencer(model);
    }

    public int loadSequencer(FPGA2Model model) throws REBException {
        if (this.isRunning()) {
            throw new REBException("Sequencer is Enabled, can't load while running");
        }
        this.fpgaModel = model;
        this.seq.clearCache();
        for (int j = 0; j < 1024; j += 16) {
            this.bss.write(0x300000 + j + 15, 0);
        }
        for (int[] command : model.getCommands()) {
            switch (command[0]) {
                case 0: {
                    int lines = 0;
                    for (int j = 3; j < command.length; ++j) {
                        lines |= 1 << command[j];
                    }
                    this.seq.writeLines(command[1], command[2], lines);
                    break;
                }
                case 1: {
                    this.seq.writeTimes(command[1], command[2], command[3]);
                    break;
                }
                case 2: {
                    this.seq.writeProgExec(command[1], command[2], command[3]);
                    break;
                }
                case 6: {
                    this.seq.writeProgExec(command[1], 1, command[2], command[3]);
                    break;
                }
                case 7: {
                    this.seq.writeProgExec(command[1], 2, command[2], command[3]);
                    break;
                }
                case 8: {
                    this.seq.writeProgExec(command[1], 3, command[2], command[3]);
                    break;
                }
                case 3: {
                    this.seq.writeProgJump(command[1], command[2], command[3]);
                    break;
                }
                case 9: {
                    this.seq.writeProgJump(command[1], 1, command[2], command[3]);
                    break;
                }
                case 10: {
                    this.seq.writeProgJump(command[1], 2, command[2], command[3]);
                    break;
                }
                case 11: {
                    this.seq.writeProgJump(command[1], 3, command[2], command[3]);
                    break;
                }
                case 12: {
                    this.seq.writeExecFunc(command[1], command[2]);
                    break;
                }
                case 13: {
                    this.seq.writeExecCount(command[1], command[2]);
                    break;
                }
                case 14: {
                    this.seq.writeJumpSubr(command[1], command[2]);
                    break;
                }
                case 15: {
                    this.seq.writeJumpCount(command[1], command[2]);
                    break;
                }
                case 4: {
                    this.seq.writeProgEndSubr(command[1]);
                    break;
                }
                case 5: {
                    this.seq.writeProgEnd(command[1]);
                    break;
                }
            }
        }
        int nSlice = this.seq.getCacheSliceCount();
        int version = this.seq.getVersion();
        if (version == 3) {
            this.seq.writeStartAddr(0);
        } else if (version == 0) {
            this.seq.writeSliceCount(nSlice);
        }
        this.zeroReg = 0;
        for (int j = 0; j < 1024; j += 16) {
            if (this.bss.read(0x300000 + j + 15) != 0) continue;
            this.zeroReg = 0x300000 + j + 15;
        }
        return nSlice;
    }

    @Deprecated
    int loadSequencerFromBootstrapOrFile(String fileName) throws IOException, REBException {
        FPGA2Model model;
        if (fileName.startsWith("/")) {
            model = new FPGA2ModelBuilder().compileFile(new File(fileName));
        } else {
            InputStream sequencerFileInputStream = BootstrapResourceUtils.getBootstrapResource((String)fileName);
            model = new FPGA2ModelBuilder().compileFile(sequencerFileInputStream);
        }
        return this.loadSequencer(model);
    }

    public List<String> getMains() {
        return new ArrayList<String>(this.fpgaModel.getMainAddresses().keySet());
    }

    public Map<String, Integer> getMainMap() {
        return this.fpgaModel.getMainAddresses();
    }

    public Map<String, Integer> getSubroutineMap() {
        return this.fpgaModel.getSubroutineAddresses();
    }

    public Map<String, Integer> getFunctionMap() {
        return this.fpgaModel.getFunctionAddresses();
    }

    public Map<String, FPGA2Model.PointerInfo> getPointers() {
        return this.fpgaModel.getPointerMap();
    }

    public int[] getImageRegisters() {
        try {
            return this.getImageRegisters(SequencerData.imageRegNames, false);
        }
        catch (RaftException ex) {
            throw new RuntimeException("Inconceivable!", ex);
        }
    }

    public int[] getImageRegisters(String[] names, boolean strict) throws RaftException {
        int[] registers = new int[names.length];
        Map pointerMap = this.fpgaModel.getPointerMap();
        int k = 0;
        for (String name : names) {
            int addr = this.zeroReg;
            FPGA2Model.PointerInfo pi = (FPGA2Model.PointerInfo)pointerMap.get(name);
            if (pi != null) {
                if (pi.getKind() == FPGA2Model.PointerInfo.PointerKind.REPEAT_FUNCTION) {
                    addr = pi.getAddress();
                } else if (pi.getKind() == FPGA2Model.PointerInfo.PointerKind.REPEAT_SUBROUTINE) {
                    addr = pi.getAddress();
                } else if (strict) {
                    throw new RaftException("Parameter: " + name + " is of unsupported type " + pi.getKind());
                }
            } else if (strict) {
                throw new RaftException("Required parameter not defined " + name);
            }
            registers[k++] = addr;
        }
        return registers;
    }

    public int setStart(String mainName) throws REBException, RaftException {
        Integer addr = (Integer)this.fpgaModel.getMainAddresses().get(mainName);
        if (addr != null) {
            this.seq.writeStartAddr(addr.intValue());
            return this.seq.getCacheSliceCount();
        }
        throw new RaftException("Unknown main program name: " + mainName);
    }

    public int setStart(int address) throws REBException {
        this.seq.writeStartAddr(address);
        return this.seq.getCacheSliceCount();
    }

    public void setParameter(String parmName, int value) throws REBException, RaftException {
        FPGA2Model.PointerInfo pi = (FPGA2Model.PointerInfo)this.fpgaModel.getPointerMap().get(parmName);
        if (pi != null) {
            switch (pi.getKind()) {
                case FUNCTION: {
                    this.seq.writeExecFunc(pi.getOffset(), value);
                    break;
                }
                case REPEAT_FUNCTION: {
                    this.seq.writeExecCount(pi.getOffset(), value);
                    break;
                }
                case SUBROUTINE: {
                    this.seq.writeJumpSubr(pi.getOffset(), value);
                    break;
                }
                case REPEAT_SUBROUTINE: {
                    this.seq.writeJumpCount(pi.getOffset(), value);
                }
            }
            return;
        }
        throw new RaftException("Unknown parameter name: " + parmName);
    }

    public int getParameter(String parmName) throws REBException, RaftException {
        FPGA2Model.PointerInfo pi = (FPGA2Model.PointerInfo)this.fpgaModel.getPointerMap().get(parmName);
        if (pi != null) {
            int value = 0;
            switch (pi.getKind()) {
                case FUNCTION: {
                    value = this.seq.readExecFunc(pi.getOffset());
                    break;
                }
                case REPEAT_FUNCTION: {
                    value = this.seq.readExecCount(pi.getOffset());
                    break;
                }
                case SUBROUTINE: {
                    value = this.seq.readJumpSubr(pi.getOffset());
                    break;
                }
                case REPEAT_SUBROUTINE: {
                    value = this.seq.readJumpCount(pi.getOffset());
                }
            }
            return value;
        }
        throw new RaftException("Unknown parameter name: " + parmName);
    }

    public void setCcdMask(int ccdMask) throws REBException {
        this.seq.writeStripeSelect(ccdMask);
    }

    public int getDataSource() throws REBException {
        return this.seq.readDataSource();
    }

    public void setDataSource(int value) throws REBException {
        this.seq.writeDataSource(value);
    }

    public boolean isScanEnabled() throws REBException {
        return this.seq.isScanEnabled();
    }

    public void enableScan(boolean value) throws REBException {
        this.seq.enableScan(value);
    }

    public void resetScan() throws REBException {
        this.seq.resetScan();
    }

    public int getErrorAddr() throws REBException {
        return this.seq.getErrorAddr();
    }

    public void resetError() throws REBException {
        this.seq.resetError();
    }

    public void startSequencer() throws REBException {
        this.resetError();
        this.seq.enable();
    }

    public void sendStop() throws REBException {
        this.seq.sendStop();
    }

    public void sendStep() throws REBException {
        this.seq.sendStep();
    }

    public boolean isRunning() throws REBException {
        return this.seq.isEnabled();
    }

    public void waitDone(int timeout) throws REBException {
        this.seq.waitDone(timeout);
    }
}

