/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.config.BulkValidationException;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.reb.BoardDacs;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.monitor.Control;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.config.BiasDACS;
import org.lsst.ccs.subsystem.rafts.data.RaftException;

public class BiasControl
extends Control
implements ConfigurationBulkChangeHandler {
    public static final String GD_P = "gdP";
    public static final String OD_P = "odP";
    public static final String OG_P = "ogP";
    public static final String RD_P = "rdP";
    public static final String CS_GATE_P = "csGateP";
    public static final String GD = "gd";
    public static final String OD = "od";
    public static final String OG = "og";
    public static final String OG_SH = "ogSh";
    public static final String RD = "rd";
    public static final String CS_GATE = "csGate";
    private static final int GD_CH = 1;
    private static final int OD_CH = 2;
    private static final int OG_CH = 4;
    private static final int OG_SH_CH = 8;
    private static final int RD_CH = 16;
    private static final int CSGATE_CH = 32;
    private static final String[] checkList = new String[]{"gd", "od", "og", "rd"};
    private static final int[] OD_ADCS = new int[]{7, 11, 15};
    private static final int[] GD_ADCS = new int[]{6, 10, 14};
    private static final int[] RD_ADCS = new int[]{9, 13, 17};
    private static final int[] OG_ADCS = new int[]{8, 12, 16};
    private static final double DAC_TOLERANCE = 0.33;
    private static final int DEFAULT_LOAD_WAIT = 160;
    private static final int DEFAULT_CLEAR_WAIT = 50;
    private static final int SLOW_ADCS_DELTA = 6;
    private static final int SLOW_ADCS_SAMPLE_DELAY = 34;
    private static final double TEST_VOLTS = 0.5;
    private static final double ZERO_ERROR = 0.2;
    private static final double VALUE_ERROR = 0.2;
    private static final double OD_SHORTS_LIMIT = 0.005;
    private static final double CLKH_SHORTS_LIMIT = 0.005;
    private static final double CLKL_SHORTS_LIMIT = 0.005;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService sce;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    private REBDevice rebDevc;
    @LookupPath
    String biasPath;
    @ConfigurationParameter(category="Rafts", description="Guard diode", range="14.5..27.0", units="volts")
    private volatile double gdP;
    @ConfigurationParameter(category="Rafts", description="Output drain", range="20.0..28.0", units="volts")
    private volatile double odP;
    @ConfigurationParameter(category="Rafts", description="Output gate", range="-3.0..3.0", units="volts")
    private volatile double ogP;
    @ConfigurationParameter(category="Rafts", description="Reset drain", range="11.0..15.0", units="volts")
    private volatile double rdP;
    @ConfigurationParameter(category="Rafts", description="Current source", units="mA")
    private volatile double csGateP;
    @ConfigurationParameter(category="RaftsLimits", description="Guard diode min", units="volts")
    private volatile double gdMin;
    @ConfigurationParameter(category="RaftsLimits", description="Guard diode max", units="volts")
    private volatile double gdMax;
    @ConfigurationParameter(category="RaftsLimits", description="Output drain min", units="volts")
    private volatile double odMin;
    @ConfigurationParameter(category="RaftsLimits", description="Output drain max", units="volts")
    private volatile double odMax;
    @ConfigurationParameter(category="RaftsLimits", description="Output gate min", units="volts")
    private volatile double ogMin;
    @ConfigurationParameter(category="RaftsLimits", description="Output gate max", units="volts")
    private volatile double ogMax;
    @ConfigurationParameter(category="RaftsLimits", description="Reset drain min", units="volts")
    private volatile double rdMin;
    @ConfigurationParameter(category="RaftsLimits", description="Reset drain max", units="volts")
    private volatile double rdMax;
    @ConfigurationParameter(category="Rafts", description="Guard diode", units="DAC counts")
    private volatile int gd;
    @ConfigurationParameter(category="Rafts", description="Output drain", units="DAC counts")
    private volatile int od;
    @ConfigurationParameter(category="Rafts", description="Output gate", units="DAC counts")
    private volatile int og;
    @ConfigurationParameter(category="Rafts", description="Output gate shifted", units="DAC counts")
    private volatile int ogSh;
    @ConfigurationParameter(category="Rafts", description="Reset drain", units="DAC counts")
    private volatile int rd;
    @ConfigurationParameter(category="Rafts", description="Current source", units="DAC counts")
    private volatile int csGate;
    @ConfigurationParameter(category="RaftsPower", range="0.05..0.7", description="Guard diode tolerance", units="volts")
    private volatile double gdTol;
    @ConfigurationParameter(category="RaftsPower", range="0.95..1.05", description="GD convert factor", units="none")
    private volatile double gdCal;
    @ConfigurationParameter(category="RaftsPower", range="0.05..0.7", description="Output drain tolerance", units="volts")
    private volatile double odTol;
    @ConfigurationParameter(category="RaftsPower", range="0.95..1.05", description="OD convert factor", units="none")
    private volatile double odCal;
    @ConfigurationParameter(category="RaftsPower", range="0.05..0.7", description="Output gate tolerance", units="volts")
    private volatile double ogTol;
    @ConfigurationParameter(category="RaftsPower", range="0.90..1.10", description="OG convert factor", units="none")
    private volatile double ogCal;
    @ConfigurationParameter(category="RaftsPower", range="0.05..0.7", description="Reset drain tolerance", units="volts")
    private volatile double rdTol;
    @ConfigurationParameter(category="RaftsPower", range="0.95..1.05", description="RD convert factor", units="none")
    private volatile double rdCal;
    @ConfigurationParameter(category="RaftsPower", description="Max ODI value", units="Amps")
    private volatile double odIMax;
    @ConfigurationParameter(category="RaftsPower", description="Shorts Test Voltage for GD", units="Volts")
    private volatile double gdTestVolts;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for GD at 0V", units="Volts")
    private volatile double gdZeroErr;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for GD at TestVolts", units="Volts")
    private volatile double gdValueErr;
    @ConfigurationParameter(category="RaftsPower", description="Shorts Test Voltage for OG", units="Volts")
    private volatile double ogTestVolts;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for OG at 0V", units="Volts")
    private volatile double ogZeroErr;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for OG at TestVolts", units="Volts")
    private volatile double ogValueErr;
    @ConfigurationParameter(category="RaftsPower", description="Shorts Test Voltage for RD", units="Volts")
    private volatile double rdTestVolts;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for RD at 0V", units="Volts")
    private volatile double rdZeroErr;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for RD at TestVolts", units="Volts")
    private volatile double rdValueErr;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for OD at 0V", units="Volts")
    private volatile double odZeroErr;
    private boolean raw = false;
    private static final Logger LOG = Logger.getLogger(BiasControl.class.getName());
    private boolean cfgValid;
    private int hwVersion;
    private BoardDacs dac;
    private int changed = 0;
    private final Map<String, Double> lowLimitMap = new HashMap<String, Double>();
    private final Map<String, Double> highLimitMap = new HashMap<String, Double>();
    private double gdConv;
    private double odConv;
    private double rdConv;
    private double ogConv;
    private double ogShiftConv;
    private double csConv;
    private double csOffset;
    private int adcType;
    private double gdDelta;
    private double odDelta;
    private double rdDelta;
    private double ogDelta;

    public BiasControl() {
        for (String pName : checkList) {
            this.lowLimitMap.put(pName, 0.0);
            this.highLimitMap.put(pName, 0.0);
        }
    }

    protected void configure(Monitor mon, Device devc) {
        super.configure(mon, devc);
        this.dac = this.rebDevc.getBoardDacs();
    }

    public boolean checkConfig() {
        int numStrips;
        this.hwVersion = BiasControl.getHwVersion(this.dac);
        if (this.hwVersion == -1) {
            LOG.log(Level.SEVERE, "{0} configuration incompatible with the firmware", this.getName());
            return false;
        }
        try {
            numStrips = this.dac.getNumStrips();
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error getting number of strips for {0}", this.getName());
            return false;
        }
        if (this.hwChan < 0 || this.hwChan >= numStrips) {
            LOG.log(Level.SEVERE, "{0} hwChan:{1} not in range: 0:{2}", new Object[]{this.biasPath, this.hwChan, numStrips});
            return false;
        }
        if (!this.raw) {
            switch (this.hwVersion) {
                case 1: {
                    this.gdConv = this.odConv = 136.7278797996661;
                    this.rdConv = this.odConv;
                    break;
                }
                case 2: {
                    this.odConv = 112.769123783032;
                    this.gdConv = 113.75;
                    this.rdConv = 163.14741035856574;
                    break;
                }
                default: {
                    this.gdConv = this.odConv = 113.75;
                    this.rdConv = 163.14741035856574;
                }
            }
            double ogGain = 1.0;
            double fudge = this.hwVersion == 3 ? 1.0 : 1.1;
            this.ogShiftConv = fudge * 819.0 / ogGain;
            this.ogConv = fudge * 819.0 / (1.0 + ogGain);
            this.csConv = 1638.0;
            this.csOffset = -0.95;
        } else {
            this.cfgValid = true;
        }
        this.adcType = this.hwVersion == 2 ? 4 : 6;
        this.changed = 0;
        return true;
    }

    public boolean isRaw() {
        return this.raw;
    }

    public static int getHwVersion(BoardDacs dac) {
        int version = dac.getVersion();
        switch (version) {
            case 2: 
            case 4: 
            case 5: {
                version = 1;
                break;
            }
            case 3: 
            case 6: {
                version = 2;
                break;
            }
            case 7: 
            case 8: {
                version = 3;
                break;
            }
            default: {
                version = -1;
            }
        }
        return version;
    }

    @Deprecated
    public int getHwVersion() {
        return this.hwVersion;
    }

    public void validateBulkChange(Map<String, Object> params) throws IllegalArgumentException {
        String errMsg = null;
        if (!this.raw) {
            for (String pName : checkList) {
                Double max;
                double value = (Double)params.get(pName + "P");
                if (value > (max = (Double)params.get(pName + "Max"))) {
                    errMsg = String.format("%s: %sP (%5.5g) is above high limit (%5.5g)", this.getName(), pName, value, max);
                    break;
                }
                Double min = (Double)params.get(pName + "Min");
                if (!(value < min)) continue;
                errMsg = String.format("%s: %sP (%5.5g) is below low limit (%5.5g)", this.getName(), pName, value, min);
                break;
            }
        }
        if (errMsg != null) {
            LOG.log(Level.SEVERE, "Configuration failure: {0}", errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        this.cfgValid = true;
    }

    public void setParameterBulk(Map<String, Object> params) throws IllegalArgumentException {
        StringBuilder changedString = new StringBuilder();
        Pattern changedPattern = Pattern.compile("(rd|od|gd|og)(P|Cal|Tol)|csGateP");
        if (!this.raw) {
            int matchCount = 0;
            for (String param : params.keySet()) {
                Matcher m = changedPattern.matcher(param);
                if (!m.matches()) continue;
                if (param.startsWith(GD)) {
                    this.changed |= 1;
                } else if (param.startsWith(OD)) {
                    this.changed |= 2;
                } else if (param.startsWith(OG)) {
                    this.changed |= 4;
                    this.changed |= 8;
                } else if (param.startsWith(RD)) {
                    this.changed |= 0x10;
                } else if (param.equals(CS_GATE_P)) {
                    this.changed |= 0x20;
                } else {
                    LOG.log(Level.WARNING, "Programmer error: Unexpected parameter change match: " + param);
                }
                changedString.append(" " + param);
                ++matchCount;
            }
            if (matchCount > 0) {
                this.rebDevc.setUpdateCCDsPowerState();
            }
            LOG.log(Level.INFO, this.biasPath + ": " + matchCount + " parameters changed:" + changedString);
            LOG.log(Level.FINE, String.format("%s: changed = 0x%x", this.biasPath, this.changed));
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the changed variable value")
    public String getChanged() {
        return String.format("0x%x", this.changed);
    }

    @ConfigurationParameterChanger
    public void setGdP(double value) {
        this.gdP = value;
        this.changed |= 1;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the Guard Diode voltage")
    public double getGdP() {
        return this.gdP;
    }

    @ConfigurationParameterChanger
    public void setGdMax(double value) {
        this.gdMax = value;
        this.highLimitMap.put(GD, value);
    }

    @ConfigurationParameterChanger
    public void setGdMin(double value) {
        this.gdMin = value;
        this.lowLimitMap.put(GD, value);
    }

    @ConfigurationParameterChanger
    public void setGd(int value) {
        this.gd = value;
        this.changed |= 1;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the Guard Diode DAC value")
    public int getGd() {
        return this.gd;
    }

    @ConfigurationParameterChanger
    public void setOdP(double value) {
        this.odP = value;
        this.changed |= 2;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the readout mode Output Drain voltage")
    public double getOdP() {
        return this.odP;
    }

    @ConfigurationParameterChanger
    public void setOdMax(double value) {
        this.odMax = value;
        this.highLimitMap.put(OD, value);
    }

    @ConfigurationParameterChanger
    public void setOdMin(double value) {
        this.odMin = value;
        this.lowLimitMap.put(OD, value);
    }

    @ConfigurationParameterChanger
    public void setOd(int value) {
        this.od = value;
        this.changed |= 2;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the readout mode Output Drain DAC value")
    public int getOd() {
        return this.od;
    }

    @ConfigurationParameterChanger
    public void setOgP(double value) {
        this.ogP = value;
        this.changed |= 4;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the Output Gate voltage")
    public double getOgP() {
        return this.ogP;
    }

    @ConfigurationParameterChanger
    public void setOgMax(double value) {
        this.ogMax = value;
        this.highLimitMap.put(OG, value);
    }

    @ConfigurationParameterChanger
    public void setOgMin(double value) {
        this.ogMin = value;
        this.lowLimitMap.put(OG, value);
    }

    @ConfigurationParameterChanger
    public void setOg(int value) {
        this.og = value;
        this.changed |= 4;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the Output Gate DAC value")
    public int getOg() {
        return this.og;
    }

    @ConfigurationParameterChanger
    public void setOgSh(int value) {
        this.ogSh = value;
        this.changed |= 8;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the Output Gate shift DAC value")
    public int getOgSh() {
        return this.ogSh;
    }

    @ConfigurationParameterChanger
    public void setRdP(double value) {
        this.rdP = value;
        this.changed |= 0x10;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the Reset Drain voltage")
    public double getRdP() {
        return this.rdP;
    }

    @ConfigurationParameterChanger
    public void setRdMax(double value) {
        this.rdMax = value;
        this.highLimitMap.put(RD, value);
    }

    @ConfigurationParameterChanger
    public void setRdMin(double value) {
        this.rdMin = value;
        this.lowLimitMap.put(RD, value);
    }

    @ConfigurationParameterChanger
    public void setRd(int value) {
        this.rd = value;
        this.changed |= 0x10;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the Reset Drain DAC value")
    public int getRd() {
        return this.rd;
    }

    @ConfigurationParameterChanger
    public void setCsGateP(double value) {
        this.csGateP = value;
        this.changed |= 0x20;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the Current Source gate")
    public double getCsGateP() {
        return this.csGateP;
    }

    @ConfigurationParameterChanger
    public void setCsGate(int value) {
        this.csGate = value;
        this.changed |= 0x20;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the Current Source gate")
    public int getCsGate() {
        return this.csGate;
    }

    @Deprecated
    void setConfig(BiasDACS bias) throws RaftException {
        String name = this.getName();
        if (!this.raw) {
            double[] values = bias.getPValues();
            this.sce.submitChange(name, GD_P, (Object)values[0]);
            this.sce.submitChange(name, OD_P, (Object)values[1]);
            this.sce.submitChange(name, OG_P, (Object)values[2]);
            this.sce.submitChange(name, RD_P, (Object)values[5]);
            this.sce.submitChange(name, CS_GATE_P, (Object)values[4]);
        } else {
            int[] values = bias.getValues();
            this.sce.submitChange(name, GD, (Object)values[0]);
            this.sce.submitChange(name, OD, (Object)values[1]);
            this.sce.submitChange(name, OG, (Object)values[2]);
            this.sce.submitChange(name, OG_SH, (Object)values[3]);
            this.sce.submitChange(name, RD, (Object)values[5]);
            this.sce.submitChange(name, CS_GATE, (Object)values[4]);
        }
        try {
            this.sce.commitBulkChange();
        }
        catch (BulkValidationException e) {
            this.sce.dropSubmittedChangesForComponent(name);
            throw new RaftException("Bulk configuration validation failed");
        }
    }

    BiasDACS getConfig() {
        BiasDACS bias = new BiasDACS();
        if (!this.raw) {
            double[] values = bias.getPValues();
            values[0] = this.gdP;
            values[1] = this.odP;
            values[2] = this.ogP;
            values[5] = this.rdP;
            values[4] = this.csGateP;
        } else {
            int[] values = bias.getValues();
            values[0] = this.gd;
            values[1] = this.od;
            values[2] = this.og;
            values[3] = this.ogSh;
            values[5] = this.rd;
            values[4] = this.csGate;
        }
        return bias;
    }

    int load(int wait, boolean check, boolean powerOn, List<REBDevice.AdcData> dataList) throws RaftException {
        if (!this.cfgValid) {
            throw new RaftException("DAC load error: invalid configuration");
        }
        if (!this.rebDevc.isSerialNumValid()) {
            throw new RaftException("DAC load error: invalid REB serial number");
        }
        this.rebDevc.readAllAdcs(dataList);
        if (this.isITLManufacturedCCD()) {
            this.loadOg(wait, check, powerOn, dataList);
            this.loadGd(wait, check, powerOn, dataList);
            this.loadRd(wait, check, powerOn, dataList);
            this.loadOd(wait, check, powerOn, dataList);
        } else {
            this.loadRd(wait, check, powerOn, dataList);
            this.loadOd(wait, check, powerOn, dataList);
            this.loadGd(wait, check, powerOn, dataList);
            this.loadOg(wait, check, powerOn, dataList);
        }
        this.loadCsGate(0);
        this.changed = 0;
        return 6;
    }

    int loadChanged(int wait, boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        if (!this.cfgValid) {
            throw new RaftException("DAC load error: invalid configuration");
        }
        if (!this.rebDevc.isSerialNumValid()) {
            throw new RaftException("DAC load error: invalid REB serial number");
        }
        int count = 0;
        this.rebDevc.readAllAdcs(dataList);
        if (this.isITLManufacturedCCD()) {
            if ((this.changed & 4) != 0) {
                this.loadOg(wait, check, false, dataList);
                count += 2;
            }
            if ((this.changed & 1) != 0) {
                this.loadGd(wait, check, false, dataList);
                ++count;
            }
            if ((this.changed & 0x10) != 0) {
                this.loadRd(wait, check, false, dataList);
                ++count;
            }
            if ((this.changed & 2) != 0) {
                this.loadOd(wait, check, false, dataList);
                ++count;
            }
        } else {
            if ((this.changed & 0x10) != 0) {
                this.loadRd(wait, check, false, dataList);
                ++count;
            }
            if ((this.changed & 2) != 0) {
                this.loadOd(wait, check, false, dataList);
                ++count;
            }
            if ((this.changed & 1) != 0) {
                this.loadGd(wait, check, false, dataList);
                ++count;
            }
            if ((this.changed & 4) != 0) {
                this.loadOg(wait, check, false, dataList);
                count += 2;
            }
        }
        if ((this.changed & 0x20) != 0) {
            this.loadCsGate(0);
            ++count;
        }
        this.changed = 0;
        return count;
    }

    void clear() throws RaftException {
        this.clear(50);
    }

    void clear(int wait) throws RaftException {
        this.clearCsGate(0);
        if (this.isITLManufacturedCCD()) {
            this.clearOd(wait);
            this.clearRd(wait);
            this.clearGd(wait);
            this.clearOg(wait);
        } else {
            this.clearOg(wait);
            this.clearGd(wait);
            this.clearOd(wait);
            this.clearRd(wait);
        }
        this.changed = -1;
    }

    public boolean testShorts(List<REBDevice.AdcData> dataList, List<String> tmsgList) throws RaftException {
        boolean failed = this.testShorts(14, this.rdConv, RD_ADCS[this.hwChan], this.rdTestVolts, this.rdValueErr, this.rdZeroErr, dataList, tmsgList);
        failed |= this.testShorts(13, this.gdConv, GD_ADCS[this.hwChan], this.gdTestVolts, this.gdValueErr, this.gdZeroErr, dataList, tmsgList);
        this.rebDevc.readAllAdcs(dataList);
        return failed |= this.testShorts(15, this.ogConv, OG_ADCS[this.hwChan], this.ogTestVolts, this.ogValueErr, this.ogZeroErr, dataList, tmsgList);
    }

    private boolean testShorts(int dac, double conv, int adc, double adcTestVolts, double adcValueErr, double adcZeroErr, List<REBDevice.AdcData> dataList, List<String> tmsgList) throws RaftException {
        boolean failed = false;
        double[] origPower = this.rebDevc.readPowerAdcs(dataList);
        double[] origAdcs = this.rebDevc.readSlowAdcs(dataList);
        this.setDac(dac, (int)(conv * adcTestVolts));
        this.loadDac(160, dataList);
        this.rebDevc.readAllAdcs(dataList);
        double[] curPower = this.rebDevc.readPowerAdcs(dataList);
        double[] currAdcs = this.rebDevc.readSlowAdcs(dataList);
        this.setDac(dac, 0);
        this.loadDac(50, dataList);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.rebDevc.readAllAdcs(dataList);
        for (int ad = 0; ad < currAdcs.length; ++ad) {
            double value = currAdcs[ad] - origAdcs[ad];
            if (ad == adc) {
                if (!(Math.abs(value - adcTestVolts) > adcValueErr)) continue;
                tmsgList.add(String.format("%s %s value (%.2f) is out of bounds %.2f (+/-%.2f)", this.biasPath, REBDevice.getAdcName(ad), value, adcTestVolts, adcValueErr));
                failed = true;
                continue;
            }
            if (!(Math.abs(value) > adcZeroErr)) continue;
            tmsgList.add(String.format("%s %s value (%.2f) is non-zero while testing %s", this.biasPath, REBDevice.getAdcName(ad), value, REBDevice.getAdcName(adc)));
            failed = true;
        }
        if (curPower[7] > origPower[7] + 0.005) {
            tmsgList.add(String.format("%s OD current increased excessively from %.1f mA to %.1f mA while testing %s", this.biasPath, 1000.0 * origPower[7], 1000.0 * curPower[7], REBDevice.getAdcName(adc)));
            failed = true;
        }
        if (curPower[5] > origPower[5] + 0.005) {
            tmsgList.add(String.format("%s CLKH current increased excessively from %.1f mA to %.1f mA while testing %s", this.biasPath, 1000.0 * origPower[5], 1000.0 * curPower[5], REBDevice.getAdcName(adc)));
            failed = true;
        }
        if (curPower[9] > origPower[9] + 0.005) {
            tmsgList.add(String.format("%s CLKL current increased excessively from %.1f mA to %.1f mA while testing %s", this.biasPath, 1000.0 * origPower[9], 1000.0 * curPower[9], REBDevice.getAdcName(adc)));
            failed = true;
        }
        return failed;
    }

    private void loadGd(int wait, boolean check, boolean powerOn, List<REBDevice.AdcData> dataList) throws RaftException {
        if (!this.raw) {
            this.setDac(13, (int)(this.gdConv * this.gdCal * this.gdP));
            this.loadDac(wait, dataList);
            try {
                this.checkAdc(GD_ADCS[this.hwChan], dataList, check, powerOn, this.gdP, this.gdTol);
            }
            catch (RaftException e) {
                if (powerOn) {
                    this.clearGd(0);
                }
                throw e;
            }
        } else {
            this.setDac(13, this.gd);
            this.loadDac(wait);
        }
    }

    private void loadOd(int wait, boolean check, boolean powerOn, List<REBDevice.AdcData> dataList) throws RaftException {
        if (!this.raw) {
            if (powerOn) {
                double odStepP = 15.0;
                if (this.odP > odStepP) {
                    this.setDac(12, (int)(this.odConv * this.odCal * odStepP));
                    this.loadDac(2 * wait / 3, dataList);
                    try {
                        this.checkAdc(OD_ADCS[this.hwChan], dataList, check, powerOn, odStepP, 2.0 * this.odTol);
                    }
                    catch (RaftException e) {
                        if (powerOn) {
                            this.clearOd(0);
                        }
                        throw e;
                    }
                } else {
                    throw new RaftException(String.format("odStepP (%.2f) > odP (%.2f), odP setting too low", odStepP, this.odP));
                }
            }
            this.setDac(12, (int)(this.odConv * this.odCal * this.odP));
            this.loadDac(powerOn ? wait / 3 : wait, dataList);
            try {
                this.checkAdc(OD_ADCS[this.hwChan], dataList, check, powerOn, this.odP, this.odTol);
            }
            catch (RaftException e) {
                if (powerOn) {
                    this.clearOd(0);
                }
                throw e;
            }
        } else {
            this.setDac(12, this.od);
            this.loadDac(wait);
        }
    }

    private void loadOg(int wait, boolean check, boolean powerOn, List<REBDevice.AdcData> dataList) throws RaftException {
        if (!this.raw) {
            this.setDac(15, this.ogP > 0.0 ? (int)(this.ogConv * this.ogCal * this.ogP) : 0);
            this.setDac(16, this.ogP < 0.0 ? (int)(-this.ogShiftConv * this.ogCal * this.ogP) : 0);
            this.loadDac(wait, dataList);
            try {
                this.checkAdc(OG_ADCS[this.hwChan], dataList, check, powerOn, this.ogP, this.ogTol);
            }
            catch (RaftException e) {
                if (powerOn) {
                    this.clearOg(0);
                }
                throw e;
            }
        } else {
            this.setDac(15, this.og);
            this.setDac(16, this.ogSh);
            this.loadDac(wait);
        }
    }

    private void loadRd(int wait, boolean check, boolean powerOn, List<REBDevice.AdcData> dataList) throws RaftException {
        if (!this.raw) {
            this.setDac(14, (int)(this.rdConv * this.rdCal * this.rdP));
            this.loadDac(wait, dataList);
            try {
                this.checkAdc(RD_ADCS[this.hwChan], dataList, check, powerOn, this.rdP, this.rdTol);
            }
            catch (RaftException e) {
                if (powerOn) {
                    this.clearRd(0);
                }
                throw e;
            }
        } else {
            this.setDac(14, this.rd);
            this.loadDac(wait);
        }
    }

    private void loadCsGate(int wait) throws RaftException {
        if (!this.raw) {
            this.setDac(17, (int)(this.csConv * (this.csGateP + this.csOffset)));
        } else {
            this.setDac(17, this.csGate);
        }
        this.loadDac(wait);
    }

    private void checkAdc(int adc, List<REBDevice.AdcData> dataList, boolean check, boolean powerOn, double setPoint, double adcTol) throws RaftException {
        StringBuilder exString = new StringBuilder();
        boolean failed = false;
        if (!check && dataList == null) {
            return;
        }
        double[] adcValues = this.rebDevc.readSlowAdcs(dataList);
        double[] curPower = this.rebDevc.readPowerAdcs(dataList);
        if (Math.abs(adcValues[adc] - setPoint) > adcTol) {
            exString.append(String.format("%s %s out of range: setpt=%.2f, reading: %.2f, tol: %.2f", this.biasPath, REBDevice.getAdcName(adc), setPoint, adcValues[adc], adcTol));
            failed = true;
        }
        if (powerOn) {
            if (curPower[7] > this.odIMax) {
                exString.append(String.format(",  %s %s Overcurrent measured on ODI: %.3f > %.3f (odIMax (A))", this.biasPath, REBDevice.getAdcName(adc), curPower[7], this.odIMax));
                failed = true;
            }
        } else {
            int rebType;
            double odIlimitHi = Double.parseDouble(this.sce.getConfigurationParameterValue(this.rebDevc.rebPath + "/ODI", "limitHi"));
            if (odIlimitHi < 80.0 - 30.0 * (double)(rebType = this.rebDevc.getRebType()) || odIlimitHi > 110.0) {
                exString.append(String.format("%s limitHi value: %.2f out of allowed range (%d..110)", this.rebDevc.rebPath + "/ODI", odIlimitHi, 80.0 - 30.0 * (double)rebType));
                failed = true;
            } else if (1000.0 * curPower[7] > odIlimitHi) {
                exString.append(String.format("%s %s Overcurrent measured on ODI (mA): %.3f > %.3f (ODI:limitHi)", this.biasPath, REBDevice.getAdcName(adc), 1000.0 * curPower[7], odIlimitHi));
                failed = true;
            }
        }
        if (failed) {
            LOG.log(Level.SEVERE, exString.toString());
            if (check) {
                throw new RaftException(exString.toString());
            }
        }
    }

    public int getBiasDacsPowerState(double[] slowAdcs, List<String> tmsgList) {
        double maxDelta = this.rebDevc.getMaxDelta();
        int offCnt = 0;
        int onCnt = 0;
        int lowCnt = 0;
        int dltaCnt = 0;
        int changes = 0;
        double value = slowAdcs[RD_ADCS[this.hwChan]];
        double delta = value - this.rdP;
        if (Math.abs(value) < this.rdZeroErr) {
            ++offCnt;
            tmsgList.add(String.format("%s %s voltage = %.2f in range for OFF", this.biasPath, REBDevice.getAdcName(RD_ADCS[this.hwChan]), value));
        } else if (Math.abs(delta) < this.rdTol) {
            ++onCnt;
            tmsgList.add(String.format("%s %s voltage = %.2f in range for ON", this.biasPath, REBDevice.getAdcName(RD_ADCS[this.hwChan]), value));
        } else if (Math.abs(delta) < maxDelta) {
            ++onCnt;
            ++dltaCnt;
            changes |= 0x10;
            tmsgList.add(String.format("%s %s voltage = %.2f in range for DELTA", this.biasPath, REBDevice.getAdcName(RD_ADCS[this.hwChan]), value));
        } else {
            tmsgList.add(String.format("%s %s voltage = %.2f NOT in range for ON|OFF", this.biasPath, REBDevice.getAdcName(RD_ADCS[this.hwChan]), value));
        }
        value = slowAdcs[OD_ADCS[this.hwChan]];
        delta = value - this.odP;
        if (Math.abs(value) < this.odZeroErr) {
            ++offCnt;
            tmsgList.add(String.format("%s %s voltage = %.2f in range for OFF", this.biasPath, REBDevice.getAdcName(OD_ADCS[this.hwChan]), value));
        } else if (Math.abs(delta) < this.odTol) {
            ++onCnt;
            tmsgList.add(String.format("%s %s voltage = %.2f in range for ON", this.biasPath, REBDevice.getAdcName(OD_ADCS[this.hwChan]), value));
        } else if (Math.abs(delta) < maxDelta) {
            ++onCnt;
            ++dltaCnt;
            changes |= 2;
            tmsgList.add(String.format("%s %s voltage = %.2f in range for DELTA", this.biasPath, REBDevice.getAdcName(OD_ADCS[this.hwChan]), value));
        } else {
            tmsgList.add(String.format("%s %s voltage = %.2f NOT in range for ON|OFF", this.biasPath, REBDevice.getAdcName(OD_ADCS[this.hwChan]), value));
        }
        value = slowAdcs[GD_ADCS[this.hwChan]];
        delta = value - this.gdP;
        if (Math.abs(value) < this.gdZeroErr) {
            ++offCnt;
            tmsgList.add(String.format("%s %s voltage = %.2f in range for OFF", this.biasPath, REBDevice.getAdcName(GD_ADCS[this.hwChan]), value));
        } else if (Math.abs(delta) < this.gdTol) {
            ++onCnt;
            tmsgList.add(String.format("%s %s voltage = %.2f in range for ON", this.biasPath, REBDevice.getAdcName(GD_ADCS[this.hwChan]), value));
        } else if (Math.abs(delta) < maxDelta) {
            ++onCnt;
            ++dltaCnt;
            changes |= 1;
            tmsgList.add(String.format("%s %s voltage = %.2f in range for DELTA", this.biasPath, REBDevice.getAdcName(GD_ADCS[this.hwChan]), value));
        } else {
            tmsgList.add(String.format("%s %s voltage = %.2f NOT in range for ON|OFF", this.biasPath, REBDevice.getAdcName(GD_ADCS[this.hwChan]), value));
        }
        lowCnt = 0;
        value = slowAdcs[OG_ADCS[this.hwChan]];
        delta = value - this.ogP;
        if (Math.abs(value) < this.ogZeroErr) {
            ++offCnt;
            ++lowCnt;
            tmsgList.add(String.format("%s %s voltage = %.2f in range for OFF", this.biasPath, REBDevice.getAdcName(OG_ADCS[this.hwChan]), value));
        }
        if (Math.abs(delta) < this.ogTol) {
            ++onCnt;
            ++lowCnt;
            tmsgList.add(String.format("%s %s voltage = %.2f in range for ON", this.biasPath, REBDevice.getAdcName(OG_ADCS[this.hwChan]), value));
        } else if (Math.abs(delta) < maxDelta) {
            ++onCnt;
            ++dltaCnt;
            ++lowCnt;
            changes |= 4;
            tmsgList.add(String.format("%s %s voltage = %.2f in range for DELTA", this.biasPath, REBDevice.getAdcName(OG_ADCS[this.hwChan]), value));
        }
        if (lowCnt == 0) {
            tmsgList.add(String.format("%s %s voltage = %.2f NOT in range for ON|OFF", this.biasPath, REBDevice.getAdcName(OG_ADCS[this.hwChan]), value));
        } else if (lowCnt == 2) {
            tmsgList.add(String.format("%s %s value %.2f is in both OFF and ON allowed range", this.biasPath, REBDevice.getAdcName(OG_ADCS[this.hwChan]), value));
        }
        tmsgList.add(String.format("%s: getBiasDacsPowerState() found %d(%d) ON(OFF) of biases", this.biasPath, onCnt, offCnt));
        if (offCnt == 4) {
            this.changed = -1;
            return 0;
        }
        if (onCnt == 4) {
            this.changed |= changes;
            return 1 + dltaCnt;
        }
        this.changed = -1;
        return -1;
    }

    public int setBiasDacsCalibration(double[] slowAdcs, List<String> tmsgList, boolean action) {
        int retval = 0;
        double minTol = this.rebDevc.getMinTol();
        double maxDelta = this.rebDevc.getMaxDelta();
        String formatStr0 = "%-8.8s %-8.8s %6.2f %6.2f  %6.3f --> %-6.3f  %8.3f --> %-8.3f  %5d --> %5d  %6.2f --> %-6.2f";
        String formatStr1 = "%-8.8s %-8.8s %6.2f %6.2f  %6.3f --> ERROR Delta larger than %5.3f max";
        double rdCalNew = this.rdCal;
        double rdTolNew = this.rdTol;
        double delta = this.rdP - slowAdcs[RD_ADCS[this.hwChan]];
        if (Math.abs(delta) < maxDelta) {
            rdCalNew = this.rdCal * Math.abs(this.rdP / slowAdcs[RD_ADCS[this.hwChan]]);
            rdTolNew = Math.abs(delta) / 4.0 > minTol ? Math.abs(delta) / 4.0 : minTol;
            tmsgList.add(String.format(formatStr0, this.biasPath, REBDevice.getAdcName(RD_ADCS[this.hwChan]), this.rdP, slowAdcs[RD_ADCS[this.hwChan]], this.rdCal, rdCalNew, this.rdTol, rdTolNew, (int)(this.rdConv * this.rdCal * this.rdP), (int)(this.rdConv * rdCalNew * this.rdP), this.rdConv * this.rdCal, this.rdConv * rdCalNew));
        } else {
            ++retval;
            tmsgList.add(String.format(formatStr1, this.biasPath, REBDevice.getAdcName(RD_ADCS[this.hwChan]), this.rdP, slowAdcs[RD_ADCS[this.hwChan]], this.rdCal, maxDelta));
        }
        double odCalNew = this.odCal;
        double odTolNew = this.odTol;
        delta = this.odP - slowAdcs[OD_ADCS[this.hwChan]];
        if (Math.abs(delta) < maxDelta) {
            odCalNew = this.odCal * Math.abs(this.odP / slowAdcs[OD_ADCS[this.hwChan]]);
            odTolNew = Math.abs(delta) / 4.0 > minTol ? Math.abs(delta) / 4.0 : minTol;
            tmsgList.add(String.format(formatStr0, this.biasPath, REBDevice.getAdcName(OD_ADCS[this.hwChan]), this.odP, slowAdcs[OD_ADCS[this.hwChan]], this.odCal, odCalNew, this.odTol, odTolNew, (int)(this.odConv * this.odCal * this.odP), (int)(this.odConv * odCalNew * this.odP), this.odConv * this.odCal, this.odConv * odCalNew));
        } else {
            ++retval;
            tmsgList.add(String.format(formatStr1, this.biasPath, REBDevice.getAdcName(OD_ADCS[this.hwChan]), this.odP, slowAdcs[OD_ADCS[this.hwChan]], this.odCal, maxDelta));
        }
        double gdCalNew = this.gdCal;
        double gdTolNew = this.gdTol;
        delta = this.gdP - slowAdcs[GD_ADCS[this.hwChan]];
        if (Math.abs(delta) < maxDelta) {
            gdCalNew = this.gdCal * Math.abs(this.gdP / slowAdcs[GD_ADCS[this.hwChan]]);
            gdTolNew = Math.abs(delta) / 4.0 > 2.0 * minTol ? Math.abs(delta) / 4.0 : 2.0 * minTol;
            tmsgList.add(String.format(formatStr0, this.biasPath, REBDevice.getAdcName(GD_ADCS[this.hwChan]), this.gdP, slowAdcs[GD_ADCS[this.hwChan]], this.gdCal, gdCalNew, this.gdTol, gdTolNew, (int)(this.gdConv * this.gdCal * this.gdP), (int)(this.gdConv * gdCalNew * this.gdP), this.gdConv * this.gdCal, this.gdConv * gdCalNew));
        } else {
            ++retval;
            tmsgList.add(String.format(formatStr1, this.biasPath, REBDevice.getAdcName(GD_ADCS[this.hwChan]), this.gdP, slowAdcs[GD_ADCS[this.hwChan]], this.gdCal, maxDelta));
        }
        double ogCalNew = this.ogCal;
        double ogTolNew = this.ogTol;
        delta = this.ogP - slowAdcs[OG_ADCS[this.hwChan]];
        if (Math.signum(this.ogP) == Math.signum(slowAdcs[OG_ADCS[this.hwChan]]) && Math.abs(delta) < maxDelta) {
            ogCalNew = this.ogCal * Math.abs(this.ogP / slowAdcs[OG_ADCS[this.hwChan]]);
            ogTolNew = Math.abs(delta) / 4.0 > minTol ? Math.abs(delta) / 4.0 : minTol;
            tmsgList.add(String.format(formatStr0, this.biasPath, REBDevice.getAdcName(OG_ADCS[this.hwChan]), this.ogP, slowAdcs[OG_ADCS[this.hwChan]], this.ogCal, ogCalNew, this.ogTol, ogTolNew, (int)(this.ogConv * this.ogCal * this.ogP), (int)(this.ogConv * ogCalNew * this.ogP), this.ogConv * this.ogCal, this.ogConv * ogCalNew));
        } else {
            ++retval;
            tmsgList.add(String.format(formatStr1, this.biasPath, REBDevice.getAdcName(OG_ADCS[this.hwChan]), this.ogP, slowAdcs[OG_ADCS[this.hwChan]], this.ogCal, maxDelta));
        }
        if (action && retval == 0) {
            this.sce.submitChange(this.biasPath, "rdCal", (Object)rdCalNew);
            this.sce.submitChange(this.biasPath, "rdTol", (Object)rdTolNew);
            this.sce.submitChange(this.biasPath, "odCal", (Object)odCalNew);
            this.sce.submitChange(this.biasPath, "odTol", (Object)odTolNew);
            this.sce.submitChange(this.biasPath, "gdCal", (Object)gdCalNew);
            this.sce.submitChange(this.biasPath, "gdTol", (Object)gdTolNew);
            this.sce.submitChange(this.biasPath, "ogCal", (Object)ogCalNew);
            this.sce.submitChange(this.biasPath, "ogTol", (Object)ogTolNew);
        }
        return retval;
    }

    public int checkBiasStepLimits(double[] slowAdcs, List<String> tmsgList) {
        int retval = 0;
        double maxStep = this.rebDevc.getMaxStep();
        String formatStr1 = "%-8.8s %-8.8s %6.2f --> %-6.2f: %s";
        double delta = this.odP - slowAdcs[OD_ADCS[this.hwChan]];
        boolean isOk = Math.abs(delta) < maxStep;
        retval += isOk ? 0 : 1;
        tmsgList.add(String.format(formatStr1, this.biasPath, REBDevice.getAdcName(OD_ADCS[this.hwChan]), slowAdcs[OD_ADCS[this.hwChan]], this.odP, isOk ? "OK" : "STEPTOOLARGE"));
        delta = this.rdP - slowAdcs[RD_ADCS[this.hwChan]];
        isOk = Math.abs(delta) < maxStep;
        retval += isOk ? 0 : 1;
        tmsgList.add(String.format(formatStr1, this.biasPath, REBDevice.getAdcName(RD_ADCS[this.hwChan]), slowAdcs[RD_ADCS[this.hwChan]], this.rdP, isOk ? "OK" : "STEPTOOLARGE"));
        delta = this.gdP - slowAdcs[GD_ADCS[this.hwChan]];
        isOk = Math.abs(delta) < maxStep;
        retval += isOk ? 0 : 1;
        tmsgList.add(String.format(formatStr1, this.biasPath, REBDevice.getAdcName(GD_ADCS[this.hwChan]), slowAdcs[GD_ADCS[this.hwChan]], this.gdP, isOk ? "OK" : "STEPTOOLARGE"));
        delta = this.ogP - slowAdcs[OG_ADCS[this.hwChan]];
        isOk = Math.abs(delta) < maxStep;
        tmsgList.add(String.format(formatStr1, this.biasPath, REBDevice.getAdcName(OG_ADCS[this.hwChan]), slowAdcs[OG_ADCS[this.hwChan]], this.ogP, isOk ? "OK" : "STEPTOOLARGE"));
        return retval += isOk ? 0 : 1;
    }

    private static boolean isValueOkay(double read, double set) {
        return Math.abs(read - set) <= 0.33;
    }

    private void clearGd(int wait) throws RaftException {
        this.setDac(13, 0);
        this.loadDac(wait);
    }

    private void clearOd(int wait) throws RaftException {
        this.setDac(12, 0);
        this.loadDac(wait);
    }

    private void clearOg(int wait) throws RaftException {
        this.setDac(15, 0);
        this.setDac(16, 0);
        this.loadDac(wait);
    }

    private void clearRd(int wait) throws RaftException {
        this.setDac(14, 0);
        this.loadDac(wait);
    }

    private void clearCsGate(int wait) throws RaftException {
        this.setDac(17, 0);
        this.loadDac(wait);
    }

    private void setDac(int chan, int value) throws RaftException {
        this.testOnline();
        try {
            this.dac.set(this.hwChan, chan, Math.max(0, Math.min(value, 4095)));
        }
        catch (REBException e) {
            throw new RaftException(e.getMessage());
        }
    }

    private void loadDac(int wait) throws RaftException {
        this.testOnline();
        try {
            this.dac.loadStrip(this.hwChan);
        }
        catch (REBException e) {
            throw new RaftException(e.getMessage());
        }
        try {
            Thread.sleep(wait);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void loadDac(int wait, List<REBDevice.AdcData> dataList) throws RaftException {
        int delay;
        this.testOnline();
        try {
            this.dac.loadStrip(this.hwChan);
        }
        catch (REBException e) {
            throw new RaftException(e.getMessage());
        }
        for (delay = wait; delay > 40; delay -= 40) {
            try {
                Thread.sleep(34L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.rebDevc.readSlowAdcs(dataList);
        }
        if (delay > 0) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private boolean isITLManufacturedCCD() {
        return this.rebDevc.isITLManufacturedCCD();
    }
}

