/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ListModel;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.HubConnector;
import org.astrogrid.samp.client.ResultHandler;
import org.astrogrid.samp.gui.AbstractCallActionManager;
import org.astrogrid.samp.gui.ErrorDialog;
import org.astrogrid.samp.gui.GuiHubConnector;
import org.astrogrid.samp.gui.SendActionManager;

public abstract class IndividualCallActionManager
extends AbstractCallActionManager {
    private final Component parent_;

    public IndividualCallActionManager(Component parent, GuiHubConnector connector, ListModel clientListModel) {
        super(parent, connector, clientListModel);
        this.parent_ = parent;
    }

    protected abstract Map createMessage(Client var1) throws Exception;

    public Action createBroadcastAction() {
        return new BroadcastAction();
    }

    private class BroadcastAction
    extends AbstractAction {
        final HubConnector connector_;
        final ListModel clientList_;

        BroadcastAction() {
            this.connector_ = IndividualCallActionManager.this.getConnector();
            this.clientList_ = IndividualCallActionManager.this.getClientListModel();
            this.putValue("SmallIcon", SendActionManager.getBroadcastIcon());
        }

        public void actionPerformed(ActionEvent evt) {
            Message msg;
            int nc = this.clientList_.getSize();
            HashMap msgMap = new HashMap();
            try {
                for (int ic = 0; ic < nc; ++ic) {
                    Client client = (Client)this.clientList_.getElementAt(ic);
                    Map message = IndividualCallActionManager.this.createMessage(client);
                    if (message == null) continue;
                    msg = Message.asMessage(message);
                    msg.check();
                    if (!msgMap.containsKey(msg)) {
                        msgMap.put(msg, new HashSet());
                    }
                    Collection clientSet = (Collection)msgMap.get(msg);
                    clientSet.add(client);
                }
            }
            catch (Exception e) {
                ErrorDialog.showError(IndividualCallActionManager.this.parent_, "Send Error", "Error constructing message " + e.getMessage(), e);
                return;
            }
            try {
                HubConnection connection = this.connector_.getConnection();
                if (connection != null) {
                    Iterator it = msgMap.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        msg = (Message)entry.getKey();
                        Client[] recipients = ((Collection)entry.getValue()).toArray(new Client[0]);
                        String tag = IndividualCallActionManager.this.createTag();
                        ResultHandler handler = IndividualCallActionManager.this.createResultHandler(connection, msg, recipients);
                        IndividualCallActionManager.this.registerHandler(tag, recipients, handler);
                        for (int ir = 0; ir < recipients.length; ++ir) {
                            connection.call(recipients[ir].getId(), tag, msg);
                        }
                    }
                }
            }
            catch (Exception e) {
                ErrorDialog.showError(IndividualCallActionManager.this.parent_, "Send Error", "Error sending message " + e.getMessage(), e);
            }
        }
    }
}

