/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.reb.ClientFactory;
import org.lsst.ccs.drivers.reb.GlobalClient;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.SequencerProc;

public class GlobalProc
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final List<REBDevice> rebDevices = new ArrayList<REBDevice>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ClientFactory clientFactory;
    @ConfigurationParameter(category="Rafts", isFinal=true)
    private String partition = "";
    @ConfigurationParameter(category="Rafts", isFinal=true)
    private String dfltFolder = "";
    private static final Logger LOG = Logger.getLogger(GlobalProc.class.getName());
    private GlobalClient gbl = new GlobalClient();
    private final List<SequencerProc> sequencers = new ArrayList<SequencerProc>();

    public void init() {
        if (this.clientFactory != null) {
            this.gbl.setClientFactory(this.clientFactory);
            for (REBDevice rebDevice : this.rebDevices) {
                rebDevice.setClientFactory(this.clientFactory);
            }
        }
        for (REBDevice rebDevice : this.rebDevices) {
            this.sequencers.add(rebDevice.getSequencer());
        }
        try {
            if (this.partition.isEmpty()) {
                int hdwType = 1;
                int[] ids = new int[this.rebDevices.size()];
                String[] ifcNames = new String[this.rebDevices.size()];
                for (int j = 0; j < ids.length; ++j) {
                    REBDevice reb = this.rebDevices.get(j);
                    ids[j] = reb.getId();
                    ifcNames[j] = reb.getIfcName();
                    hdwType = reb.getHdwType();
                }
                this.gbl.open(hdwType, ids, ifcNames);
            } else {
                this.gbl.open(this.partition);
            }
        }
        catch (REBException e) {
            LOG.log(Level.SEVERE, "Error during global initialization: ", e);
        }
    }

    public String getPartition() {
        return this.partition;
    }

    public void setRegisters(int rebType, int[] registers) throws REBException {
        this.gbl.setRegisterlist(rebType, registers);
    }

    public void acquireImage() throws REBException {
        this.acquireImage("", "", 1, "", new int[0]);
    }

    public void acquireImage(String name) throws REBException {
        this.acquireImage(name, "", 1, "", new int[0]);
    }

    public void acquireImage(String name, String folder, int opcode, String annot, int ... ids) throws REBException {
        this.gbl.acquireImage(name == null || name.isEmpty() ? String.format("Image_%016x", System.currentTimeMillis()) : name, folder == null || folder.isEmpty() ? this.dfltFolder : folder, opcode, annot, ids);
    }

    public void startSequencer() throws REBException {
        this.startSequencer(1);
    }

    public void startSequencer(int opcode) throws REBException {
        if (this.gbl.getHwType() == 5) {
            this.gbl.startSequencer(opcode);
        } else {
            for (SequencerProc seq : this.sequencers) {
                seq.resetError();
                seq.startSequencer();
            }
        }
    }
}

