/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Fits;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.lsst.ccs.Agent;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.daq.utilities.FitsService;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.RaftsMain;
import org.lsst.ccs.subsystem.rafts.TestClientFactorySimulator;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.MetaDataSet;

public class FitsFileWritingTest
extends CcsTestCaseTemplate {
    private static Subsystem testSubsystem = null;
    private static RaftsMain raftsMain = null;
    private static ConcurrentMessagingUtils cmu;
    private static Agent listener;
    private final Object imageReadyLock = new Object();
    private static FitsService fitsService;

    @BeforeClass
    public static void createSubsystem() throws Exception {
        System.setProperty("org.lsst.ccs.config.WriterProvier", "something");
        System.setProperty("org.lsst.ccs.run.mode", "simulation");
        testSubsystem = BootUtils.getSubsystemFromFile((String)"reb_fits_files_writing", (String)"");
        testSubsystem.startAgent();
        raftsMain = (RaftsMain)testSubsystem.getComponentLookup().getComponentByPath("main");
        fitsService = (FitsService)testSubsystem.getComponentLookup().getComponentByPath("main/fitsService");
        listener = new Agent("agent_listner", AgentInfo.AgentType.CONSOLE);
        listener.startAgent();
        cmu = new ConcurrentMessagingUtils(listener.getMessagingAccess());
        Assert.assertNotNull((Object)fitsService);
        Assert.assertNotNull((Object)raftsMain);
    }

    @AfterClass
    public static void shutdownSubsystem() throws Exception {
        testSubsystem.shutdownAgent();
        listener.shutdownAgent();
        System.setProperty("org.lsst.ccs.run.mode", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWriteFitsFiles() throws Exception {
        ImageStateListener imageStateListener = new ImageStateListener(raftsMain.getRaftsCommands().getREBDeviceNames().size());
        listener.getMessagingAccess().addStatusMessageListener((StatusMessageListener)imageStateListener);
        raftsMain.getRaftsCommands().loadSequencer("seq_1M.xml");
        Object object = this.imageReadyLock;
        synchronized (object) {
            raftsMain.getRaftsCommands().startSequencer();
            this.imageReadyLock.wait();
        }
        List files = raftsMain.getRaftsCommands().saveFitsImage("/tmp/", (FitsHeaderMetadataProvider)new TestFitsHeaderMetadataProvider());
        Assert.assertEquals((long)(raftsMain.getRaftsCommands().getREBDeviceNames().size() * 3), (long)files.size());
        this.testHeaderFile("/tmp/" + files.get(0));
        listener.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)imageStateListener);
        ArrayList<String> fileNamesToFind = new ArrayList<String>();
        for (Object obj : raftsMain.getRaftsCommands().getREBDeviceNames()) {
            String rebName = (String)obj;
            fileNamesToFind.add("Image_" + rebName + "_0");
            fileNamesToFind.add("Image_" + rebName + "_1");
            fileNamesToFind.add("Image_" + rebName + "_2");
        }
        for (String fileName : fileNamesToFind) {
            boolean found = false;
            for (Object fitsFileNameObj : files) {
                String fitsFileName = (String)fitsFileNameObj;
                if (!fitsFileName.startsWith(fileName)) continue;
                found = true;
                break;
            }
            Assert.assertTrue((boolean)found);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImageContent() throws Exception {
        ImageStateListener imageStateListener = new ImageStateListener(raftsMain.getRaftsCommands().getREBDeviceNames().size());
        listener.getMessagingAccess().addStatusMessageListener((StatusMessageListener)imageStateListener);
        raftsMain.getRaftsCommands().loadSequencer("seq_1M.xml");
        Object object = this.imageReadyLock;
        synchronized (object) {
            raftsMain.getRaftsCommands().startSequencer();
            this.imageReadyLock.wait();
        }
        TestClientFactorySimulator.TestSegmentDataProvider dataProvider = TestClientFactorySimulator.dataProvider;
        ByteBuffer generatedData = dataProvider.getGeneratedData();
        REBDevice reb = (REBDevice)FitsFileWritingTest.raftsMain.rebDevicesMap.get("R00.Reb0");
        ByteBuffer[][] splitdata = reb.getImageProc().splitImage();
        Assert.assertEquals((long)48L, (long)(splitdata.length * splitdata[0].length));
        int size = generatedData.capacity() / 4 / 48;
        Assert.assertEquals((long)size, (long)(splitdata[0][0].capacity() / 4));
        for (int j = 0; j < size; ++j) {
            for (int ic = 0; ic < splitdata.length; ++ic) {
                int icr = splitdata.length == 3 ? 2 - ic : ic;
                for (int ia = 0; ia < splitdata[icr].length; ++ia) {
                    ByteBuffer bb = splitdata[icr][ia];
                    Assert.assertEquals((long)bb.getInt(), (long)(generatedData.getInt() ^ 0x1FFFF));
                }
            }
        }
        listener.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)imageStateListener);
    }

    private void testHeaderFile(String fitsFileName) throws Exception {
        Map headerSpecs = fitsService.getHeaderSpecificationMap();
        Fits fitsFile = new Fits(fitsFileName);
        fitsFile.read();
        int nHdus = fitsFile.getNumberOfHDUs();
        Assert.assertEquals((long)17L, (long)nHdus);
        BasicHDU primary = fitsFile.getHDU(0);
        HeaderSpecification primarySpecification = (HeaderSpecification)headerSpecs.get("primary");
        for (HeaderSpecification.HeaderLine headerLine : primarySpecification.getHeaders()) {
            String headerKey = headerLine.getKeyword();
            Assert.assertTrue((String)("Could not find header " + headerKey), (boolean)primary.getHeader().containsKey(headerKey));
        }
        HeaderSpecification extendedSpecification = (HeaderSpecification)headerSpecs.get("extended");
        for (int i = 1; i < nHdus; ++i) {
            BasicHDU hdu = fitsFile.getHDU(i);
            for (HeaderSpecification.HeaderLine headerLine : extendedSpecification.getHeaders()) {
                String headerKey = headerLine.getKeyword();
                Assert.assertTrue((String)("Could not find header " + headerKey), (boolean)hdu.getHeader().containsKey(headerKey));
            }
        }
    }

    private class TestFitsHeaderMetadataProvider
    implements FitsHeaderMetadataProvider {
        private long obsvTime;
        private final Map<String, Object> sysMetadata = new HashMap<String, Object>();

        public TestFitsHeaderMetadataProvider() {
            this.sysMetadata.put("SequenceNumber", 0);
            this.sysMetadata.put("FileCreationTime", new Date());
            this.sysMetadata.put("ObservationDate", new Date());
            this.sysMetadata.put("ExposureTime", 0.0);
            this.sysMetadata.put("ShutterDelay", 0.0);
            this.sysMetadata.put("CCDControllerConfigFile", "NotDefined");
            this.sysMetadata.put("OriginalFileName", "NotDefined");
            this.sysMetadata.put("Origin", "NotDefined");
            this.sysMetadata.put("TestStand", "NotDefined");
            this.sysMetadata.put("Instrument", "REB");
            this.sysMetadata.put("CCDControllerSerial", "NotDefined");
            this.sysMetadata.put("CCDManufacturer", "NotDefined");
            this.sysMetadata.put("CCDModel", "NotDefined");
            this.sysMetadata.put("CCDSerialManufacturer", "NotDefined");
            this.sysMetadata.put("CCDSerialLSST", "NotDefined");
            this.sysMetadata.put("FilterName", "NotDefined");
            this.sysMetadata.put("TemperatureSetPoint", 0.0);
            this.sysMetadata.put("MonochromatorWavelength", 0.0);
            this.sysMetadata.put("TestType", "NotDefined");
            this.sysMetadata.put("ImageType", "NotDefined");
            this.sysMetadata.put("RunNumber", "NotDefined");
            this.sysMetadata.put("RaftName", "NotDefined");
            this.sysMetadata.put("RebName", "NotDefined");
        }

        public MetaDataSet getPrimaryHeaderMetadata(ImageSet imageSet) {
            MetaDataSet ccdMetadataSet = new MetaDataSet();
            int j = imageSet.getCCD().getSerialPosition();
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            metadata.put("Tag", String.valueOf(this.obsvTime));
            metadata.put("MeasuredTemperature", 0.0);
            metadata.put("SystemGain", 0.0);
            metadata.put("SystemNoise", 0.0);
            ccdMetadataSet.addMetaDataMap("primary", this.sysMetadata);
            ccdMetadataSet.addMetaDataMap("ccd", metadata);
            return ccdMetadataSet;
        }

        public MetaDataSet getDataExtendedHeaderMetadata(ImageSet imageSet, int extendedIndex) {
            MetaDataSet segmentMetaDataSet = new MetaDataSet();
            HashMap<String, Double> metadata = new HashMap<String, Double>();
            metadata.put("AVERAGE", 0.0);
            metadata.put("STDEV", 0.0);
            metadata.put("AVGBIAS", 0.0);
            metadata.put("STDVBIAS", 0.0);
            metadata.put("AVWOBIAS", 0.0);
            segmentMetaDataSet.addMetaDataMap("primary", this.sysMetadata);
            segmentMetaDataSet.addMetaDataMap("seg", metadata);
            return segmentMetaDataSet;
        }

        public MetaDataSet getAdditionalExtendedHeaderMetadata(ImageSet imageSet, String extendedKeyword) {
            return null;
        }
    }

    private class ImageStateListener
    implements StatusMessageListener {
        private int msgCount = 0;
        private final int msgLimit;

        public ImageStateListener(int nRebs) {
            this.msgLimit = nRebs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onStatusMessage(StatusMessage msg) {
            StatusSubsystemData ssdata;
            if (msg.getOriginAgentInfo().getName().equals("reb_tests") && msg instanceof StatusSubsystemData && (ssdata = (StatusSubsystemData)msg).getDataKey().equals("ImageState")) {
                Object object = FitsFileWritingTest.this.imageReadyLock;
                synchronized (object) {
                    ++this.msgCount;
                    if (this.msgCount == this.msgLimit) {
                        FitsFileWritingTest.this.imageReadyLock.notifyAll();
                    }
                }
            }
        }
    }
}

