/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.imagenaming.service.ImageNameService;
import org.lsst.ccs.services.AgentCommandDictionaryService;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.rafts.GlobalProc;
import org.lsst.ccs.subsystem.rafts.ImageProc;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.RaftsCommands;
import org.lsst.ccs.subsystem.rafts.TempControl;
import org.lsst.ccs.subsystem.rafts.data.CcdType;
import org.lsst.ccs.subsystem.rafts.data.ImageData;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.subsystem.rafts.data.RaftState;
import org.lsst.ccs.subsystem.rafts.data.RaftsAgentProperties;
import org.lsst.ccs.subsystem.rafts.states.SequencerMainState;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.E2VCCDType;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Reb;

public class RaftsMain
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final List<REBDevice> rebDevices = new ArrayList<REBDevice>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    protected final Map<String, REBDevice> rebDevicesMap = new HashMap<String, REBDevice>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private TempControl tempCtrl;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService sce;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService aptService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService apService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService asService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private ImageNameService imageNameService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private GlobalProc globalProc;
    @ConfigurationParameter(category="Rafts")
    private CcdType ccdType = CcdType.NONE;
    private static final Logger LOG = Logger.getLogger(RaftsMain.class.getName());
    private RaftsCommands raftsCommands;
    private final CCDType ccdTypeX = new E2VCCDType();
    private final Raft raftGeometry = Raft.createRaft((CCDType)this.ccdTypeX);
    private boolean running = false;

    public void postBuild() {
        this.aptService.scheduleAgentPeriodicTask(new AgentPeriodicTask("sequencerMonitor", () -> this.raftsCommands.checkSequencerState()).withIsFixedRate(false).withPeriod(Duration.ofSeconds(5L)));
    }

    public void postInit() {
        this.apService.setAgentProperty(RaftsAgentProperties.RAFT_TYPE_AGENT_PROPERTY, RaftsMain.class.getCanonicalName());
        if (this.tempCtrl == null) {
            LOG.warning("No temperature control available");
        }
        this.raftsCommands = new RaftsCommands(this.subsys, this.rebDevices, this.globalProc, (Geometry)this.raftGeometry, this.tempCtrl, this.imageNameService);
        ((AgentCommandDictionaryService)this.subsys.getAgentService(AgentCommandDictionaryService.class)).addCommandSetToObject((Object)this.raftsCommands, (Object)"");
    }

    public void postStart() {
        this.raftsCommands.setCcdType(this.ccdType.name().toLowerCase());
        for (REBDevice devc : this.rebDevices) {
            BitSet s = new BitSet(3);
            for (int i = 0; i < 3; ++i) {
                s.set(i, (devc.getCcdMask() & 1 << i) != 0);
            }
            Reb rebGeometry = Reb.createReb((CCDType)this.ccdTypeX, (BitSet)s);
            this.raftGeometry.addReb(rebGeometry, devc.getRebNumber());
        }
        this.running = true;
        LOG.info("Rafts subsystem started");
        this.asService.updateAgentState(new Enum[]{SequencerMainState.UNKNOWN});
        this.publishState();
    }

    @ConfigurationParameterChanger
    public void setCcdType(CcdType type) {
        this.ccdType = type;
        this.raftsCommands.setCcdType(this.ccdType.name().toLowerCase());
    }

    @Command(type=Command.CommandType.ACTION, description="Set the update interval")
    public void setUpdatePeriod(@Argument(name="value", description="The tick period (ms)") int value) {
        this.setTickPeriod(value);
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Save the current configuration")
    public void saveNamedConfig(String name) throws IOException {
        if (name.isEmpty()) {
            this.sce.saveChangesForCategories(new String[]{"Rafts"});
        } else {
            this.sce.saveChangesForCategoriesAs(new String[]{"Rafts:" + name});
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Load a named rafts configuration")
    public void loadNamedConfig(String name) throws IOException {
        this.sce.loadCategories(new String[]{"RaftsLimits:" + name, "Rafts:" + name});
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full Raft module state")
    public RaftState getFullState() {
        return new RaftState(this.getTickPeriod());
    }

    @Command(type=Command.CommandType.QUERY, description="Get a portion of a saved raw image")
    public static ImageData getImage(@Argument(name="filename", description="The image file name") String fileName, @Argument(name="offset", description="The offset to the first pixel") int offset, @Argument(name="count", description="The number of pixels to get") int count) throws RaftException, IOException {
        return ImageProc.getImage(fileName, offset, count);
    }

    void publishState() {
        if (!this.running) {
            return;
        }
        KeyValueData data = new KeyValueData("RaftState", (Serializable)new RaftState(this.getTickPeriod()));
        this.subsys.publishSubsystemDataOnStatusBus(data);
    }

    private void setTickPeriod(long period) {
        this.aptService.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.aptService.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }

    RaftsCommands getRaftsCommands() {
        return this.raftsCommands;
    }
}

