# Specification file for primary header. Taken from LCA 10140 v1.
# Modified for use with ATS
#
HEADVER     Integer 2                           Version number of header
ORIGIN      String  ${Origin}                   Which site acquired the data
DATE        Date    ${FileCreationTime}         Creation Date and Time of File
DATE-OBS    Date    ${ObservationDate}          Date of the observation (image acquisition), UTC
MJD         MJD     ${FileCreationTime}         Modified Julian Date that the file was written
MJD-OBS     MJD     ${ObservationDate}          Modified Julian Date of image acquisition
INSTRUME    String  LSST_ATISS                  Instrument
TELESCOP    String  LSST_AuxTel                 Telescope
IMAGETAG    String  ${Tag}                      DAQ Image id
CONTNUM     String  ${CCDControllerSerial}      CCD Controller (WREB) Serial Number
SEQFILE     String  ${SequencerFileName}        Sequencer file name
SEQCKSUM    String  ${SequencerChecksum}        Checksum of Sequencer
CCD_MANU    String  ${CCDManufacturer}          CCD Manufacturer
CCD_TYPE    String  ${CCDModel}                 CCD Model Number
CCD_SERN    String  20304                       Manufacturers' CCD Serial Number
LSST_NUM    String  ITL-3800C-068               LSST Assigned CCD Number
REBNAME     String  ${RebName}                  Name of the REB
IMGTYPE     String  ${ImageType}                BIAS, DARK, …
DETSIZE     String  ${DETSIZE}                  IRAF detector size 
TEMP_SET    Float   ${TemperatureSetPoint}      CCD Temperature set point (deg C)
CCDTEMP     Float   ${MeasuredTemperature}      Measured temperature (deg C)
EXPTIME     Float   ${ExposureTime}             Exposure Time in Seconds
DARKTIME    Float   ${DarkTime}                 Dark Time in Seconds (see TSEIA-91)
FILENAME    String  ${OriginalFileName}         Original name of the file
# Elements from the image name, see also TSEIA-79
OBSID       String  ${ImageName}                The image name or obs-id
TELCODE     String  ${ImageSource}              The "code" for AuxTel
CONTRLLR    String  ${ImageController}          The controller (e.g. O for OCS, C for CCS)
DAYOBS      String  ${ImageDate}                The observation day as defined in the image name 
SEQNUM      Integer ${ImageNumber}              The sequence number from the image name
