/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.PIController;
import org.lsst.ccs.subsystem.rafts.REBDevice;

public class TempControl
implements HasLifecycle {
    private static final String TIMER_NAME = "temp-loop-timer";
    @LookupField(strategy=LookupField.Strategy.TOP)
    Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService pts;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, Channel> allChannels = new HashMap<String, Channel>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, REBDevice> allRebs = new HashMap<String, REBDevice>();
    private static final Logger LOG = Logger.getLogger(TempControl.class.getName());
    private Double gain;
    private Double timeConst;
    private Double smoothTime;
    private Double maxOutput;
    private Double awGain;
    private Double basePower;
    private Double tolerance;
    private double minOutput = 0.0;
    private double maxInput = 100.0;
    private double minInput = -200.0;
    private Integer updateTime;
    private String[] tempChans;
    private String[] rebs;
    private PIController pic;
    private final List<Channel> tempChansL = new ArrayList<Channel>();
    private final List<REBDevice> rebsL = new ArrayList<REBDevice>();
    private double lastPower;
    private boolean active;
    private double setTemp;

    public void build() {
        this.pts.scheduleAgentPeriodicTask(new AgentPeriodicTask(TIMER_NAME, () -> this.iterateLoop()).withPeriod(Duration.ofMillis(this.updateTime.intValue())));
    }

    public void init() {
        if (this.gain == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"gain", (String)"is missing");
        }
        if (this.timeConst == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"timeConst", (String)"is missing");
        }
        if (this.smoothTime == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"smoothTime", (String)"is missing");
        }
        if (this.maxOutput == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"maxOutput", (String)"is missing");
        }
        if (this.awGain == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"awGain", (String)"is missing");
        }
        if (this.basePower == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"basePower", (String)"is missing");
        }
        if (this.tolerance == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"tolerance", (String)"is missing");
        }
        if (this.updateTime == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"updateTime", (String)"is missing");
        }
        if (this.tempChans == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"tempChans", (String)"is missing");
        } else {
            for (String cName : this.tempChans) {
                Channel chan = this.allChannels.get(cName);
                if (chan != null) {
                    this.tempChansL.add(chan);
                    continue;
                }
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"tempChans", (String)"contains non-Channel item");
            }
        }
        if (this.rebs == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"rebs", (String)"is missing");
        } else {
            for (String cName : this.rebs) {
                REBDevice reb = this.allRebs.get(cName);
                if (reb != null) {
                    this.rebsL.add(reb);
                    continue;
                }
                ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"rebs", (String)"contains non-REBDevice item");
            }
        }
        this.pic = new PIController(this.gain.doubleValue(), this.timeConst.doubleValue());
        this.pic.setSmoothTime(this.smoothTime.doubleValue());
        this.pic.setAwGain(this.awGain.doubleValue());
        this.pic.setBaseOutput(this.basePower.doubleValue());
        this.pic.setInputRange(this.minInput, this.maxInput);
        this.pic.setOutputRange(this.minOutput, this.maxOutput.doubleValue());
        this.pic.setTolerance(this.tolerance.doubleValue());
    }

    void setPower(double power) {
        for (REBDevice reb : this.rebsL) {
            try {
                reb.setHeaterPower(0, power / (double)this.rebs.length);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Error setting {0} heater: {1}", new Object[]{reb.getName(), e.getMessage()});
            }
        }
    }

    public void setTemperature(double temp) {
        this.setTemp = temp;
        this.pic.setSetpoint(this.setTemp);
    }

    public double getTemperature() {
        return this.setTemp;
    }

    public void startLoop(double power) {
        if (this.active) {
            return;
        }
        this.lastPower = power;
        this.startLoop();
    }

    public void startLoop() {
        if (this.active) {
            return;
        }
        this.pic.reset();
        this.pic.setIntegral(this.lastPower - this.basePower);
        this.active = true;
    }

    public void stopLoop() {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.setPower(0.0);
    }

    public boolean isLoopActive() {
        return this.active;
    }

    public void reset() {
        this.pic.reset();
    }

    private void iterateLoop() {
        if (!this.active) {
            return;
        }
        int count = 0;
        double temp = 0.0;
        for (Channel tempChan : this.tempChansL) {
            double value = tempChan.getValue();
            if (Double.isNaN(value)) continue;
            temp += value;
            ++count;
        }
        if (count > 0) {
            double tod = (double)System.currentTimeMillis() / 1000.0;
            this.lastPower = this.pic.performPI(new double[]{temp / (double)count}, tod);
            this.setPower(this.lastPower);
        } else {
            LOG.severe("Control loop iteration failed: no valid temperature values available");
        }
    }
}

