/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.monitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.states.DataProviderState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class MonitorUpdateTask {
    private final String name;
    private static final Logger LOG = Logger.getLogger(MonitorUpdateTask.class.getName());
    private final List<Channel> listOfChannels = new ArrayList<Channel>();
    private final Set<Alarm> listOfAlarms = new HashSet<Alarm>();
    private final Set<String> listOfGroups = new TreeSet<String>();
    private final Map<Device, Map<String, List<Channel>>> deviceGroupChannelMap = new HashMap<Device, Map<String, List<Channel>>>();
    private StateBundle currentState = new StateBundle(new Enum[0]);
    private volatile boolean doPublishData;
    private final Object publshDataLockObject = new Object();
    private final List<String> channels = new ArrayList<String>();

    MonitorUpdateTask(String name, List<Channel> channels) {
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        this.name = name;
        this.listOfChannels.addAll(channels);
        for (Channel ch : this.listOfChannels) {
            this.channels.add(ch.getPath());
        }
    }

    List<Channel> configureTask(List<Channel> mapOfChannels) {
        mapOfChannels.removeIf(e -> {
            Channel channel = e;
            if (this.listOfChannels.contains(channel)) {
                String channelGroup = channel.getGroup();
                this.listOfGroups.add(channelGroup);
                Map groupChannelMap = this.deviceGroupChannelMap.getOrDefault(channel.getDevice(), new HashMap());
                List groupListOfChannels = groupChannelMap.getOrDefault(channelGroup, new ArrayList());
                groupListOfChannels.add(channel);
                Collections.sort(groupListOfChannels, (o1, o2) -> ((Channel)o1).getPath().compareTo(((Channel)o2).getPath()));
                groupChannelMap.put(channelGroup, groupListOfChannels);
                this.deviceGroupChannelMap.put(channel.getDevice(), groupChannelMap);
                return true;
            }
            return false;
        });
        for (Channel ch : this.listOfChannels) {
            if (ch.alarmHiA != null) {
                this.listOfAlarms.add(ch.alarmHiA);
            }
            if (ch.alarmLoA == null) continue;
            this.listOfAlarms.add(ch.alarmLoA);
        }
        return mapOfChannels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitorPublish() {
        Object object = this.publshDataLockObject;
        synchronized (object) {
            LOG.log(Level.FINEST, "Setting flag to publish all the data");
            this.doPublishData = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitorUpdate(Monitor monitor) {
        long start = System.currentTimeMillis();
        for (Map.Entry<Device, Map<String, List<Channel>>> entry : this.deviceGroupChannelMap.entrySet()) {
            Device device = entry.getKey();
            for (Map.Entry<String, List<Channel>> groupEntry : entry.getValue().entrySet()) {
                String deviceGroup = groupEntry.getKey();
                List<Channel> channelsInGroupForDevice = groupEntry.getValue();
                if (this.getName().isEmpty() || deviceGroup.isEmpty()) {
                    device.readChannelGroup();
                } else {
                    device.readChannelGroup(deviceGroup);
                }
                for (Channel ch : channelsInGroupForDevice) {
                    if (ch.getState() == DataProviderState.DISABLED) continue;
                    ch.readSensor();
                }
            }
        }
        StateBundle sb = new StateBundle(new Enum[0]);
        for (Channel ch : this.listOfChannels) {
            ch.checkLimits();
            sb.setComponentState(ch.getPath(), new Enum[]{ch.getState()});
        }
        StateBundle stateBundle = sb.diffState(this.currentState);
        this.currentState = sb;
        Map statesMap = stateBundle.getComponentsWithState(DataProviderState.class);
        for (Alarm alarm : this.listOfAlarms) {
            alarm.setState();
        }
        Object object = this.publshDataLockObject;
        synchronized (object) {
            if (this.doPublishData || !statesMap.isEmpty()) {
                KeyValueDataList dataList = new KeyValueDataList();
                for (Channel ch : this.listOfChannels) {
                    double value;
                    if (!this.doPublishData && !statesMap.containsKey(ch.getPath())) continue;
                    CCSTimeStamp ts = ch.getCCSTimeStamp();
                    if (ts != null && !Double.isNaN(value = ch.getValue())) {
                        dataList.addData(monitor.useFullPath ? ch.getPath() : ch.getName(), (Serializable)Double.valueOf(value), ts);
                    }
                    monitor.dataProviderDictionaryService.addMetadataForObject(dataList, DataProviderInfo.Attribute.STATE.getName(), ch.getState().name(), ch);
                }
                if (!dataList.getListOfKeyValueData().isEmpty() && monitor.readyToPublish) {
                    LOG.log(Level.FINER, "{0} publishing Monitor data for {1} key: {2} entries: {3}", new Object[]{this.name, monitor.subsys.getName(), dataList.getKey(), dataList.getListOfKeyValueData().size()});
                    monitor.subsys.publishSubsystemDataOnStatusBus((KeyValueData)dataList);
                }
                this.doPublishData = false;
            }
        }
        long delta = System.currentTimeMillis() - start;
        LOG.log(Level.FINEST, "Monitoring loop {0} completed in {1} ms.", new Object[]{this.name, delta});
    }

    String getName() {
        String n = this.name;
        if (n.startsWith("default")) {
            n = n.replace("default", "");
        }
        if (n.startsWith("/")) {
            n = n.substring(1);
        }
        return n;
    }

    Set<Device> getDevices() {
        return this.deviceGroupChannelMap.keySet();
    }

    Set<String> getGroupsForDevice(Device device) {
        return this.deviceGroupChannelMap.get(device).keySet();
    }

    List<Channel> getChannelsForDeviceGroup(Device device, String group) {
        return this.deviceGroupChannelMap.get(device).get(group);
    }

    List<Channel> getAllChannels() {
        return this.listOfChannels;
    }

    Set<String> getAllGroups() {
        return this.listOfGroups;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Monitor Task: ").append(this.getName()).append("\n");
        for (Map.Entry<Device, Map<String, List<Channel>>> deviceEntry : this.deviceGroupChannelMap.entrySet()) {
            Device device = deviceEntry.getKey();
            sb.append("Device: ").append(device.getName()).append("\n");
            for (Map.Entry<String, List<Channel>> groupEntry : deviceEntry.getValue().entrySet()) {
                String deviceGroup = groupEntry.getKey();
                List<Channel> channelsInGroupForDevice = groupEntry.getValue();
                sb.append("   Channels in group: ").append(deviceGroup).append("\n");
                int count = 0;
                for (Channel ch : channelsInGroupForDevice) {
                    sb.append("    ").append(count).append(" ").append(ch.getPath()).append("\n");
                    ++count;
                }
            }
        }
        return sb.toString();
    }
}

