/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.focalplane;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.bus.data.DataProviderInfo;

public enum FocalPlaneDataGroup {
    ASPIC_TEMPERATURE("Aspic Temperature", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>(Reb\\d|[WG]Reb))/(?<aspicId>Aspic[UL])/Temp\\d")),
    REB_TEMPERATURE("Reb Temperature", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>(Reb\\d|[WG]Reb))/Temp\\d+")),
    CCD_TEMPERATURE("CCD Temperature", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>(Reb\\d|[WG]Reb))/(?<sensorId>S\\d\\d)/Temp")),
    CCD_CURRENTS("CCD Currents", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>(Reb\\d|[WG]Reb))/(?<sensorId>S\\d\\d)/I(?<amplifierId>\\d\\d)")),
    CCD_VOLTAGES("CCD Voltages", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>(Reb\\d|[WG]Reb))/(?<sensorId>S\\d\\d)/[ORG][DG]V")),
    BIAS_VOLTAGES("Bias Voltages", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>(Reb\\d|[WG]Reb))/Ref\\d+V")),
    RTD_TEMPERATURE("RTD Temperature", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>(Reb\\d|[WG]Reb))/RTDTemp")),
    CLOCK_RAILS("Clock Rails", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>(Reb\\d|[WG]Reb))/([PS]Clk[UL]|RG[UL]|Ref[PN]12)")),
    BOARD_POWER("Board Power", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>(Reb\\d|[WG]Reb))/(Dig[VI]|Ana[VI]|Clk[HL][VI]|Power|OD[VI])")),
    HEATER("Heater", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>(Reb\\d|[WG]Reb))/Htr[V|W]")),
    PS_REB_DIGITAL_VOLTAGE("PS Reb Digital Voltage", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>(Reb\\d|[WG]Reb))/digital/V(.*)")),
    PS_REB_DIGITAL_CURRENT("PS Reb Digital Current", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>(Reb\\d|[WG]Reb))/digital/I(.*)")),
    PS_REB_OD_VOLTAGE("PS Reb OD Voltage", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>(Reb\\d|[WG]Reb))/OD/V(.*)")),
    PS_REB_OD_CURRENT("PS Reb OD Current", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>(Reb\\d|[WG]Reb))/OD/I(.*)")),
    PS_REB_CLOCK_HI_VOLTAGE("PS Reb Clock High Voltage", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>(Reb\\d|[WG]Reb))/clockhi/V(.*)")),
    PS_REB_CLOCK_HI_CURRENT("PS Reb Clock High Current", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>(Reb\\d|[WG]Reb))/clockhi/I(.*)")),
    PS_REB_CLOCK_LO_VOLTAGE("PS Reb Clock Low Voltage", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>(Reb\\d|[WG]Reb))/clocklo/V(.*)")),
    PS_REB_CLOCK_LO_CURRENT("PS Reb Clock Low Current", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>(Reb\\d|[WG]Reb))/clocklo/I(.*)")),
    PS_REB_HEATER_VOLTAGE("PS Reb Heater Voltage", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>(Reb\\d|[WG]Reb))/heater/V(.*)")),
    PS_REB_HEATER_CURRENT("PS Reb Heater Current", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>(Reb\\d|[WG]Reb))/heater/I(.*)")),
    PS_REB_HVBIAS_VOLTAGE("PS Reb HV Bias Voltage", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>(Reb\\d|[WG]Reb))/hvbias/V(.*)")),
    PS_REB_HVBIAS_CURRENT("PS Reb HV Bias Current", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>(Reb\\d|[WG]Reb))/hvbias/I(.*)")),
    PS_REB_ANALOG_VOLTAGE("PS Reb Analog Voltage", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>(Reb\\d|[WG]Reb))/analog/V(.*)")),
    PS_REB_ANALOG_CURRENT("PS Reb Analog Current", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>(Reb\\d|[WG]Reb))/analog/I(.*)")),
    PS_REB_DPHI_VOLTAGE("PS Reb DPhi Voltage", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>(Reb\\d|[WG]Reb))/dphi/V(.*)")),
    PS_REB_DPHI_CURRENT("PS Reb DPhi Current", Pattern.compile("(?<raftId>R\\d\\d)/(?<rebId>(Reb\\d|[WG]Reb))/dphi/I(.*)"));

    private final String name;
    private final Pattern pattern;

    public static FocalPlaneDataGroup forName(String name) {
        for (FocalPlaneDataGroup g : FocalPlaneDataGroup.values()) {
            if (!g.name.equals(name)) continue;
            return g;
        }
        throw new IllegalArgumentException("No FocalPlaneDataGroup constant with " + name + " name.");
    }

    private FocalPlaneDataGroup(String name, Pattern pattern) {
        this.name = name;
        this.pattern = pattern;
    }

    public String getName() {
        return this.name;
    }

    public boolean matchesData(DataProviderInfo dataInfo) {
        return this.pattern.matcher(dataInfo.getPath()).matches();
    }

    public static FocalPlaneDataGroup findFocalPlanDataGroup(DataProviderInfo dataInfo) {
        FocalPlaneDataGroup fpdg = null;
        for (FocalPlaneDataGroup dataGroup : FocalPlaneDataGroup.values()) {
            if (!dataGroup.matchesData(dataInfo)) continue;
            if (fpdg != null) {
                throw new RuntimeException("DataInfo " + dataInfo.getPath() + " matches more than one group: " + (Object)((Object)fpdg) + " " + (Object)((Object)dataGroup));
            }
            fpdg = dataGroup;
        }
        return fpdg;
    }

    public void addAttributesToDataInfo(DataProviderInfo dataInfo) {
        Matcher m = this.pattern.matcher(dataInfo.getPath());
        if (m.matches()) {
            String sensorId2;
            dataInfo.addAttribute(DataProviderInfo.Attribute.DATA_GROUP, this.getName());
            try {
                String raftId = m.group("raftId");
                if (raftId != null) {
                    dataInfo.addAttribute(DataProviderInfo.Attribute.RAFT_ID, raftId);
                }
            }
            catch (Exception raftId) {
                // empty catch block
            }
            try {
                String rebId = m.group("rebId");
                if (rebId != null) {
                    dataInfo.addAttribute(DataProviderInfo.Attribute.REB_ID, rebId);
                }
            }
            catch (Exception rebId) {
                // empty catch block
            }
            try {
                String aspicId = m.group("aspicId");
                if (aspicId != null) {
                    dataInfo.addAttribute(DataProviderInfo.Attribute.ASPIC_ID, aspicId);
                }
            }
            catch (Exception aspicId) {
                // empty catch block
            }
            try {
                sensorId2 = m.group("sensorId");
                if (sensorId2 != null) {
                    dataInfo.addAttribute(DataProviderInfo.Attribute.SENSOR_ID, sensorId2);
                }
            }
            catch (Exception sensorId2) {
                // empty catch block
            }
            try {
                sensorId2 = m.group("amplifierId");
                if (sensorId2 != null) {
                    dataInfo.addAttribute(DataProviderInfo.Attribute.AMPLIFIER_ID, sensorId2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getRaftId(DataProviderInfo dataInfo) {
        try {
            Matcher m = this.pattern.matcher(dataInfo.getPath());
            return m.matches() ? m.group("raftId") : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getRebId(DataProviderInfo dataInfo) {
        try {
            Matcher m = this.pattern.matcher(dataInfo.getPath());
            return m.matches() ? m.group("rebId") : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getAspicId(DataProviderInfo dataInfo) {
        try {
            Matcher m = this.pattern.matcher(dataInfo.getPath());
            return m.matches() ? m.group("aspicId") : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getSensorId(DataProviderInfo dataInfo) {
        try {
            Matcher m = this.pattern.matcher(dataInfo.getPath());
            return m.matches() ? m.group("sensorId") : null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

