/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class Alert
implements Serializable {
    private static final long serialVersionUID = -568951332963342L;
    private final String alertId;
    private final String description;
    private final Map<String, Object> innerData;

    public Alert(String alertId, String description) {
        this(alertId, description, Collections.EMPTY_MAP);
    }

    public Alert(String alertId, String description, Map<String, Object> innerData) {
        if (innerData == null) {
            innerData = Collections.EMPTY_MAP;
        }
        this.alertId = alertId;
        this.description = description;
        this.innerData = Collections.unmodifiableMap(innerData);
    }

    public String getAlertId() {
        return this.alertId;
    }

    public String getDescription() {
        return this.description;
    }

    public Object getAlertData(String key) {
        return this.innerData.get(key);
    }

    public Set<String> getAlertDataNames() {
        return this.innerData.keySet();
    }

    public String toString() {
        return "Alert " + this.getAlertId() + " " + this.getDescription() + ")";
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + Objects.hashCode(this.alertId);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Alert)) {
            return false;
        }
        Alert other = (Alert)obj;
        return Objects.equals(this.alertId, other.alertId);
    }
}

