/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.devices;

import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.common.devices.Maq20Device;
import org.lsst.ccs.utilities.logging.Logger;

public class Maq20Control
implements HasLifecycle {
    private String type;
    private static final Logger LOG = Logger.getLogger((String)Maq20Control.class.getName());
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    private Maq20Device maqDevc;
    private Maq20Device.ModuleData modData;
    private boolean haveError = false;
    @LookupName
    private String name;

    public void init() {
        String[] words;
        if (this.type == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"type", (String)"not specified");
        }
        if ((words = this.type.split(":")).length != 1) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"type", (String)"doesn't have exactly one element");
        }
        try {
            int modIx = Integer.decode(words[0]);
            this.modData = this.maqDevc.getModuleData(modIx);
            if (this.modData == null) {
                MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"module", (String)"doesn't exist");
            }
        }
        catch (NumberFormatException ex) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"module index", (String)"is not numeric");
        }
    }

    public void setLineOn(int chan, boolean on) throws DriverException {
        if (this.modData.maqDisc == null) {
            throw new DriverException("Error setting line: device " + this.maqDevc.getName() + " is offline");
        }
        this.modData.maqDisc.writeDisc(chan, on ? 0 : 1);
    }

    public Boolean isLineOn(int chan) {
        Boolean on;
        block3: {
            on = null;
            try {
                if (this.modData.maqDisc == null) {
                    throw new DriverException(this.maqDevc.getName() + " is offline");
                }
                on = this.modData.maqDisc.readDiscOut(chan) == 0;
                this.haveError = false;
            }
            catch (DriverException e) {
                if (this.haveError) break block3;
                LOG.severe((Object)("Error reading channel " + chan + " state: " + (Object)((Object)e)));
                this.haveError = true;
            }
        }
        return on;
    }
}

