/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import de.schlichtherle.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Data;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.daq.utilities.FitsService;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.rafts.RaftsCommands;
import org.lsst.ccs.subsystem.rafts.RaftsMain;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2Model;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2ModelBuilder;

public class ATSFileWritingTest
extends CcsTestCaseTemplate {
    private static Subsystem testSubsystem = null;
    private static RaftsMain raftsMain = null;
    private static FitsService fitsService;

    @BeforeClass
    public static void createSubsystem() throws Exception {
        System.setProperty("org.lsst.ccs.config.WriterProvier", "");
        System.setProperty("org.lsst.ccs.run.mode", "simulation");
        System.setProperty("org.lsst.ccs.drivers.reb.sim.REBType", "WREB");
        testSubsystem = BootUtils.getSubsystemFromFile((String)"ats-wreb", (String)"Rafts:test");
        testSubsystem.startAgent();
        Assert.assertTrue((boolean)((AgentStateService)testSubsystem.getAgentService(AgentStateService.class)).waitFor(b -> b.isInState((Enum)ConfigurationState.CONFIGURED), 10L, TimeUnit.SECONDS));
        raftsMain = (RaftsMain)testSubsystem.getComponentLookup().getComponentByPath("main");
        Assert.assertNotNull((Object)raftsMain);
    }

    @AfterClass
    public static void shutdownSubsystem() throws Exception {
        testSubsystem.shutdownAgent();
        System.setProperty("org.lsst.ccs.run.mode", "");
        System.setProperty("org.lsst.ccs.drivers.reb.sim.REBType", "");
    }

    @Test
    public void testWriteFitsFiles() throws Exception {
        String sequencerFile = "ats_20180511.seq";
        double exptime = 1.0;
        String tmpDir = System.getProperty("java.io.tmpdir");
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("ats_20180511.seq");
        Assert.assertNotNull((String)"Sequencer missing", (Object)inputStream);
        FPGA2ModelBuilder builder = new FPGA2ModelBuilder();
        FPGA2Model model = builder.compileFile(inputStream);
        RaftsCommands raftsCommands = raftsMain.getRaftsCommands();
        raftsCommands.loadCompiledSequencer(model, "ats_20180511.seq");
        Assert.assertEquals(Collections.singletonList(2048), (Object)raftsCommands.getSequencerParameter("ReadRows"));
        Assert.assertEquals(Collections.singletonList(576), (Object)raftsCommands.getSequencerParameter("ReadCols"));
        raftsCommands.setSequencerStart("ReadFrame");
        raftsCommands.setExposureTime(1.0);
        ImageName imageName = raftsCommands.acquireLSSTImage();
        raftsCommands.waitForImage(10000);
        List saveFitsImage = raftsCommands.saveFitsImage(tmpDir);
        Assert.assertEquals((long)1L, (long)saveFitsImage.size());
        Assert.assertTrue((String)"File name error", (boolean)((String)saveFitsImage.get(0)).contains(imageName + ".fits"));
        this.checkFitsFile(tmpDir, (String)saveFitsImage.get(0), "ats_20180511.seq", 1.0, imageName);
    }

    private void checkFitsFile(String dir, String fileName, String sequencerFile, double exptime, ImageName imageName) throws FitsException, IOException {
        System.out.println(fileName);
        Fits fits = new Fits(String.join((CharSequence)File.separator, dir, fileName));
        BasicHDU hdu = fits.getHDU(0);
        Header primaryHeader = hdu.getHeader();
        this.checkPrimaryHeader(sequencerFile, primaryHeader, fileName, imageName);
        for (int i = 0; i < 16; ++i) {
            this.checkImageExtension((BasicHDU<? extends Data>)fits.getHDU(i + 1), i);
        }
    }

    private void checkPrimaryHeader(String sequencerFile, Header primaryHeader, String fileName, ImageName imageName) {
        Assert.assertEquals((Object)sequencerFile, (Object)primaryHeader.getStringValue("SEQFILE"));
        Assert.assertEquals((Object)"ITL", (Object)primaryHeader.getStringValue("CCD_MANU"));
        Assert.assertEquals((Object)"3800C", (Object)primaryHeader.getStringValue("CCD_TYPE"));
        Assert.assertEquals((Object)"[1:4072,1:4000]", (Object)primaryHeader.getStringValue("DETSIZE"));
        Assert.assertEquals((double)1.0, (double)primaryHeader.getFloatValue("EXPTIME"), (double)0.001);
        Assert.assertEquals((Object)fileName, (Object)primaryHeader.getStringValue("FILENAME"));
        Assert.assertEquals((Object)imageName.getController().getCode(), (Object)primaryHeader.getStringValue("CONTRLLR"));
        Assert.assertEquals((Object)imageName.getSource().getCode(), (Object)primaryHeader.getStringValue("TELCODE"));
        Assert.assertEquals((Object)imageName.getDateString(), (Object)primaryHeader.getStringValue("DAYOBS"));
        Assert.assertEquals((long)imageName.getNumber(), (long)primaryHeader.getIntValue("SEQNUM"));
    }

    private void checkImageExtension(BasicHDU<? extends Data> hdu, int index) throws FitsException {
        Header header = hdu.getHeader();
        Assert.assertEquals((long)576L, (long)hdu.getAxes()[1]);
        Assert.assertEquals((long)2048L, (long)hdu.getAxes()[0]);
        String[] segmentName = new String[]{"Segment10", "Segment11", "Segment12", "Segment13", "Segment14", "Segment15", "Segment16", "Segment17", "Segment07", "Segment06", "Segment05", "Segment04", "Segment03", "Segment02", "Segment01", "Segment00"};
        Assert.assertEquals((Object)segmentName[index], (Object)header.getStringValue("EXTNAME"));
        Assert.assertEquals((Object)"[1:4072,1:4000]", (Object)header.getStringValue("DETSIZE"));
    }
}

