/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import java.awt.Dimension;
import org.lsst.ccs.utilities.ccd.E2VCCDType;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.RaftGeometryConstants;

public class FocalPlane
extends Geometry<Raft> {
    private static final int GAP_BETWEEN_RAFTS = 50;
    private static final int S_BAYS = 5;
    private static final int P_BAYS = 5;
    private static final RaftGeometryConstants RAFT_GEOMETRY_CONSTANTS = RaftGeometryConstants.createRaftGeometryConstants(new E2VCCDType());

    public FocalPlane() {
        super("FocalPlane", new Dimension(5 * RAFT_GEOMETRY_CONSTANTS.getRaftx() + 200, 5 * RAFT_GEOMETRY_CONSTANTS.getRafty() + 200), 5, 5);
    }

    @Override
    protected void addGeometryToGrid(Raft child, int p, int s) {
        int yCoord = s * (child.getHeight() + 50);
        int xCoord = p * (child.getWidth() + 50);
        this.addGeometry(child, xCoord, yCoord);
    }
}

