/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.config.BulkValidationException;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;
import org.lsst.ccs.drivers.reb.BoardDacs;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.monitor.Control;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.config.DACS;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.utilities.logging.Logger;

public class DacControl
extends Control
implements ConfigurationBulkChangeHandler {
    public static final String SCLK_LOW_P = "sclkLowP";
    public static final String SCLK_HIGH_P = "sclkHighP";
    public static final String PCLK_LOW_P = "pclkLowP";
    public static final String PCLK_HIGH_P = "pclkHighP";
    public static final String RG_LOW_P = "rgLowP";
    public static final String RG_HIGH_P = "rgHighP";
    public static final String SCLK_LOW = "sclkLow";
    public static final String SCLK_LOW_SH = "sclkLowSh";
    public static final String SCLK_HIGH = "sclkHigh";
    public static final String SCLK_HIGH_SH = "sclkHighSh";
    public static final String PCLK_LOW = "pclkLow";
    public static final String PCLK_LOW_SH = "pclkLowSh";
    public static final String PCLK_HIGH = "pclkHigh";
    public static final String PCLK_HIGH_SH = "pclkHighSh";
    public static final String RG_LOW = "rgLow";
    public static final String RG_LOW_SH = "rgLowSh";
    public static final String RG_HIGH = "rgHigh";
    public static final String RG_HIGH_SH = "rgHighSh";
    public static final String CS_GATE = "csGate";
    private static final int SCLK_LOW_CH = 1;
    private static final int SCLK_LOW_SH_CH = 2;
    private static final int SCLK_HIGH_CH = 4;
    private static final int SCLK_HIGH_SH_CH = 8;
    private static final int PCLK_LOW_CH = 16;
    private static final int PCLK_LOW_SH_CH = 32;
    private static final int PCLK_HIGH_CH = 64;
    private static final int PCLK_HIGH_SH_CH = 128;
    private static final int RG_LOW_CH = 256;
    private static final int RG_LOW_SH_CH = 512;
    private static final int RG_HIGH_CH = 1024;
    private static final int RG_HIGH_SH_CH = 2048;
    private static final int CS_GATE_CH = 4096;
    private static final String[] checkList = new String[]{"sclkLow", "sclkHigh", "pclkLow", "pclkHigh", "rgLow", "rgHigh"};
    private static final double DAC_TOLERANCE = 0.4;
    private static final int DEFAULT_LOAD_WAIT = 200;
    private static final int DEFAULT_CLEAR_WAIT = 50;
    private static final double TEST_VOLTS = 0.5;
    private static final double ZERO_ERROR = 0.2;
    private static final double VALUE_ERROR = 0.2;
    private static final double CHANGE_ERROR = 0.1;
    private static final double CLK_SHORTS_LIMIT = 0.002;
    private static final Map<Integer, Integer> seqLineMap = new HashMap<Integer, Integer>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService sce;
    @ConfigurationParameter(category="Rafts", description="Serial clock low", units="volts")
    private double sclkLowP;
    @ConfigurationParameter(category="Rafts", description="Serial clock high", units="volts")
    private double sclkHighP;
    @ConfigurationParameter(category="Rafts", description="Parallel clock low", units="volts")
    private double pclkLowP;
    @ConfigurationParameter(category="Rafts", description="Parallel clock high", units="volts")
    private double pclkHighP;
    @ConfigurationParameter(category="Rafts", description="Reset gate low", units="volts")
    private double rgLowP;
    @ConfigurationParameter(category="Rafts", description="Reset gate high", units="volts")
    private double rgHighP;
    @ConfigurationParameter(category="RaftsLimits", description="Serial clock low min", units="volts")
    private double sclkLowMin;
    @ConfigurationParameter(category="RaftsLimits", description="Serial clock low max", units="volts")
    private double sclkLowMax;
    @ConfigurationParameter(category="RaftsLimits", description="Serial clock high min", units="volts")
    private double sclkHighMin;
    @ConfigurationParameter(category="RaftsLimits", description="Serial clock high max", units="volts")
    private double sclkHighMax;
    @ConfigurationParameter(category="RaftsLimits", description="Parallel clock low min", units="volts")
    private double pclkLowMin;
    @ConfigurationParameter(category="RaftsLimits", description="Parallel clock low max", units="volts")
    private double pclkLowMax;
    @ConfigurationParameter(category="RaftsLimits", description="Parallel clock high min", units="volts")
    private double pclkHighMin;
    @ConfigurationParameter(category="RaftsLimits", description="Parallel clock high max", units="volts")
    private double pclkHighMax;
    @ConfigurationParameter(category="RaftsLimits", description="Reset gate low min", units="volts")
    private double rgLowMin;
    @ConfigurationParameter(category="RaftsLimits", description="Reset gate low max", units="volts")
    private double rgLowMax;
    @ConfigurationParameter(category="RaftsLimits", description="Reset gate high min", units="volts")
    private double rgHighMin;
    @ConfigurationParameter(category="RaftsLimits", description="Reset gate high max", units="volts")
    private double rgHighMax;
    @ConfigurationParameter(category="Rafts", description="Serial clock low", units="DAC counts")
    private int sclkLow;
    @ConfigurationParameter(category="Rafts", description="Serial clock low shifted", units="DAC counts")
    private int sclkLowSh;
    @ConfigurationParameter(category="Rafts", description="Serial clock high", units="DAC counts")
    private int sclkHigh;
    @ConfigurationParameter(category="Rafts", description="Serial clock high shifted", units="DAC counts")
    private int sclkHighSh;
    @ConfigurationParameter(category="Rafts", description="Parallel clock low", units="DAC counts")
    private int pclkLow;
    @ConfigurationParameter(category="Rafts", description="Parallel clock low shifted", units="DAC counts")
    private int pclkLowSh;
    @ConfigurationParameter(category="Rafts", description="Parallel clock high", units="DAC counts")
    private int pclkHigh;
    @ConfigurationParameter(category="Rafts", description="Parallel clock high shifted", units="DAC counts")
    private int pclkHighSh;
    @ConfigurationParameter(category="Rafts", description="Reset gate low", units="DAC counts")
    private int rgLow;
    @ConfigurationParameter(category="Rafts", description="Reset gate low shifted", units="DAC counts")
    private int rgLowSh;
    @ConfigurationParameter(category="Rafts", description="Reset gate high", units="DAC counts")
    private int rgHigh;
    @ConfigurationParameter(category="Rafts", description="Reset gate high shifted", units="DAC counts")
    private int rgHighSh;
    @ConfigurationParameter(category="Rafts", description="Current source", units="DAC counts")
    private final int[] csGate = new int[3];
    @ConfigurationParameter(category="RaftsPower", description="Shorts Test Voltage for SClkL", units="Volts")
    private double sclkLowTestV;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for 0V w/SClkL test", units="Volts")
    private double sclkLowZeroErr;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for SClkL TestV", units="Volts")
    private double sclkLowValueErr;
    @ConfigurationParameter(category="RaftsPower", description="Shorts Test Voltage for SClkU", units="Volts")
    private double sclkHighTestV;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for 0V w/SClkU test", units="Volts")
    private double sclkHighZeroErr;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for SClkU TestV", units="Volts")
    private double sclkHighValueErr;
    @ConfigurationParameter(category="RaftsPower", description="Shorts Test Voltage for PClkL", units="Volts")
    private double pclkLowTestV;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for 0V w/PClkL test", units="Volts")
    private double pclkLowZeroErr;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for PClkL TestV", units="Volts")
    private double pclkLowValueErr;
    @ConfigurationParameter(category="RaftsPower", description="Shorts Test Voltage for PClkU", units="Volts")
    private double pclkHighTestV;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for 0V w/PClkU test", units="Volts")
    private double pclkHighZeroErr;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for PClkU TestV", units="Volts")
    private double pclkHighValueErr;
    @ConfigurationParameter(category="RaftsPower", description="Shorts Test Voltage for RGL", units="Volts")
    private double rgLowTestV;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for 0V w/RGL test", units="Volts")
    private double rgLowZeroErr;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for RGL TestV", units="Volts")
    private double rgLowValueErr;
    @ConfigurationParameter(category="RaftsPower", description="Shorts Test Voltage for RGU", units="Volts")
    private double rgHighTestV;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for 0V w/RGU test", units="Volts")
    private double rgHighZeroErr;
    @ConfigurationParameter(category="RaftsPower", description="Tolerance for RGU TestV", units="Volts")
    private double rgHighValueErr;
    @ConfigurationParameter(category="RaftsPower", description="Serial clock low tolerance", units="volts")
    private double sclkLowTol;
    @ConfigurationParameter(category="RaftsPower", description="Serial clock low offset", units="volts")
    private double sclkLowOff;
    @ConfigurationParameter(category="RaftsPower", description="Serial clock high tolerance", units="volts")
    private double sclkHighTol;
    @ConfigurationParameter(category="RaftsPower", description="Serial clock high offset", units="volts")
    private double sclkHighOff;
    @ConfigurationParameter(category="RaftsPower", description="Parallel clock low tolerance", units="volts")
    private double pclkLowTol;
    @ConfigurationParameter(category="RaftsPower", description="Parallel clock low offset", units="volts")
    private double pclkLowOff;
    @ConfigurationParameter(category="RaftsPower", description="Parallel clock high tolerance", units="volts")
    private double pclkHighTol;
    @ConfigurationParameter(category="RaftsPower", description="Parallel clock high offset", units="volts")
    private double pclkHighOff;
    @ConfigurationParameter(category="RaftsPower", description="Reset gate low tolerance", units="volts")
    private double rgLowTol;
    @ConfigurationParameter(category="RaftsPower", description="Reset gate low offset", units="volts")
    private double rgLowOff;
    @ConfigurationParameter(category="RaftsPower", description="Reset gate high tolerance", units="volts")
    private double rgHighTol;
    @ConfigurationParameter(category="RaftsPower", description="Reset gate high offset", units="volts")
    private double rgHighOff;
    @ConfigurationParameter(category="RaftsPower", description="Max ClkHI value", units="Amps")
    private double clkhIMax;
    @ConfigurationParameter(category="RaftsPower", description="Max ClkLI value", units="Amps")
    private double clklIMax;
    private boolean raw = false;
    private static final Logger LOG;
    private boolean cfgValid;
    private boolean isCurrent;
    private boolean isCorner;
    private int hwVersion;
    private REBDevice rebDevc;
    private BoardDacs dac;
    private int changed = -1;
    private final Map<String, Double> lowLimitMap = new HashMap<String, Double>();
    private final Map<String, Double> highLimitMap = new HashMap<String, Double>();
    private double railShiftConvH;
    private double railConvH;
    private double railShiftConvL;
    private double railConvL;
    private int adcType;

    public DacControl() {
        for (String pName : checkList) {
            this.lowLimitMap.put(pName, 0.0);
            this.highLimitMap.put(pName, 0.0);
        }
    }

    protected void configure(Monitor mon, Device devc) {
        super.configure(mon, devc);
        this.rebDevc = (REBDevice)devc;
        this.dac = this.rebDevc.getBoardDacs();
    }

    public boolean checkConfig() {
        this.hwVersion = DacControl.getHwVersion(this.dac);
        this.isCurrent = this.hwVersion >= 1;
        boolean bl = this.isCorner = this.hwVersion == 1 || this.hwVersion == 3;
        if (!this.raw) {
            double shiftGainH = this.hwVersion == 1 ? 2.0 : 2.4899999999999998;
            double shiftGainL = this.hwVersion == 2 ? 2.4677898909811695 : shiftGainH;
            double fudge = this.hwVersion == 1 ? 1.0 : 1.04;
            this.railShiftConvH = fudge * 819.0 / shiftGainH;
            this.railConvH = fudge * 819.0 / (1.0 + shiftGainH);
            this.railShiftConvL = fudge * 819.0 / shiftGainL;
            this.railConvL = fudge * 819.0 / (1.0 + shiftGainL);
        } else {
            this.cfgValid = true;
        }
        this.adcType = this.isCorner ? 6 : 4;
        return true;
    }

    public boolean isRaw() {
        return this.raw;
    }

    public static int getHwVersion(BoardDacs dac) {
        int version = dac.getVersion();
        version = version == 0 || version == 1 ? 0 : (version == 2 || version == 4 || version == 5 ? 1 : (version == 3 || version == 6 ? 2 : (version == 7 || version == 8 ? 3 : -1)));
        return version;
    }

    @Deprecated
    public int getHwVersion() {
        return this.hwVersion;
    }

    public void validateBulkChange(Map<String, Object> params) throws IllegalArgumentException {
        String errMsg = null;
        if (!this.raw) {
            for (String pName : checkList) {
                double max;
                double value = (Double)params.get(pName + "P");
                if (value > (max = ((Double)params.get(pName + "Max")).doubleValue())) {
                    errMsg = String.format("%s: %sP (%5.5g) is above high limit (%5.5g)", this.getName(), pName, value, max);
                    break;
                }
                double min = (Double)params.get(pName + "Min");
                if (!(value < min)) continue;
                errMsg = String.format("%s: %sP (%5.5g) is below low limit (%5.5g)", this.getName(), pName, value, min);
                break;
            }
        }
        if (errMsg != null) {
            LOG.severe((Object)("Configuration failure: " + errMsg));
            throw new IllegalArgumentException(errMsg);
        }
        this.cfgValid = true;
    }

    @ConfigurationParameterChanger
    public void setPclkLowP(double value) {
        this.pclkLowP = value;
        this.changed |= 0x10;
    }

    public double getPclkLowP() {
        return this.pclkLowP;
    }

    @ConfigurationParameterChanger
    public void setPclkLowMax(double value) {
        this.pclkLowMax = value;
        this.highLimitMap.put(PCLK_LOW, value);
    }

    @ConfigurationParameterChanger
    public void setPclkLowMin(double value) {
        this.pclkLowMin = value;
        this.lowLimitMap.put(PCLK_LOW, value);
    }

    @ConfigurationParameterChanger
    public void setPclkLow(int value) {
        this.pclkLow = value;
        this.changed |= 0x10;
    }

    public int getPclkLow() {
        return this.pclkLow;
    }

    @ConfigurationParameterChanger
    public void setPclkLowSh(int value) {
        this.pclkLowSh = value;
        this.changed |= 0x20;
    }

    public int getPclkLowSh() {
        return this.pclkLowSh;
    }

    @ConfigurationParameterChanger
    public void setPclkHighP(double value) {
        this.pclkHighP = value;
        this.changed |= 0x40;
    }

    public double getPclkHighP() {
        return this.pclkHighP;
    }

    @ConfigurationParameterChanger
    public void setPclkHighMax(double value) {
        this.pclkHighMax = value;
        this.highLimitMap.put(PCLK_HIGH, value);
    }

    @ConfigurationParameterChanger
    public void setPclkHighMin(double value) {
        this.pclkHighMin = value;
        this.lowLimitMap.put(PCLK_HIGH, value);
    }

    @ConfigurationParameterChanger
    public void setPclkHigh(int value) {
        this.pclkHigh = value;
        this.changed |= 0x40;
    }

    public int getPclkHigh() {
        return this.pclkHigh;
    }

    @ConfigurationParameterChanger
    public void setPclkHighSh(int value) {
        this.pclkHighSh = value;
        this.changed |= 0x80;
    }

    public int getPclkHighSh() {
        return this.pclkHighSh;
    }

    @ConfigurationParameterChanger
    public void setSclkLowP(double value) {
        this.sclkLowP = value;
        this.changed |= 1;
    }

    public double getSclkLowP() {
        return this.sclkLowP;
    }

    @ConfigurationParameterChanger
    public void setSclkLowMax(double value) {
        this.sclkLowMax = value;
        this.highLimitMap.put(SCLK_LOW, value);
    }

    @ConfigurationParameterChanger
    public void setSclkLowMin(double value) {
        this.sclkLowMin = value;
        this.lowLimitMap.put(SCLK_LOW, value);
    }

    @ConfigurationParameterChanger
    public void setSclkLow(int value) {
        this.sclkLow = value;
        this.changed |= 1;
    }

    public int getSclkLow() {
        return this.sclkLow;
    }

    @ConfigurationParameterChanger
    public void setSclkLowSh(int value) {
        this.sclkLowSh = value;
        this.changed |= 2;
    }

    public int getSclkLowSh() {
        return this.sclkLowSh;
    }

    @ConfigurationParameterChanger
    public void setSclkHighP(double value) {
        this.sclkHighP = value;
        this.changed |= 4;
    }

    public double getSclkHighP() {
        return this.sclkHighP;
    }

    @ConfigurationParameterChanger
    public void setSclkHighMax(double value) {
        this.sclkHighMax = value;
        this.highLimitMap.put(SCLK_HIGH, value);
    }

    @ConfigurationParameterChanger
    public void setSclkHighMin(double value) {
        this.sclkHighMin = value;
        this.lowLimitMap.put(SCLK_HIGH, value);
    }

    @ConfigurationParameterChanger
    public void setSclkHigh(int value) {
        this.sclkHigh = value;
        this.changed |= 4;
    }

    public int getSclkHigh() {
        return this.sclkHigh;
    }

    @ConfigurationParameterChanger
    public void setSclkHighSh(int value) {
        this.sclkHighSh = value;
        this.changed |= 8;
    }

    public int getSclkHighSh() {
        return this.sclkHighSh;
    }

    @ConfigurationParameterChanger
    public void setRgLowP(double value) {
        this.rgLowP = value;
        this.changed |= 0x100;
    }

    public double getRgLowP() {
        return this.rgLowP;
    }

    @ConfigurationParameterChanger
    public void setRgLowMax(double value) {
        this.rgLowMax = value;
        this.highLimitMap.put(RG_LOW, value);
    }

    @ConfigurationParameterChanger
    public void setRgLowMin(double value) {
        this.rgLowMin = value;
        this.lowLimitMap.put(RG_LOW, value);
    }

    @ConfigurationParameterChanger
    public void setRgLow(int value) {
        this.rgLow = value;
        this.changed |= 0x100;
    }

    public int getRgLow() {
        return this.rgLow;
    }

    @ConfigurationParameterChanger
    public void setRgLowSh(int value) {
        this.rgLowSh = value;
        this.changed |= 0x200;
    }

    public int getRgLowSh() {
        return this.rgLowSh;
    }

    @ConfigurationParameterChanger
    public void setRgHighP(double value) {
        this.rgHighP = value;
        this.changed |= 0x400;
    }

    public double getRgHighP() {
        return this.rgHighP;
    }

    @ConfigurationParameterChanger
    public void setRgHighMax(double value) {
        this.rgHighMax = value;
        this.highLimitMap.put(RG_HIGH, value);
    }

    @ConfigurationParameterChanger
    public void setRgHighMin(double value) {
        this.rgHighMin = value;
        this.lowLimitMap.put(RG_HIGH, value);
    }

    @ConfigurationParameterChanger
    public void setRgHigh(int value) {
        this.rgHigh = value;
        this.changed |= 0x400;
    }

    public int getRgHigh() {
        return this.rgHigh;
    }

    @ConfigurationParameterChanger
    public void setRgHighSh(int value) {
        this.rgHighSh = value;
        this.changed |= 0x800;
    }

    public int getRgHighSh() {
        return this.rgHighSh;
    }

    @ConfigurationParameterChanger
    public void setCsGate(int[] value) {
        System.arraycopy(value, 0, this.csGate, 0, this.csGate.length);
        this.changed |= 0x1000;
    }

    public int[] getCsGate() {
        return this.csGate;
    }

    void setConfig(DACS dacs) throws RaftException {
        String name = this.getName();
        if (!this.raw) {
            double[] values = dacs.getPValues();
            this.sce.submitChange(name, RG_HIGH_P, (Object)values[5]);
            this.sce.submitChange(name, RG_LOW_P, (Object)values[4]);
            this.sce.submitChange(name, PCLK_HIGH_P, (Object)values[3]);
            this.sce.submitChange(name, PCLK_LOW_P, (Object)values[2]);
            this.sce.submitChange(name, SCLK_HIGH_P, (Object)values[1]);
            this.sce.submitChange(name, SCLK_LOW_P, (Object)values[0]);
        } else {
            int[] values = dacs.getValues();
            this.sce.submitChange(name, RG_HIGH, (Object)values[5]);
            this.sce.submitChange(name, RG_LOW, (Object)values[4]);
            this.sce.submitChange(name, PCLK_HIGH, (Object)values[3]);
            this.sce.submitChange(name, PCLK_LOW, (Object)values[2]);
            this.sce.submitChange(name, SCLK_HIGH, (Object)values[1]);
            this.sce.submitChange(name, SCLK_LOW, (Object)values[0]);
            if (this.isCurrent) {
                this.sce.submitChange(name, RG_LOW_SH, (Object)values[10]);
                this.sce.submitChange(name, PCLK_LOW_SH, (Object)values[8]);
                this.sce.submitChange(name, SCLK_LOW_SH, (Object)values[6]);
                if (this.isCorner) {
                    this.sce.submitChange(name, RG_HIGH_SH, (Object)values[11]);
                    this.sce.submitChange(name, PCLK_HIGH_SH, (Object)values[9]);
                    this.sce.submitChange(name, SCLK_HIGH_SH, (Object)values[7]);
                }
            } else {
                this.sce.submitChange(name, CS_GATE, (Object)new int[]{values[12], values[13], values[14]});
            }
        }
        try {
            this.sce.commitBulkChange();
        }
        catch (BulkValidationException e) {
            this.sce.dropSubmittedChangesForComponent(name);
            throw new RaftException("Bulk configuration validation failed");
        }
    }

    void getConfig(DACS dacs) {
        if (!this.raw) {
            double[] values = dacs.getPValues();
            values[5] = this.rgHighP;
            values[4] = this.rgLowP;
            values[3] = this.pclkHighP;
            values[2] = this.pclkLowP;
            values[1] = this.sclkHighP;
            values[0] = this.sclkLowP;
        } else {
            int[] values = dacs.getValues();
            values[5] = this.rgHigh;
            values[4] = this.rgLow;
            values[3] = this.pclkHigh;
            values[2] = this.pclkLow;
            values[1] = this.sclkHigh;
            values[0] = this.sclkLow;
            if (this.isCurrent) {
                values[10] = this.rgLowSh;
                values[8] = this.pclkLowSh;
                values[6] = this.sclkLowSh;
                if (this.isCorner) {
                    values[11] = this.rgHighSh;
                    values[9] = this.pclkHighSh;
                    values[7] = this.sclkHighSh;
                }
            } else {
                values[12] = this.csGate[0];
                values[13] = this.csGate[1];
                values[14] = this.csGate[2];
            }
        }
    }

    public int loadConfig(boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        return this.loadConfig(200, check, dataList);
    }

    public int loadConfig(int wait, boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        if (!this.cfgValid) {
            throw new RaftException("DAC load error: invalid configuration");
        }
        if (!this.rebDevc.isSerialNumValid()) {
            throw new RaftException("DAC load error: invalid REB serial number");
        }
        int count = 0;
        this.rebDevc.readAllAdcs(dataList);
        count += this.loadSclkLow(wait, check, dataList);
        count += this.loadSclkHigh(wait, check, dataList);
        count += this.loadPclkLow(wait, check, dataList);
        count += this.loadPclkHigh(wait, check, dataList);
        count += this.loadRgLow(wait, check, dataList);
        count += this.loadRgHigh(wait, check, dataList);
        if (!this.isCurrent) {
            this.setDac(17, this.csGate[0]);
            this.setDac(19, this.csGate[1]);
            this.setDac(20, this.csGate[2]);
            this.loadDac(0);
            count += 3;
            this.rebDevc.readAllAdcs(dataList);
        }
        this.changed = 0;
        return count;
    }

    public int loadChanged(boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        return this.loadChanged(200, check, dataList);
    }

    public int loadChanged(int wait, boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        if (!this.cfgValid) {
            throw new RaftException("DAC load error: invalid configuration");
        }
        if (!this.rebDevc.isSerialNumValid()) {
            throw new RaftException("DAC load error: invalid REB serial number");
        }
        int count = 0;
        this.rebDevc.readAllAdcs(dataList);
        if ((this.changed & 1) != 0) {
            count += this.loadSclkLow(wait, check, dataList);
        }
        if ((this.changed & 4) != 0) {
            count += this.loadSclkHigh(wait, check, dataList);
        }
        if ((this.changed & 0x10) != 0) {
            count += this.loadPclkLow(wait, check, dataList);
        }
        if ((this.changed & 0x40) != 0) {
            count += this.loadPclkHigh(wait, check, dataList);
        }
        if ((this.changed & 0x100) != 0) {
            count += this.loadRgLow(wait, check, dataList);
        }
        if ((this.changed & 0x400) != 0) {
            count += this.loadRgHigh(wait, check, dataList);
        }
        if (!this.isCurrent && (this.changed & 0x1000) != 0) {
            this.setDac(17, this.csGate[0]);
            this.setDac(19, this.csGate[1]);
            this.setDac(20, this.csGate[2]);
            this.loadDac(0);
            count += 3;
            this.rebDevc.readAllAdcs(dataList);
        }
        this.changed = 0;
        return count;
    }

    public void clear(List<REBDevice.AdcData> dataList) throws RaftException {
        this.clear(50, dataList);
    }

    public void clear(int wait, List<REBDevice.AdcData> dataList) throws RaftException {
        this.clearRgLow(wait);
        this.clearRgHigh(wait);
        this.clearPclkLow(wait);
        this.clearPclkHigh(wait);
        this.clearSclkLow(wait);
        this.clearSclkHigh(wait);
        if (!this.isCurrent) {
            this.setDac(17, 0);
            this.setDac(19, 0);
            this.setDac(20, 0);
            this.loadDac(0);
        }
        this.changed = -1;
        this.rebDevc.readAllAdcs(dataList);
    }

    public boolean testShorts(List<REBDevice.AdcData> dataList, StringBuilder fcause) throws RaftException {
        boolean failed = false;
        failed = this.testShorts(2, 0, 3, 2, this.sclkHighTestV, this.sclkHighValueErr, this.sclkHighZeroErr, this.sclkLowTestV, this.sclkLowValueErr, this.sclkLowZeroErr, dataList, fcause);
        failed |= this.testShorts(10, 8, 1, 0, this.pclkHighTestV, this.pclkHighValueErr, this.pclkHighZeroErr, this.pclkLowTestV, this.pclkLowValueErr, this.pclkLowZeroErr, dataList, fcause);
        return failed |= this.testShorts(6, 4, 5, 4, this.rgHighTestV, this.rgHighValueErr, this.rgHighZeroErr, this.rgLowTestV, this.rgLowValueErr, this.rgLowZeroErr, dataList, fcause);
    }

    private boolean testShorts(int dacUp, int dacLo, int adcUp, int adcLo, double adcUpTestV, double adcUpValueErr, double adcUpZeroErr, double adcLoTestV, double adcLoValueErr, double adcLoZeroErr, List<REBDevice.AdcData> dataList, StringBuilder fcause) throws RaftException {
        int seqState = this.rebDevc.readSeqIdleState();
        long tstamp = this.rebDevc.getTime();
        LOG.fine((Object)String.format("%d SeqIdleState= %#x", tstamp, seqState));
        this.rebDevc.readSlowAdcs(dataList);
        double[] origPower = this.rebDevc.readPowerAdcs(dataList);
        tstamp = this.rebDevc.getTime();
        LOG.fine((Object)String.format("%d initial reading done", tstamp));
        int savedState = this.rebDevc.readSeqIdleState();
        this.rebDevc.writeSeqIdleState(savedState & ~seqLineMap.get(adcLo).intValue());
        seqState = this.rebDevc.readSeqIdleState();
        tstamp = this.rebDevc.getTime();
        LOG.fine((Object)String.format("%d %s sequencer lines set to low: SeqIdleState= %#x", tstamp, REBDevice.getAdcName(adcLo), seqState));
        this.setDac(dacUp, 0);
        this.setDac(dacLo, 0);
        this.loadDac(50);
        this.rebDevc.readAllAdcs(dataList);
        tstamp = this.rebDevc.getTime();
        LOG.fine((Object)String.format("%d set both rails to 0", tstamp));
        LOG.fine((Object)String.format("%d %s,%s set to 0.0 with %d ms wait", tstamp, REBDevice.getAdcName(adcLo), REBDevice.getAdcName(adcUp), 50));
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        tstamp = this.rebDevc.getTime();
        LOG.fine((Object)String.format("%d settled for %d ms", tstamp, 50));
        double[] lowerPower = this.rebDevc.readPowerAdcs(dataList);
        double[] lowerAdcs = this.rebDevc.readSlowAdcs(dataList);
        tstamp = this.rebDevc.getTime();
        LOG.fine((Object)String.format("%d recorded lower values", tstamp));
        this.setDac(dacUp, (int)(this.railConvH * adcUpTestV));
        this.setDac(dacLo, (int)(this.railConvL * adcLoTestV));
        this.loadDac(200);
        tstamp = this.rebDevc.getTime();
        LOG.fine((Object)String.format("%d %s set to %.2f with %d ms wait", tstamp, REBDevice.getAdcName(adcLo), adcLoTestV, 200));
        LOG.fine((Object)String.format("%d %s set to %.2f with %d ms wait", tstamp, REBDevice.getAdcName(adcUp), adcUpTestV, 200));
        double[] upperPower = this.rebDevc.readPowerAdcs(dataList);
        double[] upperAdcs = this.rebDevc.readSlowAdcs(dataList);
        tstamp = this.rebDevc.getTime();
        LOG.fine((Object)String.format("%d recorded at test voltage", tstamp));
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.rebDevc.readAllAdcs(dataList);
        tstamp = this.rebDevc.getTime();
        LOG.fine((Object)String.format("%d pedestal reading", tstamp));
        this.setDac(dacUp, 0);
        this.setDac(dacLo, 0);
        this.loadDac(50);
        tstamp = this.rebDevc.getTime();
        LOG.fine((Object)String.format("%d set both rails to 0", tstamp));
        LOG.fine((Object)String.format("%d %s clock rails set to 0.0 with %d ms wait", tstamp, REBDevice.getAdcName(adcLo), 50));
        this.rebDevc.readAllAdcs(dataList);
        tstamp = this.rebDevc.getTime();
        LOG.fine((Object)String.format("%d final reading", tstamp));
        this.rebDevc.writeSeqIdleState(savedState);
        seqState = this.rebDevc.readSeqIdleState();
        tstamp = this.rebDevc.getTime();
        LOG.fine((Object)String.format("%d SeqIdleState= %#x", tstamp, seqState));
        return this.checkValues(adcUp, adcLo, adcUpTestV, adcUpValueErr, adcUpZeroErr, adcLoTestV, adcLoValueErr, adcLoZeroErr, lowerAdcs, upperAdcs, origPower, lowerPower, upperPower, fcause);
    }

    private boolean checkValues(int adcUp, int adcLo, double adcUpTestV, double adcUpValueErr, double adcUpZeroErr, double adcLoTestV, double adcLoValueErr, double adcLoZeroErr, double[] baseAdcs, double[] measAdcs, double[] origPower, double[] basePower, double[] measPower, StringBuilder fcause) {
        boolean failed = false;
        for (int ad = 0; ad < baseAdcs.length; ++ad) {
            double basevalue = baseAdcs[ad];
            double measvalue = measAdcs[ad];
            if (ad == adcUp) {
                if (Math.abs(basevalue) > adcUpZeroErr) {
                    fcause.append(String.format("%s %s baseline value (%.2f) is out of bounds (%.2f)\n", this.rebDevc.getName(), REBDevice.getAdcName(ad), basevalue, adcUpZeroErr));
                    failed = true;
                }
                if (!(Math.abs(measvalue - adcUpTestV) > adcUpValueErr)) continue;
                fcause.append(String.format("%s %s measured value (%.2f) is out of bounds (%.2f +/- %.2f)\n", this.rebDevc.getName(), REBDevice.getAdcName(ad), measvalue, adcUpTestV, adcUpValueErr));
                failed = true;
                continue;
            }
            if (ad == adcLo) {
                if (Math.abs(basevalue) > adcLoZeroErr) {
                    fcause.append(String.format("%s %s baseline value (%.2f) is out of bounds (%.2f)\n", this.rebDevc.getName(), REBDevice.getAdcName(ad), basevalue, adcLoZeroErr));
                    failed = true;
                }
                if (!(Math.abs(measvalue - adcLoTestV) > adcLoValueErr)) continue;
                fcause.append(String.format("%s %s measured value (%.2f) is out of bounds (%.2f +/- %.2f)\n", this.rebDevc.getName(), REBDevice.getAdcName(ad), measvalue, adcLoTestV, adcLoValueErr));
                failed = true;
                continue;
            }
            if (!(Math.abs(measvalue - basevalue) > adcLoZeroErr)) continue;
            fcause.append(String.format("%s %s change of (%.2f) is out of bounds (+/- %.2f)\n", this.rebDevc.getName(), REBDevice.getAdcName(ad), measvalue - basevalue, 0.1));
            failed = true;
        }
        if (basePower[5] > origPower[5] + 0.002) {
            fcause.append(String.format("%s ClkHi base current increased excessively from %.2f mA to %.2f mA while testing %s\n", this.rebDevc.getName(), 1000.0 * origPower[5], 1000.0 * basePower[5], REBDevice.getAdcName(adcUp)));
            failed = true;
        }
        if (measPower[5] > basePower[5] + 0.002) {
            fcause.append(String.format("%s ClkHi meas current increased excessively from %.2f mA to %.2f mA while testing %s\n", this.rebDevc.getName(), 1000.0 * basePower[5], 1000.0 * measPower[5], REBDevice.getAdcName(adcUp)));
            failed = true;
        }
        if (basePower[9] > origPower[9] + 0.002) {
            fcause.append(String.format("%s ClkLo base current increased excessively from %.2f mA to %.2f mA while testing %s\n", this.rebDevc.getName(), 1000.0 * origPower[9], 1000.0 * basePower[9], REBDevice.getAdcName(adcLo)));
            failed = true;
        }
        if (measPower[9] > basePower[9] + 0.002) {
            fcause.append(String.format("%s ClkLo meas current increased excessively from %.2f mA to %.2f mA while testing %s\n", this.rebDevc.getName(), 1000.0 * basePower[9], 1000.0 * measPower[9], REBDevice.getAdcName(adcLo)));
            failed = true;
        }
        return failed;
    }

    private int loadPclkLow(int wait, boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        int count = 1;
        if (!this.raw) {
            this.setDac(8, this.pclkLowP >= 0.0 ? (int)(this.railConvL * this.pclkLowP) : 0);
            this.setDac(9, this.pclkLowP <= 0.0 ? (int)(-this.railShiftConvL * this.pclkLowP) : 0);
            ++count;
            this.loadDac(wait);
            RaftException ex = this.checkAdc(0, dataList, check, this.pclkLowP, this.pclkLowOff, this.pclkLowTol);
            if (ex != null) {
                this.clearPclkLow(0);
                throw ex;
            }
        } else {
            this.setDac(8, this.pclkLow);
            if (this.isCurrent) {
                this.setDac(9, this.pclkLowSh);
                ++count;
            }
            this.loadDac(wait);
        }
        return count;
    }

    private int loadPclkHigh(int wait, boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        int count = 1;
        if (!this.raw) {
            this.setDac(10, this.pclkHighP >= 0.0 ? (int)(this.railConvH * this.pclkHighP) : 0);
            if (this.isCorner) {
                this.setDac(11, this.pclkHighP <= 0.0 ? (int)(-this.railShiftConvH * this.pclkHighP) : 0);
                ++count;
            }
            this.loadDac(wait);
            RaftException ex = this.checkAdc(1, dataList, this.isCorner ? false : check, this.pclkHighP, this.pclkHighOff, this.pclkHighTol);
            if (ex != null) {
                this.clearPclkHigh(0);
                throw ex;
            }
        } else {
            this.setDac(10, this.pclkHigh);
            if (this.isCorner) {
                this.setDac(11, this.pclkHighSh);
                ++count;
            }
            this.loadDac(wait);
        }
        return count;
    }

    private int loadSclkLow(int wait, boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        int count = 1;
        if (!this.raw) {
            this.setDac(0, this.sclkLowP >= 0.0 ? (int)(this.railConvL * this.sclkLowP) : 0);
            this.setDac(1, this.sclkLowP <= 0.0 ? (int)(-this.railShiftConvL * this.sclkLowP) : 0);
            ++count;
            this.loadDac(wait);
            RaftException ex = this.checkAdc(2, dataList, check, this.sclkLowP, this.sclkLowOff, this.sclkLowTol);
            if (ex != null) {
                this.clearSclkLow(0);
                throw ex;
            }
        } else {
            this.setDac(0, this.sclkLow);
            if (this.isCurrent) {
                this.setDac(1, this.sclkLowSh);
                ++count;
            }
            this.loadDac(wait);
        }
        return count;
    }

    private int loadSclkHigh(int wait, boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        int count = 1;
        if (!this.raw) {
            this.setDac(2, this.sclkHighP >= 0.0 ? (int)(this.railConvH * this.sclkHighP) : 0);
            if (this.isCorner) {
                this.setDac(3, this.sclkHighP <= 0.0 ? (int)(-this.railShiftConvH * this.sclkHighP) : 0);
                ++count;
            }
            this.loadDac(wait);
            RaftException ex = this.checkAdc(3, dataList, check, this.sclkHighP, this.sclkHighOff, this.sclkHighTol);
            if (ex != null) {
                this.clearSclkHigh(0);
                throw ex;
            }
        } else {
            this.setDac(2, this.sclkHigh);
            if (this.isCorner) {
                this.setDac(3, this.sclkHighSh);
                ++count;
            }
            this.loadDac(wait);
        }
        return count;
    }

    private int loadRgLow(int wait, boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        int count = 1;
        if (!this.raw) {
            this.setDac(4, this.rgLowP >= 0.0 ? (int)(this.railConvL * this.rgLowP) : 0);
            this.setDac(5, this.rgLowP <= 0.0 ? (int)(-this.railShiftConvL * this.rgLowP) : 0);
            ++count;
            this.loadDac(wait);
            RaftException ex = this.checkAdc(4, dataList, check, this.rgLowP, this.rgLowOff, this.rgLowTol);
            if (ex != null) {
                this.clearRgLow(0);
                throw ex;
            }
        } else {
            this.setDac(4, this.rgLow);
            if (this.isCurrent) {
                this.setDac(5, this.rgLowSh);
                ++count;
            }
            this.loadDac(wait);
        }
        return count;
    }

    private int loadRgHigh(int wait, boolean check, List<REBDevice.AdcData> dataList) throws RaftException {
        int count = 1;
        if (!this.raw) {
            this.setDac(6, this.rgHighP >= 0.0 ? (int)(this.railConvH * this.rgHighP) : 0);
            if (this.isCorner) {
                this.setDac(7, this.rgHighP <= 0.0 ? (int)(-this.railShiftConvH * this.rgHighP) : 0);
                ++count;
            }
            this.loadDac(wait);
            RaftException ex = this.checkAdc(5, dataList, check, this.rgHighP, this.rgHighOff, this.rgHighTol);
            if (ex != null) {
                this.clearRgHigh(0);
                throw ex;
            }
        } else {
            this.setDac(6, this.rgHigh);
            if (this.isCorner) {
                this.setDac(7, this.rgHighSh);
                ++count;
            }
            this.loadDac(wait);
        }
        return count;
    }

    private RaftException checkAdc(int adc, List<REBDevice.AdcData> dataList, boolean check, double setPoint, double adcOff, double adcTol) throws RaftException {
        StringBuilder exString = new StringBuilder();
        boolean failed = false;
        if (!check && dataList == null) {
            return null;
        }
        double[] adcValues = this.rebDevc.readSlowAdcs(dataList);
        double[] curPower = this.rebDevc.readPowerAdcs(dataList);
        if (check) {
            if (Math.abs(adcValues[adc] + adcOff - setPoint) > adcTol) {
                exString.append(String.format("\n%s %s out of range: setpt=%.2f, reading: %.2f, offset: %.2f, tol: %.2f", this.rebDevc.getName(), REBDevice.getAdcName(adc), setPoint, adcValues[adc], adcOff, adcTol));
                failed = true;
            }
            if (curPower[5] > this.clkhIMax) {
                exString.append(String.format("\n%s %s caused overcurrent on ClkHI: measured %.3f, limit: %.3f", this.rebDevc.getName(), REBDevice.getAdcName(adc), curPower[5], this.clkhIMax));
                failed = true;
            }
            if (curPower[9] > this.clklIMax) {
                exString.append(String.format("\n%s %s caused overcurrent on ClkHI: measured %.3f, limit: %.3f", this.rebDevc.getName(), REBDevice.getAdcName(adc), curPower[9], this.clklIMax));
                failed = true;
            }
        }
        if (failed) {
            return new RaftException(exString.toString());
        }
        return null;
    }

    private static boolean isValueOkay(double read, double set) {
        return Math.abs(read - set) <= 0.4;
    }

    private void clearPclkLow(int wait) throws RaftException {
        this.setDac(8, 0);
        if (this.isCurrent) {
            this.setDac(9, 0);
        }
        this.loadDac(wait);
    }

    private void clearPclkHigh(int wait) throws RaftException {
        this.setDac(10, 0);
        if (this.isCorner) {
            this.setDac(11, 0);
        }
        this.loadDac(wait);
    }

    private void clearSclkLow(int wait) throws RaftException {
        this.setDac(0, 0);
        if (this.isCurrent) {
            this.setDac(1, 0);
        }
        this.loadDac(wait);
    }

    private void clearSclkHigh(int wait) throws RaftException {
        this.setDac(2, 0);
        if (this.isCorner) {
            this.setDac(3, 0);
        }
        this.loadDac(wait);
    }

    private void clearRgLow(int wait) throws RaftException {
        this.setDac(4, 0);
        if (this.isCurrent) {
            this.setDac(5, 0);
        }
        this.loadDac(wait);
    }

    private void clearRgHigh(int wait) throws RaftException {
        this.setDac(6, 0);
        if (this.isCorner) {
            this.setDac(7, 0);
        }
        this.loadDac(wait);
    }

    private void setDac(int chan, int value) throws RaftException {
        this.testOnline();
        try {
            this.dac.set(chan, Math.max(0, Math.min(value, 4095)));
        }
        catch (REBException e) {
            throw new RaftException(e.getMessage());
        }
    }

    private void loadDac(int wait) throws RaftException {
        this.testOnline();
        try {
            this.dac.loadGlobal();
        }
        catch (REBException e) {
            throw new RaftException(e.getMessage());
        }
        try {
            Thread.sleep(wait);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        seqLineMap.put(0, 3840);
        seqLineMap.put(1, 0);
        seqLineMap.put(2, 112);
        seqLineMap.put(3, 0);
        seqLineMap.put(4, 128);
        seqLineMap.put(5, 0);
        LOG = Logger.getLogger((String)DacControl.class.getName());
    }
}

