/*
 * Decompiled with CFR 0.152.
 */
package jas.plot;

import jas.plot.AxisType;
import jas.plot.DataArea;
import jas.plot.DoubleAxis;
import jas.plot.EditableLabel;
import jas.plot.FontMenuItem;
import jas.plot.HasPopupItems;
import jas.plot.PlotComponent;
import jas.plot.PlotGraphics;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class Axis
extends PlotComponent
implements HasPopupItems {
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 2;
    private Color axisColor = null;
    private float axisWidth = 1.0f;
    private Color axisOriginDotColor = null;
    private Color majorTickMarkColor = null;
    private Color minorTickMarkColor = null;
    private Color textColor = null;
    private int axisOrientation;
    AxisType type;
    private final Point location = new Point();
    private final Dimension size = new Dimension();
    private boolean isVisible = false;
    boolean onLeftSide;
    private static FontMenuItem fontMenuItem = null;
    private int lastAxisLength = -1;
    static final int padAroundEdge = 3;
    static final int padFromAxis = 7;

    public Axis() {
        this(new DoubleAxis(), 1, true);
    }

    public Axis(AxisType type, int axisOrientation) {
        this(type, axisOrientation, true);
    }

    public Axis(int axisOrientation) {
        this(new DoubleAxis(), axisOrientation, true);
    }

    public Axis(int axisOrientation, boolean onLeftSide) {
        this(new DoubleAxis(), axisOrientation, onLeftSide);
    }

    public Axis(AxisType type, boolean onLeftSide) {
        this(type, 1, onLeftSide);
    }

    public Axis(AxisType type, int axisOrientation, boolean onLeftSide) {
        this.type = type;
        this.axisOrientation = axisOrientation;
        this.onLeftSide = onLeftSide;
        type.setAxis(this);
    }

    @Override
    public void modifyPopupMenu(JPopupMenu menu, Component source) {
        if (menu.getComponentCount() > 0) {
            menu.addSeparator();
        }
        menu.add(new FontMenuItem(this, "Axis"));
        final DataArea parent = (DataArea)SwingUtilities.getAncestorOfClass(DataArea.class, this);
        final EditableLabel label = parent.getLabel(this);
        menu.add(new JCheckBoxMenuItem("Show Axis Label", label != null){

            @Override
            protected final void fireActionPerformed(ActionEvent e) {
                if (this.isSelected()) {
                    EditableLabel newLabel = new EditableLabel("Label", "Axis Label");
                    parent.setLabel(Axis.this, newLabel);
                    newLabel.edit();
                } else {
                    parent.remove(label);
                }
            }
        });
        if (label != null) {
            menu.add(new JMenuItem("Edit label text"){

                @Override
                protected final void fireActionPerformed(ActionEvent e) {
                    label.edit();
                }
            });
        }
    }

    public final void setType(AxisType type) {
        this.type = type;
        type.setAxis(this);
        if (this.isVisible) {
            this.revalidate();
        }
    }

    @Override
    public final void setFont(Font font) {
        super.setFont(font);
        this.type.labelsValid = false;
        this.revalidate();
    }

    public final AxisType getType() {
        return this.type;
    }

    public final int getMinLocation() {
        if (this.axisOrientation == 1) {
            return this.size.height - this.type.spaceRequirements.height + this.location.y;
        }
        return this.type.spaceRequirements.width + this.location.x;
    }

    public final int getMaxLocation() {
        if (this.axisOrientation == 1) {
            return 3 + this.location.y + this.type.spaceRequirements.flowPastEnd;
        }
        return this.size.width - 3 + this.location.x - this.type.spaceRequirements.flowPastEnd;
    }

    final void paint(PlotGraphics g) {
        Point actualOrigin = new Point(this.onLeftSide ? this.type.spaceRequirements.width : this.size.width - this.type.spaceRequirements.width, this.size.height - this.type.spaceRequirements.height);
        actualOrigin.translate(this.location.x, this.location.y);
        g.setFont(this.getFont());
        int tickLength = this.type.getMajorTickMarkLength();
        if (this.axisOrientation == 1) {
            g.setColor(this.getAxisColor());
            BasicStroke s = new BasicStroke(this.getAxisWidth(), 2, 1, 10.0f, null, 0.0f);
            g.setStroke(s);
            g.drawLine(actualOrigin.x, actualOrigin.y, actualOrigin.x, this.location.y + 3 + this.type.spaceRequirements.flowPastEnd);
            g.setColor(this.getAxisOriginDotColor());
            g.drawRect(actualOrigin.x - 1, actualOrigin.y - 1, actualOrigin.x + 1, actualOrigin.y + 1);
            this.type.paintAxis(g, actualOrigin.x, actualOrigin.y, actualOrigin.y - 3 - this.type.spaceRequirements.flowPastEnd - this.location.y, this.getTextColor(), this.getMajorTickMarkColor(), this.getMinorTickMarkColor());
        } else if (this.axisOrientation == 2) {
            g.setColor(this.getAxisColor());
            BasicStroke s = new BasicStroke(this.getAxisWidth(), 2, 1, 10.0f, null, 0.0f);
            g.setStroke(s);
            g.drawLine(actualOrigin.x, actualOrigin.y, this.location.x + this.size.width - 3 - this.type.spaceRequirements.flowPastEnd, actualOrigin.y);
            this.type.paintAxis(g, actualOrigin.x, actualOrigin.y, this.size.width - 3 - this.type.spaceRequirements.flowPastEnd - actualOrigin.x + this.location.x, this.getTextColor(), this.getMajorTickMarkColor(), this.getMinorTickMarkColor());
        }
    }

    @Override
    public final void setBounds(int x, int y, int width, int height) {
        this.size.setSize(width, height);
        this.location.setLocation(x, y);
        super.setBounds(x, y, width, height);
    }

    public final int getAxisOrientation() {
        return this.axisOrientation;
    }

    protected final void setAxisOrientation(int i) {
        this.axisOrientation = i;
    }

    public final boolean getOnLeftSide() {
        return this.onLeftSide;
    }

    public final void setOnLeftSide(boolean left) {
        this.onLeftSide = left;
    }

    final void assumeAxisLength(int axisLength) {
        if (axisLength != this.lastAxisLength || !this.type.labelsValid) {
            this.type.assumeAxisLength(axisLength);
            this.lastAxisLength = axisLength;
        }
    }

    public Color getAxisColor() {
        if (this.axisColor != null) {
            return this.axisColor;
        }
        return this.getForeground();
    }

    public void setAxisWidth(float newWidth) {
        this.axisWidth = newWidth;
    }

    public float getAxisWidth() {
        return this.axisWidth;
    }

    public void setAxisColor(Color newColor) {
        this.axisColor = newColor;
    }

    public Color getAxisOriginDotColor() {
        if (this.axisOriginDotColor != null) {
            return this.axisOriginDotColor;
        }
        return this.getAxisColor();
    }

    public void setAxisOriginDotColor(Color newColor) {
        this.axisOriginDotColor = newColor;
    }

    public Color getMajorTickMarkColor() {
        if (this.majorTickMarkColor != null) {
            return this.majorTickMarkColor;
        }
        return this.getAxisColor();
    }

    public void setMajorTickMarkColor(Color newColor) {
        this.majorTickMarkColor = newColor;
    }

    public Color getMinorTickMarkColor() {
        if (this.minorTickMarkColor != null) {
            return this.minorTickMarkColor;
        }
        return this.getAxisColor();
    }

    public void setMinorTickMarkColor(Color newColor) {
        this.minorTickMarkColor = newColor;
    }

    public Color getTextColor() {
        if (this.textColor != null) {
            return this.textColor;
        }
        return this.getAxisColor();
    }

    public void setTextColor(Color newColor) {
        this.textColor = newColor;
    }
}

