/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import org.lsst.ccs.drivers.reb.Daq0Client;
import org.lsst.ccs.drivers.reb.Daq1Client;
import org.lsst.ccs.drivers.reb.Daq2Client;
import org.lsst.ccs.drivers.reb.GlobalClient;
import org.lsst.ccs.drivers.reb.ImageClient;
import org.lsst.ccs.drivers.reb.PciClient;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class ClientFactory {
    public RegClient.Impl createRegClient(int hdw) throws REBException {
        switch (hdw) {
            case 0: {
                return new Daq0Client.Registers();
            }
            case 1: {
                return new Daq1Client.Registers();
            }
            case 2: {
                return new Daq2Client.Registers();
            }
            case 3: 
            case 4: {
                return new PciClient.Registers();
            }
        }
        throw new REBException("Invalid hardware type (" + hdw + ")");
    }

    public ImageClient.Impl createImageClient(int hdw, RegClient reg) throws REBException {
        switch (hdw) {
            case 0: {
                return new Daq0Client.Images();
            }
            case 1: {
                return new Daq1Client.Images();
            }
            case 2: {
                return new Daq2Client.Images();
            }
            case 3: {
                return new PciClient.Images(reg, 0);
            }
            case 4: {
                return new PciClient.Images(reg, 1);
            }
        }
        throw new REBException("Invalid hardware type (" + hdw + ")");
    }

    public GlobalClient.Impl createGlobalClient(int hdw) throws REBException {
        switch (hdw) {
            case 0: {
                return new Daq0Client.Global();
            }
            case 1: {
                return new Daq1Client.Global();
            }
            case 2: {
                return new Daq2Client.Global();
            }
            case 3: 
            case 4: {
                return new PciClient.Global();
            }
        }
        throw new REBException("Invalid hardware type (" + hdw + ")");
    }
}

