/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.HashMap;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.ClientFactory;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.sim.ClientFactorySimulation;
import org.lsst.ccs.drivers.reb.sim.REB3Simulation;
import org.lsst.ccs.drivers.reb.sim.SequencerListener;
import org.lsst.ccs.drivers.reb.sim.SequencerSimulation;
import org.lsst.ccs.subsystem.rafts.SequencerProc;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2Model;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2ModelBuilder;

public class SequencerLoadTest {
    @Test
    public void testLoadAndRunSequencer() throws IOException, Exception {
        FPGA2Model model;
        REB3Simulation reb3 = new REB3Simulation(10);
        SequencerSimulation seq = reb3.getSequencer();
        try (InputStream inputStream = SequencerLoadTest.class.getResourceAsStream("sequencer-reb3.seq");){
            FPGA2ModelBuilder fpgA2ModelBuilder = new FPGA2ModelBuilder();
            model = fpgA2ModelBuilder.compileFile(inputStream);
        }
        HashMap reverseSubroutineMap = new HashMap();
        model.getSubroutineAddresses().entrySet().forEach(e -> {
            String cfr_ignored_0 = (String)reverseSubroutineMap.put(e.getValue(), e.getKey());
        });
        model.getMemoryMap().stream().forEach(data -> reb3.write(data.getAddress(), data.getValue()));
        reb3.write(0x340000, ((Integer)model.getMainAddresses().get("Acquisition")).intValue());
        SequencerListener sl = new SequencerListener();
        seq.addSubroutineListener((SequencerSimulation.SubroutineListener)sl);
        seq.addFunctionListener((SequencerSimulation.FunctionListener)sl);
        seq.addWaveformListener((SequencerSimulation.WaveformListener)sl);
        Future f = seq.start();
        f.get();
        seq.shutdown();
        Assert.assertEquals((Object)"{1=5060, 2=256256, 3=1, 4=1, 5=3127000, 6=1600000}", (Object)sl.getFunctionCounts().toString());
        Assert.assertEquals((long)6433492320L, (long)sl.getAccumulatedNanos());
        Assert.assertEquals((long)2680765572L, (long)sl.getChecksum());
    }

    @Test
    public void testLoadAndRunSequencer2() throws REBException, IOException, Exception {
        BaseSet bss = new BaseSet();
        ClientFactorySimulation factory = new ClientFactorySimulation();
        bss.setClientFactory((ClientFactory)factory);
        bss.open(1, 10, "ifcname");
        SequencerProc sp = new SequencerProc(bss);
        File tmpFile = File.createTempFile("sequencer-reb3", ".seq");
        tmpFile.deleteOnExit();
        try (InputStream inputStream = SequencerLoadTest.class.getResourceAsStream("sequencer-reb3.seq");){
            Files.copy(inputStream, tmpFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        sp.loadSequencer(tmpFile.getAbsolutePath());
        sp.setStart("Acquisition");
        REB3Simulation reb3 = (REB3Simulation)factory.getAddressSpaceForId(10);
        SequencerSimulation seq = reb3.getSequencer();
        SequencerListener sl = new SequencerListener();
        seq.addSubroutineListener((SequencerSimulation.SubroutineListener)sl);
        seq.addFunctionListener((SequencerSimulation.FunctionListener)sl);
        seq.addWaveformListener((SequencerSimulation.WaveformListener)sl);
        seq.addStateListener((SequencerSimulation.StateListener)sl);
        sp.startSequencer();
        sl.waitForState(SequencerSimulation.State.STOPPED, Duration.ofSeconds(20L));
        Assert.assertEquals((Object)"{1=5060, 2=256256, 3=1, 4=1, 5=3127000, 6=1600000}", (Object)sl.getFunctionCounts().toString());
        Assert.assertEquals((long)6433492320L, (long)sl.getAccumulatedNanos());
        Assert.assertEquals((long)2680765572L, (long)sl.getChecksum());
    }
}

