import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.bootstrap.BootstrapResourceUtils
import org.lsst.ccs.subsystem.rafts.RaftsMain
import org.lsst.ccs.subsystem.rafts.REBDevice
import org.lsst.ccs.subsystem.rafts.DacControl
import org.lsst.ccs.subsystem.rafts.BiasControl
import org.lsst.ccs.subsystem.rafts.AspicControl
import org.lsst.ccs.drivers.reb.PowerAdcs
import org.lsst.ccs.drivers.reb.SlowAdcs
import org.lsst.ccs.drivers.reb.sim.ClientFactorySimulation
import org.lsst.ccs.monitor.Channel
import org.lsst.ccs.monitor.Page

taskConfig = ["monitor-update/taskPeriodMillis":1000,"monitor-publish/taskPeriodMillis":10000]

Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()
def runMode = props.getProperty("org.lsst.ccs.run.mode", "normal")
factory = runMode.equals("simulation") ? new ClientFactorySimulation() : null

int raftId = Integer.valueOf(props.getProperty("org.lsst.ccs.rafts.id", "0"))
def partition = props.getProperty("org.lsst.ccs.rafts.partition", "cr")
def hwType = props.getProperty("org.lsst.ccs.rafts.hwtype", "daq2")
int id = hwType.equals("daq2") ? 4 * raftId : raftId;

CCSBuilder builder = ["ccs-wreb"]

builder.main (RaftsMain, nodeTags:taskConfig) {

    def wreb = "WREB"

    "$wreb" (REBDevice, hdwType: hwType, id: id, ifcName: partition, ccdMask: 1, clientFactory:factory) {

        "${wreb}.DAC"  (DacControl)
        //"${wreb}.DAC"  (DacControl, raw: true)

        for (int j = 0; j < 2; j++) {
            "${wreb}.ASPIC$j" (AspicControl, hwChan: j)
        }

        for (int j = 0; j < 1; j++) {
            "${wreb}.Bias$j" (BiasControl, hwChan: j)
            //"${wreb}.Bias$j" (BiasControl, hwChan: j, raw: true)
        }
    }

    Page1 (Page, id: 1, label: "$wreb")

    String title = "Temperatures\\"
    for (int j = 1; j <= 6; j++) {
        "${wreb}.Temp$j" (Channel, description: "${title}Board temperature $j", units: "\u00b0C",
                          devcName: "$wreb", hwChan: j - 1, type: "TEMP", pageId: 1)
        title = ""
    }

    "${wreb}.Atemp0U" (Channel, description: "ASPIC 0 upper temp", units: "\u00b0C",
                       devcName: "$wreb", hwChan: 0, type: "ATEMP", pageId: 1)

    "${wreb}.Atemp0L" (Channel, description: "ASPIC 0 lower temp", units: "\u00b0C",
                       devcName: "$wreb", hwChan: 1, type: "ATEMP", pageId: 1)

    "${wreb}.CCDtemp0" (Channel, description: "CCD 0 temperature", units: "\u00b0C",
                        devcName: "$wreb", hwChan: 0, type: "RTD", pageId: 1)

    "${wreb}.RTDtemp" (Channel, description: "RTD temperature", units: "\u00b0C",
                       devcName: "$wreb", hwChan: 3, type: "RTD", pageId: 1)

    "${wreb}.DigV"   (Channel, description: "Board power\\Digital PS voltage", units: "Volts",
                      devcName: "$wreb", hwChan: PowerAdcs.ADC_DIG_VOLTAGE, type: "POWER", pageId: 1)

    "${wreb}.DigI"   (Channel, description: "Digital PS current", format: ".1f", units: "mA",
                      devcName: "$wreb", hwChan: PowerAdcs.ADC_DIG_CURRENT, type: "POWER", scale: 1000, pageId: 1)

    "${wreb}.AnaV"   (Channel, description: "Analog PS voltage", units: "Volts",
                      devcName: "$wreb", hwChan: PowerAdcs.ADC_ANA_VOLTAGE, type: "POWER", pageId: 1)

    "${wreb}.AnaI"   (Channel, description: "Analog PS current", format: ".1f", units: "mA",
                      devcName: "$wreb", hwChan: PowerAdcs.ADC_ANA_CURRENT, type: "POWER", scale: 1000, pageId: 1)

    "${wreb}.ClkHV"  (Channel, description: "CLK_H PS voltage", units: "Volts",
                      devcName: "$wreb", hwChan: PowerAdcs.ADC_CLKH_VOLTAGE, type: "POWER", pageId: 1)

    "${wreb}.ClkHI"  (Channel, description: "CLK_H PS current", format: ".1f", units: "mA",
                      devcName: "$wreb", hwChan: PowerAdcs.ADC_CLKH_CURRENT, type: "POWER", scale: 1000, pageId: 1)

    "${wreb}.ODV"    (Channel, description: "OD PS voltage", units: "Volts",
                      devcName: "$wreb", hwChan: PowerAdcs.ADC_OD_VOLTAGE, type: "POWER", pageId: 1)

    "${wreb}.ODI"    (Channel, description: "OD PS current", format: ".1f", units: "mA",
                      devcName: "$wreb", hwChan: PowerAdcs.ADC_OD_CURRENT, type: "POWER", scale: 1000, pageId: 1)

    "${wreb}.HtrV"   (Channel, description: "Heater PS voltage", units: "Volts",
                      devcName: "$wreb", hwChan: PowerAdcs.ADC_HTR_VOLTAGE, type: "POWER", pageId: 1)

    "${wreb}.HtrI"   (Channel, description: "Heater PS current", format: ".1f", units: "mA",
                      devcName: "$wreb", hwChan: PowerAdcs.ADC_HTR_CURRENT, type: "POWER", scale: 1000, pageId: 1)

    "${wreb}.Power"  (Channel, description: "Total power", format: ".2f", units: "Watts",
                      devcName: "$wreb", hwChan: REBDevice.CHAN_TOTAL_POWER, type: "POWER", pageId: 1)

    "${wreb}.PClkSh" (Channel, description: "Clock rails\\Parallel shifted", format: ".2f", units: "Volts",
                      devcName: "$wreb", hwChan: SlowAdcs.CHAN_CKP_SH, type: "CRVOLT", pageId: 1)

    "${wreb}.SClkU"  (Channel, description: "Serial upper", format: ".2f", units: "Volts",
                      devcName: "$wreb", hwChan: SlowAdcs.CHAN_SCK_U, type: "CRVOLT", pageId: 1)

    "${wreb}.SClkL"  (Channel, description: "Serial lower", format: ".2f", units: "Volts",
                      devcName: "$wreb", hwChan: SlowAdcs.CHAN_SCK_L, type: "CRVOLT", pageId: 1)

    "${wreb}.RGU"    (Channel, description: "RG upper", format: ".2f", units: "Volts",
                      devcName: "$wreb", hwChan: SlowAdcs.CHAN_RG_U, type: "CRVOLT", pageId: 1)

    "${wreb}.RGL"    (Channel, description: "RG lower", format: ".2f", units: "Volts",
                      devcName: "$wreb", hwChan: SlowAdcs.CHAN_RG_L, type: "CRVOLT", pageId: 1)

    "${wreb}.PClk0"  (Channel, description: "Clock states\\Parallel 0", format: ".2f", units: "Volts",
                      devcName: "$wreb", hwChan: SlowAdcs.CHAN_CKP_0, type: "CRVOLT", pageId: 1)

    "${wreb}.SClk0"  (Channel, description: "Serial 0", format: ".2f", units: "Volts",
                      devcName: "$wreb", hwChan: SlowAdcs.CHAN_CKS_0, type: "CRVOLT", pageId: 1)

    "${wreb}.RG0"    (Channel, description: "RG 0", format: ".2f", units: "Volts",
                      devcName: "$wreb", hwChan: SlowAdcs.CHAN_RG_0, type: "CRVOLT", pageId: 1)

    "${wreb}.OD0V"   (Channel, description: "Bias voltages\\OD 0 voltage", format: ".2f", units: "Volts",
                      devcName: "$wreb", hwChan: SlowAdcs.CHAN_OD_0, type: "CRVOLT", pageId: 1)

    "${wreb}.OG0V"   (Channel, description: "OG 0 voltage", format: ".2f", units: "Volts",
                      devcName: "$wreb", hwChan: SlowAdcs.CHAN_OG_0, type: "CRVOLT", pageId: 1)

    "${wreb}.RD0V"   (Channel, description: "RD 0 voltage", format: ".2f", units: "Volts",
                      devcName: "$wreb", hwChan: SlowAdcs.CHAN_RD_0, type: "CRVOLT", pageId: 1)

    "${wreb}.GD0V"   (Channel, description: "GD 0 voltage", format: ".2f", units: "Volts",
                      devcName: "$wreb", hwChan: SlowAdcs.CHAN_GD_0, type: "CRVOLT", pageId: 1)

    "${wreb}.OD0I"   (Channel, description: "OD 0 current", format: ".1f", units: "mA",
                      devcName: "$wreb", hwChan: SlowAdcs.CHAN_ODI_0, type: "CRVOLT", scale: 1000, pageId: 1)

}
