/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import java.util.List;
import org.lsst.ccs.drivers.reb.ClientFactory;
import org.lsst.ccs.drivers.reb.GlobalClient;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.utilities.logging.Logger;

public class GlobalProc {
    private GlobalClient gbl;

    public void initialize(List<REBDevice> rebDevices, ClientFactory clientFactory, Logger sLog) {
        int[] ids = new int[rebDevices.size()];
        String[] ifcNames = new String[rebDevices.size()];
        int hdwType = 1;
        for (int j = 0; j < ids.length; ++j) {
            REBDevice reb = rebDevices.get(j);
            ids[j] = reb.getId();
            ifcNames[j] = reb.getIfcName();
            hdwType = reb.getHdwType();
        }
        try {
            if (this.gbl == null) {
                this.gbl = new GlobalClient();
                if (clientFactory != null) {
                    this.gbl.setClientFactory(clientFactory);
                }
            } else {
                this.gbl.close();
            }
            this.gbl.open(hdwType, ids, ifcNames);
        }
        catch (REBException e) {
            sLog.error((Object)"Error during global initialization", (Throwable)e);
        }
    }

    public void setRegisters(int rebType, int[] registers) throws REBException {
        this.gbl.setRegisterlist(rebType, registers);
    }

    public void acquireImage() throws REBException {
        this.gbl.acquireImage(String.format("Image_%016x", System.currentTimeMillis()));
    }

    public void acquireImage(String name) throws REBException {
        this.gbl.acquireImage(name);
    }
}

