/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.net.URL;
import java.util.Properties;
import javax.help.BadIDException;
import javax.help.DefaultHelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.InvalidHelpSetContextException;
import javax.help.Map;
import javax.swing.SwingUtilities;
import org.freehep.application.Application;
import org.freehep.application.ApplicationEvent;
import org.freehep.application.ApplicationListener;
import org.freehep.application.HelpService;
import org.freehep.application.PropertyUtilities;

class HelpServiceImpl
implements HelpService {
    ApplicationListener al = new ApplicationListener(){

        @Override
        public void aboutToExit(ApplicationEvent e) {
            Properties user = e.getApplication().getUserProperties();
            Rectangle bounds = new Rectangle();
            bounds.setSize(HelpServiceImpl.this.helpBroker.getSize());
            bounds.setLocation(HelpServiceImpl.this.helpBroker.getLocation());
            PropertyUtilities.setRectangle(user, "helpBrokerWindow", bounds);
        }

        @Override
        public void initializationComplete(ApplicationEvent e) {
        }

        public void applicationVisible(ApplicationEvent e) {
        }
    };
    private DefaultHelpBroker helpBroker;

    HelpServiceImpl() throws Application.InitializationException {
        try {
            Application app = Application.getApplication();
            Properties props = app.getUserProperties();
            URL helpsetURL = PropertyUtilities.getURL(props, "helpset", null);
            if (helpsetURL == null) {
                throw new Application.InitializationException("Application property \"helpset\" missing or invalid");
            }
            HelpSet helpSet = new HelpSet(null, helpsetURL);
            this.helpBroker = new DefaultHelpBroker(helpSet);
            app.addApplicationListener(this.al);
        }
        catch (HelpSetException x) {
            throw new Application.InitializationException("Could not load helpset", x);
        }
    }

    @Override
    public void showHelpTopic(String helpTopicTarget, String navigatorView, Component owner) {
        try {
            HelpSet hs = this.helpBroker.getHelpSet();
            Map.ID id = helpTopicTarget == null ? hs.getHomeID() : Map.ID.create((String)helpTopicTarget, (HelpSet)hs);
            Window w = (Window)SwingUtilities.getAncestorOfClass(Window.class, owner);
            if (w != null) {
                this.helpBroker.setActivationWindow(w);
            }
            if (navigatorView != null) {
                this.helpBroker.setCurrentView(navigatorView);
            }
            this.helpBroker.setCurrentID(id);
            if (!this.helpBroker.isDisplayed()) {
                Rectangle bounds = PropertyUtilities.getRectangle(Application.getApplication().getUserProperties(), "helpBrokerWindow", null);
                if (bounds != null) {
                    this.helpBroker.setLocation(bounds.getLocation());
                    this.helpBroker.setSize(bounds.getSize());
                }
                this.helpBroker.setDisplayed(true);
            }
        }
        catch (BadIDException x) {
            throw new IllegalArgumentException("Cannot find help topic: " + helpTopicTarget);
        }
        catch (InvalidHelpSetContextException x) {
            throw new IllegalArgumentException("Cannot find help topic: " + helpTopicTarget);
        }
    }
}

