/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.text.NumberFormatter;
import org.lsst.ccs.subsystem.rafts.config.ASPIC;
import org.lsst.ccs.subsystem.rafts.config.BiasDACS;
import org.lsst.ccs.subsystem.rafts.config.REB;
import org.lsst.ccs.subsystem.rafts.ui.ASPICConfigPanel;
import org.lsst.ccs.subsystem.rafts.ui.BiasesConfigPanel;
import org.lsst.ccs.subsystem.rafts.ui.RaftsControlPanel;

public class REBConfigPanel
extends JPanel {
    private static final Map<Integer, String> dacNames = new HashMap<Integer, String>();
    private static final List<Integer> dacList1;
    private static final List<Integer> dacList2;
    private static final List<Integer> dacList3;
    private static final int TF_WIDTH = 50;
    private static final int TF_WIDTH_L = 80;
    private static final int TF_WIDTH_S = 30;
    private static final NumberFormatter fmt5;
    private static final NumberFormatter fmtf5;
    private static final NumberFormatter fmt3;
    private static final Insets insets_std;
    private static final Insets insets_big;
    private final JLabel lbIdDesc = new JLabel("REB id:");
    private final JLabel lblId = new JLabel("X");
    private final JLabel lbIfcNameDesc = new JLabel("REB iface:");
    private final JLabel lblIfcName = new JLabel("X");
    private final JLabel lbCcdMaskDesc = new JLabel("CCD mask:");
    private final JLabel lblCcdMask = new JLabel("X");
    private final JLabel[] lbDacVoltage = new JLabel[21];
    private final JFormattedTextField[] tfDacVoltage = new JFormattedTextField[21];
    private final JLabel[] lbDacCurrent = new JLabel[3];
    private final JFormattedTextField[] tfDacCurrent = new JFormattedTextField[3];
    private final ASPICConfigPanel[] aspicPanels = new ASPICConfigPanel[6];
    private final BiasesConfigPanel[] biasPanels = new BiasesConfigPanel[3];
    private final JPanel[] ccdPanels = new JPanel[3];
    private final JTabbedPane ccdTabs = new JTabbedPane();
    private final JPanel ccdContainer = new JPanel();
    private final REB reb;
    private final String name;
    private final RaftsControlPanel parent;
    private final List<Integer> dacs;
    private final List<Integer> ccds = new ArrayList<Integer>();
    private final boolean dacRaw;
    private final boolean showCsgate;
    private final boolean groupByThree;
    private static final long serialVersionUID = 1L;

    public REBConfigPanel(REB reb, String name, RaftsControlPanel parent) {
        this.reb = reb;
        this.name = name;
        this.parent = parent;
        this.dacRaw = reb.isDacRaw();
        int version = reb.getDacVersion();
        this.dacs = !this.dacRaw || version == 0 ? dacList1 : (version == 1 || version == 3 ? dacList2 : dacList3);
        this.showCsgate = version == 0;
        this.groupByThree = this.dacRaw && version == 2;
        this.initComponents();
    }

    public void setConfig(REB reb) {
        this.reb.copyFrom(reb);
        this.read();
    }

    private void initComponents() {
        int ccdMask = this.reb.getMaxCcdMask();
        for (int j = 0; j < 3; ++j) {
            if ((1 << j & ccdMask) == 0) continue;
            this.ccds.add(j);
        }
        Dimension d3 = this.lblId.getPreferredSize();
        d3.width = 30;
        this.lblId.setPreferredSize(d3);
        this.lblId.setMinimumSize(d3);
        d3.width = 80;
        this.lblIfcName.setPreferredSize(d3);
        this.lblIfcName.setMinimumSize(d3);
        d3.width = 30;
        this.lblCcdMask.setPreferredSize(d3);
        this.lblCcdMask.setMinimumSize(d3);
        Dimension d5 = new JFormattedTextField().getPreferredSize();
        d5.width = 50;
        for (int dac : this.dacs) {
            this.lbDacVoltage[dac] = new JLabel(dacNames.get(dac) + ":");
            this.tfDacVoltage[dac] = new JFormattedTextField(this.dacRaw ? fmt5 : fmtf5);
            this.tfDacVoltage[dac].setPreferredSize(d5);
            this.tfDacVoltage[dac].setMinimumSize(d5);
        }
        if (this.showCsgate) {
            for (int ccd = 0; ccd < 3; ++ccd) {
                this.lbDacCurrent[ccd] = new JLabel("CS Gate " + ccd + ":");
                this.tfDacCurrent[ccd] = new JFormattedTextField(fmt5);
                this.tfDacCurrent[ccd].setPreferredSize(d5);
                this.tfDacCurrent[ccd].setMinimumSize(d5);
            }
        }
        JPanel cfgPanel = new JPanel();
        cfgPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        cfgPanel.add((Component)this.lbIdDesc, gbc);
        ++gbc.gridx;
        cfgPanel.add((Component)this.lblId, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        cfgPanel.add((Component)this.lbIfcNameDesc, gbc);
        ++gbc.gridx;
        gbc.gridwidth = 3;
        cfgPanel.add((Component)this.lblIfcName, gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        ++gbc.gridy;
        cfgPanel.add((Component)this.lbCcdMaskDesc, gbc);
        ++gbc.gridx;
        cfgPanel.add((Component)this.lblCcdMask, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets = insets_big;
        cfgPanel.add((Component)new JLabel("DAC voltages"), gbc);
        ++gbc.gridx;
        gbc.gridwidth = 3;
        gbc.fill = 2;
        gbc.anchor = 10;
        cfgPanel.add((Component)new JSeparator(), gbc);
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.insets = insets_std;
        int fld = 0;
        for (int dac : this.dacs) {
            gbc.gridx = 2 * (fld & 1);
            gbc.gridy += 1 - (fld & 1);
            cfgPanel.add((Component)this.lbDacVoltage[dac], gbc);
            ++gbc.gridx;
            cfgPanel.add((Component)this.tfDacVoltage[dac], gbc);
            if (!this.groupByThree || (++fld & 3) != 3) continue;
            ++fld;
        }
        if (this.showCsgate) {
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.insets = insets_big;
            cfgPanel.add((Component)new JLabel("DAC currents"), gbc);
            ++gbc.gridx;
            gbc.gridwidth = 3;
            gbc.fill = 2;
            gbc.anchor = 10;
            cfgPanel.add((Component)new JSeparator(), gbc);
            gbc.gridwidth = 1;
            gbc.fill = 0;
            gbc.anchor = 18;
            gbc.insets = insets_std;
            for (int ccd : this.ccds) {
                gbc.gridx = 0;
                ++gbc.gridy;
                cfgPanel.add((Component)this.lbDacCurrent[ccd], gbc);
                ++gbc.gridx;
                cfgPanel.add((Component)this.tfDacCurrent[ccd], gbc);
            }
        }
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.fill = 3;
        gbc.gridheight = 0;
        gbc.gridwidth = 1;
        cfgPanel.add((Component)new JSeparator(1), gbc);
        gbc.fill = 0;
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.gridheight = 0;
        gbc.gridwidth = 0;
        cfgPanel.add((Component)this.ccdContainer, gbc);
        this.ccdContainer.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = insets_std;
        gbc1.gridwidth = 2;
        gbc1.gridheight = 1;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.anchor = 18;
        this.ccdContainer.add((Component)this.ccdTabs, gbc1);
        for (int ccd : this.ccds) {
            JPanel ccdPanel = new JPanel();
            ccdPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc2 = new GridBagConstraints();
            gbc2.insets = insets_std;
            gbc2.gridwidth = 1;
            gbc2.gridheight = 1;
            gbc2.anchor = 18;
            gbc2.gridx = 0;
            gbc2.gridy = 0;
            for (int side = 0; side < 2; ++side) {
                int jc = 2 * ccd + side;
                ASPIC aspic = this.reb.getAspics()[jc];
                if (aspic != null) {
                    this.aspicPanels[jc] = new ASPICConfigPanel(jc, aspic);
                    ccdPanel.add((Component)this.aspicPanels[jc], gbc2);
                }
                ++gbc2.gridy;
            }
            BiasDACS bias = this.reb.getBiases()[ccd];
            if (bias != null) {
                this.biasPanels[ccd] = new BiasesConfigPanel(ccd, bias, this.reb.isBiasRaw());
                ccdPanel.add((Component)this.biasPanels[ccd], gbc2);
            }
            this.ccdPanels[ccd] = ccdPanel;
            this.ccdTabs.addTab("CCD " + ccd, this.ccdPanels[ccd]);
        }
        this.read();
        JButton btLoadDacs = new JButton("Load DACs");
        btLoadDacs.setFocusable(false);
        btLoadDacs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                REBConfigPanel.this.parent.sendCommand(true, REBConfigPanel.this.name, "loadDacs", true);
            }
        });
        JButton btLoadAspics = new JButton("Load ASPICs");
        btLoadAspics.setFocusable(false);
        btLoadAspics.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                REBConfigPanel.this.parent.sendCommand(true, REBConfigPanel.this.name, "loadAspics", true);
            }
        });
        JButton btUndo = new JButton("Undo");
        btUndo.setFocusable(false);
        btUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                REBConfigPanel.this.read();
            }
        });
        JButton btApply = new JButton("Apply");
        btApply.setFocusable(false);
        btApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                REBConfigPanel.this.save();
                REBConfigPanel.this.parent.sendCommand(true, REBConfigPanel.this.name, "setREBConfig", REBConfigPanel.this.reb);
            }
        });
        JButton btClose = new JButton("Close");
        btClose.setFocusable(false);
        btClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                REBConfigPanel.this.parent.closeConfig(REBConfigPanel.this.name);
            }
        });
        JButton btOK = new JButton("OK");
        btOK.setFocusable(false);
        btOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                REBConfigPanel.this.save();
                REBConfigPanel.this.parent.sendCommand(false, REBConfigPanel.this.name, "setREBConfig", REBConfigPanel.this.reb);
                REBConfigPanel.this.parent.closeConfig(REBConfigPanel.this.name);
            }
        });
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbb = new GridBagConstraints();
        gbb.anchor = 17;
        gbb.insets = new Insets(4, 4, 4, 4);
        btnPanel.add((Component)btLoadDacs, gbb);
        btnPanel.add((Component)btLoadAspics, gbb);
        gbb.insets.left = 20;
        btnPanel.add((Component)btUndo, gbb);
        gbb.insets.left = 4;
        btnPanel.add((Component)btApply, gbb);
        gbb.insets.left = 20;
        btnPanel.add((Component)btOK, gbb);
        gbb.insets.left = 4;
        btnPanel.add((Component)btClose, gbb);
        this.setLayout(new BorderLayout());
        this.add((Component)cfgPanel, "Center");
        this.add((Component)btnPanel, "South");
    }

    private void save() {
        if (this.dacRaw) {
            values = this.reb.getDacs().getValues();
            for (int dac : this.dacs) {
                values[dac] = (Integer)this.tfDacVoltage[dac].getValue();
            }
            if (this.showCsgate) {
                for (int ccd : this.ccds) {
                    int n = ccd == 0 ? 12 : (ccd == 1 ? 13 : 14);
                    values[n] = (Integer)this.tfDacCurrent[ccd].getValue();
                }
            }
        } else {
            values = this.reb.getDacs().getPValues();
            for (int dac : this.dacs) {
                values[dac] = (int)((Double)this.tfDacVoltage[dac].getValue()).doubleValue();
            }
        }
        for (ASPICConfigPanel aSPICConfigPanel : this.aspicPanels) {
            if (aSPICConfigPanel == null) continue;
            aSPICConfigPanel.save();
        }
        for (JPanel jPanel : this.biasPanels) {
            if (jPanel == null) continue;
            ((BiasesConfigPanel)jPanel).save();
        }
    }

    private void read() {
        this.lblId.setText(Integer.toString(this.reb.getId()));
        this.lblIfcName.setText(this.reb.getIfcName());
        this.lblCcdMask.setText(Integer.toString(this.reb.getCcdMask()));
        if (this.dacRaw) {
            values = this.reb.getDacs().getValues();
            for (int dac : this.dacs) {
                this.tfDacVoltage[dac].setValue(values[dac]);
            }
            if (this.showCsgate) {
                for (int ccd : this.ccds) {
                    int n = ccd == 0 ? 12 : (ccd == 1 ? 13 : 14);
                    this.tfDacCurrent[ccd].setValue(values[n]);
                }
            }
        } else {
            values = this.reb.getDacs().getPValues();
            for (int dac : this.dacs) {
                this.tfDacVoltage[dac].setValue(values[dac]);
            }
        }
        for (ASPICConfigPanel aSPICConfigPanel : this.aspicPanels) {
            if (aSPICConfigPanel == null) continue;
            aSPICConfigPanel.read();
        }
        for (JPanel jPanel : this.biasPanels) {
            if (jPanel == null) continue;
            ((BiasesConfigPanel)jPanel).read();
        }
    }

    public static void main(String[] args) throws Exception {
        REB r;
        final File file = new File("reb.ser");
        if (file.exists()) {
            ObjectInputStream is = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            r = (REB)is.readObject();
            is.close();
        } else {
            r = new REB();
        }
        final REBConfigPanel p = new REBConfigPanel(r, null, null);
        final JFrame f = new JFrame("REB");
        JPanel pane = new JPanel();
        pane.setLayout(new BorderLayout());
        pane.add((Component)p, "Center");
        JPanel btPanel = new JPanel();
        JButton btClose = new JButton("Close");
        btClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                f.dispose();
            }
        });
        JButton btOK = new JButton("OK");
        btOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                p.save();
                try {
                    ObjectOutputStream s = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                    s.writeObject(r);
                    s.close();
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                f.dispose();
            }
        });
        btPanel.add(btClose);
        btPanel.add(btOK);
        pane.add((Component)btPanel, "South");
        JScrollPane scroll = new JScrollPane(pane);
        f.setContentPane(scroll);
        f.pack();
        f.setVisible(true);
    }

    static {
        dacNames.put(0, "SCLK Low");
        dacNames.put(1, "SCLK High");
        dacNames.put(2, "PCLK Low");
        dacNames.put(3, "PCLK High");
        dacNames.put(4, "RG Low");
        dacNames.put(5, "RG High");
        dacNames.put(6, "SCLK Low Sh");
        dacNames.put(7, "SCLK High Sh");
        dacNames.put(8, "PCLK Low Sh");
        dacNames.put(9, "PCLK High Sh");
        dacNames.put(10, "RG Low Sh");
        dacNames.put(11, "RG High Sh");
        dacNames.put(12, "CS Gate 0");
        dacNames.put(13, "CS Gate 1");
        dacNames.put(14, "CS Gate 2");
        dacList1 = new ArrayList<Integer>();
        dacList1.add(0);
        dacList1.add(1);
        dacList1.add(2);
        dacList1.add(3);
        dacList1.add(4);
        dacList1.add(5);
        dacList2 = new ArrayList<Integer>();
        dacList2.add(0);
        dacList2.add(6);
        dacList2.add(1);
        dacList2.add(7);
        dacList2.add(2);
        dacList2.add(8);
        dacList2.add(3);
        dacList2.add(9);
        dacList2.add(4);
        dacList2.add(10);
        dacList2.add(5);
        dacList2.add(11);
        dacList3 = new ArrayList<Integer>();
        dacList3.add(0);
        dacList3.add(6);
        dacList3.add(1);
        dacList3.add(2);
        dacList3.add(8);
        dacList3.add(3);
        dacList3.add(4);
        dacList3.add(10);
        dacList3.add(5);
        fmt5 = new NumberFormatter(new DecimalFormat("####0"));
        fmtf5 = new NumberFormatter(new DecimalFormat("##0.0#"));
        fmt3 = new NumberFormatter(new DecimalFormat("##0"));
        fmt3.setValueClass(Integer.class);
        fmt5.setValueClass(Integer.class);
        fmtf5.setValueClass(Double.class);
        insets_std = new Insets(4, 4, 4, 4);
        insets_big = new Insets(14, 4, 6, 4);
    }
}

