package org.lsst.ccs.subsystem.rafts.ui;

import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.rafts.data.RaftState;

/**
 *  Implements the rafts monitoring control panel.
 *
 *  @author Owen Saxton
 */
public class RaftsMonitorPanel extends JPanel implements CommandSender.ReplyHandler {

    private final CommandSender sender;
    private SystemStatusPanel statusPanel;

    public RaftsMonitorPanel(String agent) {
        sender = new CommandSender(agent, this);
        initComponents();
        (new DisablePanel()).run();
    }

    public void initPanel() {
        sender.sendCommand(true, null, "getFullState");
    }

    @Override
    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        updatePanel((RaftState)reply);
    }

    public void updatePanel(RaftState state) {
        SwingUtilities.invokeLater(new UpdatePanel(state));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    private void initComponents()
    {
        // Status line panel
        statusPanel = new SystemStatusPanel(sender);
        
        // Whole panel
        add(statusPanel);
    }

    class UpdatePanel implements Runnable {

        private final RaftState state;

        UpdatePanel(RaftState state) {
            this.state = state;
        }

        @Override
        public void run() {
            statusPanel.updatePanel(state.getTickMillis());
            repaint();
        }

    }

    class DisablePanel implements Runnable {

        @Override
        public void run() {
            statusPanel.disablePanel();
            repaint();
        } 
    }

    private static final long serialVersionUID = 1L;
}
