/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.Options;
import org.lsst.ccs.command.StringTokenizer;

public class TokenizedCommand
implements BasicCommand {
    private final List<StringTokenizer.Token> tokens;
    private final String[] args;
    private static final long serialVersionUID = -687119049448004978L;
    private final Options options = new Options();
    private final List<StringTokenizer.Token> argumentTokenList = new ArrayList<StringTokenizer.Token>();
    private StringTokenizer.Token lastToken;

    public TokenizedCommand(String command) {
        this.tokens = StringTokenizer.tokenize(command);
        ArrayList<String> argumentValues = new ArrayList<String>();
        boolean isFirst = true;
        for (StringTokenizer.Token token : this.tokens) {
            if (isFirst) {
                isFirst = false;
            } else if (token.isOption()) {
                if (token.isShortOption()) {
                    String shortOptions = token.getString();
                    for (int ii = 0; ii < shortOptions.length(); ++ii) {
                        this.options.withOption(Character.toString(shortOptions.charAt(ii)));
                    }
                } else {
                    this.options.withOption(token.getString());
                }
            } else {
                this.argumentTokenList.add(token);
                argumentValues.add(token.getString());
            }
            this.lastToken = token;
        }
        this.args = new String[argumentValues.size()];
        argumentValues.toArray(this.args);
    }

    @Override
    public String getCommand() {
        return this.tokens.get(0).getString();
    }

    int getCommandLocation() {
        return this.tokens.get(0).getLocation();
    }

    @Override
    public String getArgument(int index) {
        return this.args[index];
    }

    public String[] getArguments() {
        return this.args;
    }

    int getArgumentLocation(int index) {
        return this.argumentTokenList.get(index).getLocation();
    }

    @Override
    public int getArgumentCount() {
        return this.args.length;
    }

    public boolean isEmpty() {
        return this.tokens.isEmpty();
    }

    public String toString() {
        return this.prettyToString();
    }

    @Override
    public Options getOptions() {
        if (this.options == null) {
            return new Options();
        }
        return this.options;
    }

    StringTokenizer.Token getLastToken() {
        return this.lastToken;
    }
}

