/*
 * Decompiled with CFR 0.152.
 */
package org.python.antlr;

import java.util.ArrayList;
import java.util.List;
import org.python.antlr.AST;
import org.python.antlr.ast.Name;
import org.python.antlr.ast.VisitorIF;
import org.python.antlr.runtime.CommonToken;
import org.python.antlr.runtime.Token;
import org.python.antlr.runtime.tree.CommonTree;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;

public class PythonTree
extends AST
implements Traverseproc {
    public boolean from_future_checked = false;
    private int charStartIndex = -1;
    private int charStopIndex = -1;
    private CommonTree node;
    private PythonTree parent;
    protected List<PythonTree> children;

    public PythonTree() {
        this.node = new CommonTree();
    }

    public PythonTree(PyType subType) {
        super(subType);
        this.node = new CommonTree();
    }

    public PythonTree(Token t) {
        this.node = new CommonTree(t);
    }

    public PythonTree(int ttype, Token t) {
        CommonToken c = new CommonToken(ttype, t.getText());
        c.setLine(t.getLine());
        c.setTokenIndex(t.getTokenIndex());
        c.setCharPositionInLine(t.getCharPositionInLine());
        c.setChannel(t.getChannel());
        c.setStartIndex(((CommonToken)t).getStartIndex());
        c.setStopIndex(((CommonToken)t).getStopIndex());
        this.node = new CommonTree(c);
    }

    public PythonTree(PythonTree tree) {
        this.node = new CommonTree(tree.getNode());
        this.charStartIndex = tree.getCharStartIndex();
        this.charStopIndex = tree.getCharStopIndex();
    }

    public CommonTree getNode() {
        return this.node;
    }

    public Token getToken() {
        return this.node.getToken();
    }

    public PythonTree dupNode() {
        return new PythonTree(this);
    }

    public boolean isNil() {
        return this.node.isNil();
    }

    public int getAntlrType() {
        return this.node.getType();
    }

    public String getText() {
        return this.node.getText();
    }

    protected int getLine() {
        if (this.node.getToken() == null || this.node.getToken().getLine() == 0) {
            if (this.getChildCount() > 0) {
                return this.getChild(0).getLine();
            }
            return 1;
        }
        return this.node.getToken().getLine();
    }

    protected int getCharPositionInLine() {
        Token token2 = this.node.getToken();
        if (token2 == null || token2.getCharPositionInLine() == -1) {
            if (this.getChildCount() > 0) {
                return this.getChild(0).getCharPositionInLine();
            }
            return 0;
        }
        if (token2 != null && token2.getCharPositionInLine() == -2) {
            return -1;
        }
        return token2.getCharPositionInLine();
    }

    public int getLineno() {
        return this.getLine();
    }

    public int getCol_offset() {
        return this.getCharPositionInLine();
    }

    public int getTokenStartIndex() {
        return this.node.getTokenStartIndex();
    }

    public void setTokenStartIndex(int index) {
        this.node.setTokenStartIndex(index);
    }

    public int getTokenStopIndex() {
        return this.node.getTokenStopIndex();
    }

    public void setTokenStopIndex(int index) {
        this.node.setTokenStopIndex(index);
    }

    public int getCharStartIndex() {
        if (this.charStartIndex == -1 && this.node.getToken() != null) {
            return ((CommonToken)this.node.getToken()).getStartIndex();
        }
        return this.charStartIndex;
    }

    public void setCharStartIndex(int index) {
        this.charStartIndex = index;
    }

    public int getCharStopIndex() {
        if (this.charStopIndex == -1 && this.node.getToken() != null) {
            return ((CommonToken)this.node.getToken()).getStopIndex() + 1;
        }
        return this.charStopIndex;
    }

    public void setCharStopIndex(int index) {
        this.charStopIndex = index;
    }

    public int getChildIndex() {
        return this.node.getChildIndex();
    }

    public PythonTree getParent() {
        return this.parent;
    }

    public void setParent(PythonTree t) {
        this.parent = t;
    }

    public void setChildIndex(int index) {
        this.node.setChildIndex(index);
    }

    public static String dottedNameListToString(List<Name> names) {
        if (names == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean leadingDot = true;
        int len = names.size();
        for (int i = 0; i < len; ++i) {
            Name name = names.get(i);
            String id = name.getInternalId();
            if (id == null) continue;
            if (!".".equals(id)) {
                leadingDot = false;
            }
            sb.append(id);
            if (i >= len - 1 || leadingDot) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        if (this.isNil()) {
            return "None";
        }
        if (this.getAntlrType() == 0) {
            return "<errornode>";
        }
        if (this.node.getToken() == null) {
            return null;
        }
        return this.node.getToken().getText() + "(" + this.getLine() + "," + this.getCharPositionInLine() + ")";
    }

    public String toStringTree() {
        if (this.children == null || this.children.size() == 0) {
            return this.toString();
        }
        StringBuffer buf = new StringBuffer();
        if (!this.isNil()) {
            buf.append("(");
            buf.append(this.toString());
            buf.append(' ');
        }
        for (int i = 0; this.children != null && i < this.children.size(); ++i) {
            PythonTree t = this.children.get(i);
            if (i > 0) {
                buf.append(' ');
            }
            buf.append(t.toStringTree());
        }
        if (!this.isNil()) {
            buf.append(")");
        }
        return buf.toString();
    }

    protected String dumpThis(String s) {
        return s;
    }

    protected String dumpThis(Object o) {
        if (o instanceof PythonTree) {
            return ((PythonTree)o).toStringTree();
        }
        return String.valueOf(o);
    }

    protected String dumpThis(Object[] s) {
        StringBuffer sb = new StringBuffer();
        if (s == null) {
            sb.append("null");
        } else {
            sb.append("(");
            for (int i = 0; i < s.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.dumpThis(s[i]));
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public <R> R accept(VisitorIF<R> visitor2) throws Exception {
        throw new RuntimeException("Unexpected node: " + this);
    }

    public void traverse(VisitorIF<?> visitor2) throws Exception {
        throw new RuntimeException("Cannot traverse node: " + this);
    }

    public PythonTree getChild(int i) {
        if (this.children == null || i >= this.children.size()) {
            return null;
        }
        return this.children.get(i);
    }

    public List<PythonTree> getChildren() {
        return this.children;
    }

    public PythonTree getFirstChildWithType(int type) {
        for (int i = 0; this.children != null && i < this.children.size(); ++i) {
            PythonTree t = this.children.get(i);
            if (t.getAntlrType() != type) continue;
            return t;
        }
        return null;
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public void addChild(PythonTree t) {
        if (t == null) {
            return;
        }
        PythonTree childTree = t;
        if (childTree.isNil()) {
            if (this.children != null && this.children == childTree.children) {
                throw new RuntimeException("attempt to add child list to itself");
            }
            if (childTree.children != null) {
                if (this.children != null) {
                    int n = childTree.children.size();
                    for (int i = 0; i < n; ++i) {
                        PythonTree c = childTree.children.get(i);
                        this.children.add(c);
                        c.setParent(this);
                        c.setChildIndex(this.children.size() - 1);
                    }
                } else {
                    this.children = childTree.children;
                    this.freshenParentAndChildIndexes();
                }
            }
        } else {
            if (this.children == null) {
                this.children = this.createChildrenList();
            }
            this.children.add(t);
            childTree.setParent(this);
            childTree.setChildIndex(this.children.size() - 1);
        }
    }

    public void addChildren(List<PythonTree> kids) {
        for (int i = 0; i < kids.size(); ++i) {
            PythonTree t = kids.get(i);
            this.addChild(t);
        }
    }

    public void setChild(int i, PythonTree t) {
        if (t == null) {
            return;
        }
        if (t.isNil()) {
            throw new IllegalArgumentException("Can't set single child to a list");
        }
        if (this.children == null) {
            this.children = this.createChildrenList();
        }
        this.children.set(i, t);
        t.setParent(this);
        t.setChildIndex(i);
    }

    public Object deleteChild(int i) {
        if (this.children == null) {
            return null;
        }
        PythonTree killed = this.children.remove(i);
        this.freshenParentAndChildIndexes(i);
        return killed;
    }

    public void replaceChildren(int startChildIndex, int stopChildIndex, Object t) {
        if (this.children == null) {
            throw new IllegalArgumentException("indexes invalid; no children in list");
        }
        int replacingHowMany = stopChildIndex - startChildIndex + 1;
        PythonTree newTree = (PythonTree)t;
        List<PythonTree> newChildren = null;
        if (newTree.isNil()) {
            newChildren = newTree.children;
        } else {
            newChildren = new ArrayList<PythonTree>(1);
            newChildren.add(newTree);
        }
        int replacingWithHowMany = newChildren.size();
        int numNewChildren = newChildren.size();
        int delta = replacingHowMany - replacingWithHowMany;
        if (delta == 0) {
            int j = 0;
            for (int i = startChildIndex; i <= stopChildIndex; ++i) {
                PythonTree child = newChildren.get(j);
                this.children.set(i, child);
                child.setParent(this);
                child.setChildIndex(i);
                ++j;
            }
        } else if (delta > 0) {
            int indexToDelete;
            for (int j = 0; j < numNewChildren; ++j) {
                this.children.set(startChildIndex + j, newChildren.get(j));
            }
            for (int c = indexToDelete = startChildIndex + numNewChildren; c <= stopChildIndex; ++c) {
                PythonTree pythonTree = this.children.remove(indexToDelete);
            }
            this.freshenParentAndChildIndexes(startChildIndex);
        } else {
            for (int j = 0; j < replacingHowMany; ++j) {
                this.children.set(startChildIndex + j, newChildren.get(j));
            }
            int numToInsert = replacingWithHowMany - replacingHowMany;
            for (int j = replacingHowMany; j < replacingWithHowMany; ++j) {
                this.children.add(startChildIndex + j, newChildren.get(j));
            }
            this.freshenParentAndChildIndexes(startChildIndex);
        }
    }

    protected List<PythonTree> createChildrenList() {
        return new ArrayList<PythonTree>();
    }

    public void freshenParentAndChildIndexes() {
        this.freshenParentAndChildIndexes(0);
    }

    public void freshenParentAndChildIndexes(int offset) {
        int n = this.getChildCount();
        for (int c = offset; c < n; ++c) {
            PythonTree child = this.getChild(c);
            child.setChildIndex(c);
            child.setParent(this);
        }
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        return this.parent != null ? visit.visit(this.parent, arg) : 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && ob == this.parent;
    }
}

