/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import java.awt.Color;
import java.util.Hashtable;

public final class ColorConverter {
    private Hashtable stringToColor = new Hashtable();
    private Hashtable colorToString = new Hashtable();
    private static ColorConverter cc = new ColorConverter();

    static final Color hexToColor(String value) throws ColorConversionException {
        try {
            return Color.decode("0x" + value.substring(1));
        }
        catch (Throwable t) {
            throw new ColorConversionException(value);
        }
    }

    static final Color rgbToColor(String value) throws ColorConversionException {
        int comma1 = value.indexOf(",");
        int comma2 = value.indexOf(",", comma1 + 1);
        if (comma1 < 2 || comma2 < comma1 + 2 || value.length() < comma1 + 2) {
            throw new ColorConversionException(value);
        }
        try {
            String red = value.substring(1, comma1);
            String green = value.substring(comma1 + 1, comma2);
            String blue = value.substring(comma2 + 1, value.length() - 1);
            int r = Integer.parseInt(red);
            int g = Integer.parseInt(green);
            int b = Integer.parseInt(blue);
            return new Color(r, g, b);
        }
        catch (Throwable t) {
            throw new ColorConversionException(value);
        }
    }

    public static Color stringToHTMLColor(String str) throws ColorConversionException {
        if (str == null || str.equals("") || str.equals("default")) {
            return null;
        }
        if (str.charAt(0) == '#') {
            return ColorConverter.hexToColor(str);
        }
        if (str.charAt(0) == '(') {
            return ColorConverter.rgbToColor(str);
        }
        Color c = (Color)ColorConverter.cc.stringToColor.get(str.toLowerCase());
        if (c == null) {
            throw new ColorConversionException(str);
        }
        return c;
    }

    public static String colorToString(Color c) {
        if (c == null) {
            return "default";
        }
        String s = (String)ColorConverter.cc.colorToString.get(c);
        if (s != null) {
            return s;
        }
        return "(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ")";
    }

    private ColorConverter() {
        this.addEntry(Color.black, "Black");
        this.addEntry(Color.blue, "Blue");
        this.addEntry(Color.cyan, "Cyan");
        this.addEntry(Color.darkGray, "Dark Gray");
        this.addEntry(Color.gray, "Gray");
        this.addEntry(Color.green, "Green");
        this.addEntry(Color.lightGray, "Light Gray");
        this.addEntry(Color.magenta, "Magenta");
        this.addEntry(Color.orange, "Orange");
        this.addEntry(Color.pink, "Pink");
        this.addEntry(Color.red, "Red");
        this.addEntry(Color.white, "White");
        this.addEntry(Color.yellow, "Yellow");
        this.addEntry(new Color(0, 0, 0), "Black");
        this.addEntry(new Color(192, 192, 192), "Silver");
        this.addEntry(new Color(128, 128, 128), "Gray");
        this.addEntry(new Color(255, 255, 255), "White");
        this.addEntry(new Color(128, 0, 0), "Maroon");
        this.addEntry(new Color(255, 0, 0), "Red");
        this.addEntry(new Color(128, 0, 128), "Purple");
        this.addEntry(new Color(255, 0, 255), "Fuchsia");
        this.addEntry(new Color(0, 128, 0), "Green");
        this.addEntry(new Color(0, 255, 0), "Lime");
        this.addEntry(new Color(128, 128, 0), "Olive");
        this.addEntry(new Color(255, 255, 0), "Yellow");
        this.addEntry(new Color(0, 0, 128), "Navy");
        this.addEntry(new Color(0, 0, 255), "Blue");
        this.addEntry(new Color(0, 128, 128), "Teal");
        this.addEntry(new Color(0, 255, 255), "Aqua");
        this.addEntry(new Color(0.1f, 0.1f, 0.1f), "Gray 10%");
        this.addEntry(new Color(0.2f, 0.2f, 0.2f), "Gray 20%");
        this.addEntry(new Color(0.3f, 0.3f, 0.3f), "Gray 30%");
        this.addEntry(new Color(0.4f, 0.4f, 0.4f), "Gray 40%");
        this.addEntry(new Color(0.5f, 0.5f, 0.5f), "Gray 50%");
        this.addEntry(new Color(0.6f, 0.6f, 0.6f), "Gray 60%");
        this.addEntry(new Color(0.7f, 0.7f, 0.7f), "Gray 70%");
        this.addEntry(new Color(0.8f, 0.8f, 0.8f), "Gray 80%");
        this.addEntry(new Color(0.9f, 0.9f, 0.9f), "Gray 90%");
        this.addEntry(new Color(255, 136, 28), "Orange");
        this.addEntry(new Color(120, 62, 27), "Brown");
        this.addEntry(new Color(0, 125, 32), "Forest Green");
        this.addEntry(new Color(11, 157, 150), "Turquoise");
        this.addEntry(new Color(109, 0, 168), "Purple");
        this.addEntry(new Color(168, 0, 126), "Magenta");
        this.addEntry(new Color(164, 207, 255), "Sky Blue");
        this.addEntry(new Color(225, 170, 255), "Violet");
        this.addEntry(new Color(255, 170, 210), "Light Magenta");
    }

    private void addEntry(Color c, String name) {
        this.stringToColor.put(name.toLowerCase(), c);
        this.colorToString.put(c, name);
    }

    public static class ColorConversionException
    extends Exception {
        ColorConversionException(String value) {
            super("Cannot convert " + value + " to Color");
        }
    }
}

